/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support.graphics;

import com.sas.actionprovider.ActionAttributeDescriptor;
import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.support.graphics.BaseGraphSupport;
import com.sas.actionprovider.support.graphics.ColumnNameResolver;
import com.sas.actionprovider.support.graphics.DefaultColumnNameResolver;
import com.sas.actionprovider.support.graphics.DefaultGraphValueResolver;
import com.sas.actionprovider.support.graphics.GraphValueResolver;
import com.sas.actionprovider.support.graphics.RB;
import com.sas.actionprovider.support.graphics.ResizeCommand;
import com.sas.actionprovider.support.graphics.ZoomInCommand;
import com.sas.actionprovider.support.graphics.ZoomOutCommand;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.relational.SortCommand;
import com.sas.entities.AttributeDescriptorInterface;
import com.sas.swing.visuals.util.Util;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.TableModel;

public class HttpGraphSupport
extends BaseGraphSupport {
    public static final String RB_KEY = "HttpGraphSupport.";
    public static final String CATEGORIZATION_LABEL_ACTION = "CATEGORIZATION_LABEL_ACTION";
    public static final String ANALYSIS_LABEL_ACTION = "ANALYSIS_LABEL_ACTION";
    public static final String RESIZE_GRAPH_ACTION = "RESIZE_GRAPH_ACTION";
    public static final String ZOOM_IN_GRAPH_ACTION = "ZOOM_IN_GRAPH_ACTION";
    public static final String ZOOM_OUT_GRAPH_ACTION = "ZOOM_OUT_GRAPH_ACTION";
    private ColumnNameResolver _columnNameResolver = new DefaultColumnNameResolver();
    private GraphValueResolver _graphValueResolver = new DefaultGraphValueResolver();

    public HttpGraphSupport(Class actionClass) {
        super(actionClass);
        this.addAreaType("DATA_VALUE_AREA");
    }

    protected BaseAction defineActionAttributes(BaseAction action, String actionType) {
        if (action != null) {
            action.setActionType(actionType);
            if (actionType.equals("ASCENDING_SORT_ACTION") || actionType.equals("DESCENDING_SORT_ACTION")) {
                try {
                    action.setAttribute("model", null);
                    AttributeDescriptorInterface descriptor = action.getAttributeDescriptor("model");
                    descriptor.setType(BaseAction.getAttributeTypeFactory().createAttributeType(null, 2000, "javax.swing.table.TableModel"));
                    descriptor.setVisible(false);
                    descriptor = action.getAttributeDescriptor("column");
                    descriptor.setVisible(false);
                }
                catch (Exception descriptor) {}
            } else if (actionType.equals(ZOOM_IN_GRAPH_ACTION) || actionType.equals(ZOOM_OUT_GRAPH_ACTION)) {
                try {
                    action.setAttribute("row", null);
                    AttributeDescriptorInterface descriptor = action.getAttributeDescriptor("row");
                    descriptor.setVisible(true);
                    action.setAttribute("zoomInPath", null);
                    descriptor = action.getAttributeDescriptor("zoomInPath");
                    descriptor.setVisible(true);
                    if (descriptor instanceof ActionAttributeDescriptor) {
                        ((ActionAttributeDescriptor)descriptor).setEncode(false);
                    }
                    action.setAttribute("zoomOutPath", null);
                    descriptor = action.getAttributeDescriptor("zoomOutPath");
                    descriptor.setVisible(true);
                    if (descriptor instanceof ActionAttributeDescriptor) {
                        ((ActionAttributeDescriptor)descriptor).setEncode(false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return action;
    }

    public BaseAction newActionInstance(String actionType) {
        return this.newActionInstance(null, actionType);
    }

    public BaseAction newActionInstance(String areaType, String actionType) {
        HttpAction action = null;
        Class _actionClass = this.getActionClass();
        if (this.debug) {
            System.out.println("Class for " + actionType + " is " + _actionClass.getName());
        }
        if (_actionClass != null) {
            try {
                action = (HttpAction)((Object)_actionClass.newInstance());
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (IllegalAccessException ie) {
                return null;
            }
            if (actionType == CATEGORIZATION_LABEL_ACTION) {
                action.putValue("Name", "%areaValue");
                action.putValue("ShortDescription", com.sas.actionprovider.support.tableview.RB.getStringResource((String)"BaseTableViewSupport.", (String)"clickForOptions.txt", (Locale)this.getLocale()));
                action.setLink(false);
            } else if (actionType == ANALYSIS_LABEL_ACTION) {
                action.putValue("Name", "%areaValue");
                action.putValue("ShortDescription", com.sas.actionprovider.support.tableview.RB.getStringResource((String)"BaseTableViewSupport.", (String)"clickForOptions.txt", (Locale)this.getLocale()));
                action.setLink(false);
            } else if (actionType == "ASCENDING_SORT_ACTION") {
                String commandName = com.sas.commands.relational.RB.getStringResource((String)"SortCommand.", (String)"sortAscending.txt", (Locale)this.getLocale());
                action.setCommand((DynamicAttributeCommandInterface)new SortCommand(commandName, 0));
                action.putValue("Name", commandName);
                action.putValue("model", null);
                action.putValue("column", null);
                action.setReturnStatus(24);
                if (areaType == "ANALYSIS_LABEL_AREA") {
                    action.putValue("ShortDescription", RB.getStringResource(RB_KEY, "sortAscendingBy.txt", this.getLocale()));
                } else {
                    action.putValue("ShortDescription", Util.getLabelWithoutMnemonic((String)com.sas.commands.relational.RB.getStringResource((String)"SortCommand.", (String)"sortAscending.txt", (Locale)this.getLocale())));
                }
            } else if (actionType == "DESCENDING_SORT_ACTION") {
                String commandName = com.sas.commands.relational.RB.getStringResource((String)"SortCommand.", (String)"sortDescending.txt", (Locale)this.getLocale());
                action.setCommand((DynamicAttributeCommandInterface)new SortCommand(commandName, 1));
                action.putValue("Name", commandName);
                action.putValue("model", null);
                action.putValue("column", null);
                action.setReturnStatus(24);
                if (areaType == "ANALYSIS_LABEL_AREA") {
                    action.putValue("ShortDescription", RB.getStringResource(RB_KEY, "sortDescendingBy.txt", this.getLocale()));
                } else {
                    action.putValue("ShortDescription", Util.getLabelWithoutMnemonic((String)com.sas.commands.relational.RB.getStringResource((String)"SortCommand.", (String)"sortDescending.txt", (Locale)this.getLocale())));
                }
            } else if (actionType == RESIZE_GRAPH_ACTION) {
                ResizeCommand resizeCommand = new ResizeCommand();
                action.setCommand((DynamicAttributeCommandInterface)resizeCommand);
                action.putValue("resizedColumns", null);
                action.getAttributeDescriptor("resizedColumns").setVisible(false);
            } else if (actionType == ZOOM_IN_GRAPH_ACTION) {
                action.setCommand((DynamicAttributeCommandInterface)new ZoomInCommand());
                action.putValue("tilechart", null);
                action.getAttributeDescriptor("tilechart").setVisible(false);
                action.putValue("ShortDescription", RB.getStringResource(RB_KEY, "zoomInTo.txt", this.getLocale()));
            } else if (actionType == ZOOM_OUT_GRAPH_ACTION) {
                action.setCommand((DynamicAttributeCommandInterface)new ZoomOutCommand());
                action.putValue("tilechart", null);
                action.getAttributeDescriptor("tilechart").setVisible(false);
                action.putValue("ShortDescription", RB.getStringResource(RB_KEY, "zoomOutTo.txt", this.getLocale()));
            } else {
                return null;
            }
            action.setActionType(actionType);
            this.defineActionAttributes(action, actionType);
        }
        return action;
    }

    protected void createDefaultActions() {
        super.createDefaultActions();
        HttpAction categorizationLabelAction = (HttpAction)this.newActionInstance("CATEGORIZATION_LABEL_AREA", CATEGORIZATION_LABEL_ACTION);
        HttpAction analysisLabelAction = (HttpAction)this.newActionInstance("ANALYSIS_LABEL_AREA", ANALYSIS_LABEL_ACTION);
        ActionOrderList categorizationLabelOrderList = new ActionOrderList("ROOT_NAME", 2);
        categorizationLabelOrderList.setActionType(CATEGORIZATION_LABEL_ACTION);
        categorizationLabelOrderList.add((Object)"ASCENDING_SORT_ACTION");
        categorizationLabelOrderList.add((Object)"DESCENDING_SORT_ACTION");
        this.setActionOrderList(categorizationLabelOrderList, null, "CATEGORIZATION_LABEL_AREA");
        HttpAction labelSortDescendingAction = (HttpAction)this.newActionInstance("CATEGORIZATION_LABEL_AREA", "ASCENDING_SORT_ACTION");
        HttpAction labelSortAscendingAction = (HttpAction)this.newActionInstance("CATEGORIZATION_LABEL_AREA", "DESCENDING_SORT_ACTION");
        this.addDefaultAction(categorizationLabelAction, "CATEGORIZATION_LABEL_AREA");
        this.addDefaultAction(labelSortAscendingAction, "CATEGORIZATION_LABEL_AREA");
        this.addDefaultAction(labelSortDescendingAction, "CATEGORIZATION_LABEL_AREA");
        ActionOrderList analysisLabelOrderList = new ActionOrderList("ROOT_NAME", 2);
        analysisLabelOrderList.setActionType(ANALYSIS_LABEL_ACTION);
        analysisLabelOrderList.add((Object)"ASCENDING_SORT_ACTION");
        analysisLabelOrderList.add((Object)"DESCENDING_SORT_ACTION");
        this.setActionOrderList(analysisLabelOrderList, null, "ANALYSIS_LABEL_AREA");
        HttpAction analysisLabelSortDescendingAction = (HttpAction)this.newActionInstance("ANALYSIS_LABEL_AREA", "ASCENDING_SORT_ACTION");
        HttpAction analysisLabelSortAscendingAction = (HttpAction)this.newActionInstance("ANALYSIS_LABEL_AREA", "DESCENDING_SORT_ACTION");
        this.addDefaultAction(analysisLabelAction, "ANALYSIS_LABEL_AREA");
        this.addDefaultAction(analysisLabelSortAscendingAction, "ANALYSIS_LABEL_AREA");
        this.addDefaultAction(analysisLabelSortDescendingAction, "ANALYSIS_LABEL_AREA");
        HttpAction resizeAction = (HttpAction)this.newActionInstance("DATA_VALUE_AREA", RESIZE_GRAPH_ACTION);
        this.addDefaultAction(resizeAction, "DATA_VALUE_AREA");
        HttpAction zoomInAction = (HttpAction)this.newActionInstance("DATA_VALUE_AREA", ZOOM_IN_GRAPH_ACTION);
        this.addDefaultAction(zoomInAction, "DATA_VALUE_AREA");
        HttpAction zoomOutAction = (HttpAction)this.newActionInstance("DATA_VALUE_AREA", ZOOM_OUT_GRAPH_ACTION);
        this.addDefaultAction(zoomOutAction, "DATA_VALUE_AREA");
    }

    protected Map getAreaScopeAttributeMap(ActionSupportFilter filter) {
        HashMap<String, Object> areaScopeAttributeMap = new HashMap<String, Object>();
        String areaType = filter.getAreaType();
        if (areaType.equals("CATEGORIZATION_VALUE_AREA") || areaType.equals("CATEGORIZATION_LABEL_AREA") || areaType.equals("ANALYSIS_LABEL_AREA")) {
            try {
                areaScopeAttributeMap.put("model", filter.getAttribute("model"));
                areaScopeAttributeMap.put("column", filter.getAttribute("column"));
                areaScopeAttributeMap.put("areaValue", filter.getAttribute("areaValue"));
            }
            catch (Exception exception) {}
        } else if (areaType.equals("DATA_VALUE_AREA")) {
            areaScopeAttributeMap.put("resizedColumns", filter.getAttribute("resizedColumns"));
            areaScopeAttributeMap.put("tilechart", filter.getAttribute("tilechart"));
            areaScopeAttributeMap.put("row", filter.getAttribute("row"));
            areaScopeAttributeMap.put("zoomInPath", filter.getAttribute("zoomInPath"));
            areaScopeAttributeMap.put("zoomOutPath", filter.getAttribute("zoomOutPath"));
            areaScopeAttributeMap.put("zoominlabel", filter.getAttribute("zoominlabel"));
            areaScopeAttributeMap.put("zoomoutlabel", filter.getAttribute("zoomoutlabel"));
        }
        return areaScopeAttributeMap;
    }

    protected boolean validArea(Area area, ActionSupportFilter filter) {
        return true;
    }

    protected Map initializeShortActionTypeMap() {
        Map shortActionTypeMap = super.initializeShortActionTypeMap();
        shortActionTypeMap.put(ANALYSIS_LABEL_ACTION, "_AL");
        shortActionTypeMap.put(CATEGORIZATION_LABEL_ACTION, "_CL");
        shortActionTypeMap.put("ASCENDING_SORT_ACTION", "_AS");
        shortActionTypeMap.put("DESCENDING_SORT_ACTION", "_DS");
        return shortActionTypeMap;
    }

    protected Object getCustomAttributeValue(String attributeName, ActionSupportFilter filter) {
        Object object = filter.getAttribute("model");
        Object valueAt = null;
        if (object instanceof TableModel) {
            TableModel tableModel = (TableModel)object;
            String columnName = this._columnNameResolver.getColumnName(tableModel, attributeName);
            Object imageMapInfo = filter.getAttribute("imagemapinfo");
            valueAt = this._graphValueResolver.getValueAt(imageMapInfo, (Integer)filter.getAttribute("row"), columnName);
        }
        return valueAt;
    }
}

