/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support;

import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.HttpActionProviderViewInterface;
import com.sas.actionprovider.URLTemplateViewInterface;
import com.sas.actionprovider.support.BaseViewerSupport;
import com.sas.actionprovider.support.RB;
import com.sas.codepolicy.SASScope;
import com.sas.util.SimpleTemplate;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;

@SASScope(value="ALL")
public class HttpViewerSupport
extends BaseViewerSupport
implements HttpActionProviderViewInterface,
URLTemplateViewInterface {
    static final String RB_KEY = "HttpViewerSupport.";
    private HttpActionProvider actionProvider;
    private String name;
    private HttpServletRequest request;
    private SimpleTemplate URLTemplate;
    private HttpActionProvider _tempActionProvider;

    public HttpViewerSupport() {
    }

    public HttpViewerSupport(ActionProviderViewInterface viewer) {
        super(viewer);
    }

    @Override
    public SimpleTemplate getURLTemplate() {
        return this.URLTemplate;
    }

    @Override
    public void setURLTemplate(SimpleTemplate URLTemplate) {
        this.URLTemplate = URLTemplate;
    }

    @Override
    public HttpActionProvider getActionProvider() {
        return this.actionProvider;
    }

    @Override
    public void setActionProvider(HttpActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    public Collection listAreaTypes() {
        String actionSupportType = this.getActionSupportType();
        if (actionSupportType == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"actionSupportTypeNotSet.txt"));
        }
        return this.getAP().listAreaTypes(this.getActionSupportType());
    }

    public Collection listActionTypes(String areaType) {
        String actionSupportType = this.getActionSupportType();
        if (actionSupportType == null) {
            throw new IllegalStateException(RB.getStringResource((String)RB_KEY, (String)"actionSupportTypeNotSet.txt"));
        }
        if (areaType == null) {
            throw new IllegalArgumentException(RB.getStringResource((String)RB_KEY, (String)"nullAreaType.txt"));
        }
        return this.getAP().listActionTypes(this.getActionSupportType(), areaType);
    }

    private HttpActionProvider getAP() {
        HttpActionProvider ap = this.getActionProvider();
        if (ap == null) {
            if (this._tempActionProvider == null) {
                this._tempActionProvider = new HttpActionProvider();
            }
        } else {
            return ap;
        }
        return this._tempActionProvider;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }
}

