/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.strategies.remotefile2;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.strategies.remotefile2.BaseDataCellStrategy;
import com.sas.actionprovider.strategies.remotefile2.RB;
import com.sas.actionprovider.util.remotefile2.HttpRemoteFileActionUtil;
import com.sas.actionprovider.util.remotefile2.RemoteFileActionUtil;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.servlet.tbeans.tableview.TableViewActionSupportFilter;
import com.sas.swing.models.SortableTableModelAdapter;
import com.sas.swing.models.remotefileselector2.BaseRemoteFileModelInterface;
import com.sas.swing.models.remotefileselector2.RemoteFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesFileMetadataInterface;
import com.sas.swing.models.remotefileselector2.informationservices.InformationServicesNavigationModel;
import java.rmi.RemoteException;
import java.util.Locale;

public class SelectFileStrategy
extends BaseDataCellStrategy {
    static final String RB_KEY = "RemoteFileStrategy.";

    public SelectFileStrategy() {
    }

    public SelectFileStrategy(boolean swing, RemoteFileActionUtil util) {
        super(swing, util);
    }

    protected void initializeActionAttributes(BaseAction action, String areaType, Locale locale) {
        super.initializeActionAttributes(action, areaType, locale);
        ((HttpAction)action).setExternal(true);
        action.putValue("Name", null);
        action.putValue("model", null);
        action.getAttributeDescriptor("model").setVisible(false);
        action.putValue("ShortDescription", null);
        action.getAttributeDescriptor("ShortDescription").setSupplementalProperty("DYNAMIC", (Object)Boolean.TRUE);
        action.putValue("AlternateText", null);
        action.getAttributeDescriptor("AlternateText").setSupplementalProperty("DYNAMIC", (Object)Boolean.TRUE);
        action.putValue("SmallIconName", null);
        action.getAttributeDescriptor("SmallIconName").setSupplementalProperty("DYNAMIC", (Object)Boolean.TRUE);
        action.putValue("ImageKey", null);
        action.getAttributeDescriptor("ImageKey").setSupplementalProperty("DYNAMIC", (Object)Boolean.TRUE);
    }

    public void setLocaleDependentDefaultAttributes(BaseAction action, String areaType, Locale locale) {
        super.setLocaleDependentDefaultAttributes(action, areaType, locale);
    }

    protected void initialize() {
        super.initialize();
        this.addDynamicValueInfo("Name", "getAreaValue", null);
    }

    protected Object getDynamicValue(String valueName, ActionSupportFilter filter, Object defaultValue) {
        Locale locale = filter.getLocale();
        SortableTableModelAdapter sortModel = (SortableTableModelAdapter)filter.getAttribute("model");
        BaseRemoteFileModelInterface rfsModel = (BaseRemoteFileModelInterface)sortModel.getModel();
        RemoteFileMetadataInterface node = rfsModel.getNodeAt(sortModel.convertRowIndexToModel(((TableViewActionSupportFilter)filter).getModelRow()));
        if (node instanceof InformationServicesFileMetadataInterface && !node.isFolder()) {
            String iconName = null;
            if (valueName.equals("SmallIconName")) {
                iconName = this.getIconNameUsingTypeDescriptor(rfsModel, node);
            }
            if (iconName != null) {
                return iconName;
            }
            PathUrl nodePathUrl = new PathUrl(node.getLocation());
            String nodeType = nodePathUrl.getType();
            if (nodeType != null) {
                if (nodeType.equals("Report")) {
                    if (valueName.equals("ImageKey")) {
                        return "Report";
                    }
                    if (valueName.equals("ShortDescription")) {
                        return RB.getStringResource((String)RB_KEY, (String)"report.txt", (Locale)locale);
                    }
                    if (valueName.equals("AlternateText")) {
                        return RB.getStringResource((String)RB_KEY, (String)"report.txt", (Locale)locale);
                    }
                } else if (nodeType.equals("BriefInformationMap")) {
                    if (valueName.equals("ImageKey")) {
                        return "Information_Map";
                    }
                    if (valueName.equals("ShortDescription")) {
                        return RB.getStringResource((String)RB_KEY, (String)"informationMap.txt", (Locale)locale);
                    }
                    if (valueName.equals("AlternateText")) {
                        return RB.getStringResource((String)RB_KEY, (String)"informationMap.txt", (Locale)locale);
                    }
                } else if (nodeType.equals("StoredProcess")) {
                    if (valueName.equals("ImageKey")) {
                        return "Stored_Process";
                    }
                    if (valueName.equals("ShortDescription")) {
                        return RB.getStringResource((String)RB_KEY, (String)"storedProcess.txt", (Locale)locale);
                    }
                    if (valueName.equals("AlternateText")) {
                        return RB.getStringResource((String)RB_KEY, (String)"storedProcess.txt", (Locale)locale);
                    }
                } else if (nodeType.equals("DataExploration")) {
                    if (valueName.equals("ImageKey")) {
                        return "Data_Set_Explore";
                    }
                    if (valueName.equals("ShortDescription")) {
                        return RB.getStringResource((String)RB_KEY, (String)"dataExploration.txt", (Locale)locale);
                    }
                    if (valueName.equals("AlternateText")) {
                        return RB.getStringResource((String)RB_KEY, (String)"dataExploration.txt", (Locale)locale);
                    }
                } else {
                    if (valueName.equals("ImageKey")) {
                        return "Generic_SAS_Object";
                    }
                    if (valueName.equals("ShortDescription")) {
                        return RB.getStringResource((String)RB_KEY, (String)"genericFile.txt", (Locale)locale);
                    }
                    if (valueName.equals("AlternateText")) {
                        return RB.getStringResource((String)RB_KEY, (String)"genericFile.txt", (Locale)locale);
                    }
                }
            } else {
                if (valueName.equals("ImageKey")) {
                    return "File";
                }
                if (valueName.equals("ShortDescription")) {
                    return RB.getStringResource((String)RB_KEY, (String)"genericFile.txt", (Locale)locale);
                }
                if (valueName.equals("AlternateText")) {
                    return RB.getStringResource((String)RB_KEY, (String)"genericFile.txt", (Locale)locale);
                }
            }
        } else if (node != null && !node.isFolder()) {
            if (valueName.equals("ImageKey")) {
                return "File";
            }
            if (valueName.equals("ShortDescription")) {
                return RB.getStringResource((String)RB_KEY, (String)"genericFile.txt", (Locale)locale);
            }
            if (valueName.equals("AlternateText")) {
                return RB.getStringResource((String)RB_KEY, (String)"genericFile.txt", (Locale)locale);
            }
        }
        return super.getDynamicValue(valueName, filter, defaultValue);
    }

    private String getIconNameUsingTypeDescriptor(BaseRemoteFileModelInterface rfsModel, RemoteFileMetadataInterface node) {
        ServerInterface server;
        if (rfsModel != null && rfsModel instanceof InformationServicesNavigationModel && (server = ((InformationServicesNavigationModel)rfsModel).getServer()) != null && node instanceof InformationServicesFileMetadataInterface) {
            try {
                TypeDescriptorInterface typeDescriptor = server.getTypeDescriptor(((InformationServicesFileMetadataInterface)node).getType());
                if (typeDescriptor != null) {
                    return typeDescriptor.getIconName();
                }
            }
            catch (ServiceException e) {
                return null;
            }
            catch (RemoteException e) {
                return null;
            }
        }
        return null;
    }

    public int getActionStatus(BaseAction action, ActionSupportFilter filter) {
        return ((HttpRemoteFileActionUtil)((Object)this.getUtilObject())).getSelectFileStatus(filter, super.getActionStatus(action, filter));
    }
}

