/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.strategies.dataselector;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProviderViewInterface;
import com.sas.actionprovider.SelectorAction;
import com.sas.actionprovider.strategies.dataselector.BaseDataSelectorStrategy;
import com.sas.actionprovider.strategies.dataselector.RB;
import com.sas.actionprovider.util.dataselector.SelectorActionUtil;
import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.commands.dataselectors.FilterAndRankSelectorCommand;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;

@SASScope(value="ALL")
public class FilterAndRankStrategy
extends BaseDataSelectorStrategy {
    static final String RB_KEY = "DataSelectorStrategy.";
    public static final String ATTR_TITLE = "title";
    public static final String SELECTOR_KEY = "selectorKey";
    public static final String TUPLE_ELEMENT = "tupleElement";

    public FilterAndRankStrategy() {
    }

    public FilterAndRankStrategy(boolean swing, SelectorActionUtil util) {
        super(swing, util);
    }

    @Override
    protected void initializeActionAttributes(BaseAction action, String areaType, Locale locale) {
        super.initializeActionAttributes(action, areaType, locale);
        action.setCommand((DynamicAttributeCommandInterface)new FilterAndRankSelectorCommand());
        ((HttpAction)action).setURLBase("SelectorServlet");
        action.getAttributeDescriptor("URLBase").setSupplementalProperty("DYNAMIC", (Object)Boolean.TRUE);
        ((SelectorAction)action).setSelectorWidth(361);
        ((SelectorAction)action).setSelectorHeight(319);
        action.putValue("Name", null);
        action.getAttributeDescriptor("Name").setSupplementalProperty("DYNAMIC", (Object)Boolean.FALSE);
        action.putValue("ShortDescription", null);
        action.getAttributeDescriptor("ShortDescription").setSupplementalProperty("DYNAMIC", (Object)Boolean.FALSE);
        action.putValue(ATTR_TITLE, null);
        action.getAttributeDescriptor(ATTR_TITLE).setSupplementalProperty("DYNAMIC", (Object)Boolean.FALSE);
        action.getAttributeDescriptor(ATTR_TITLE).setSupplementalProperty("EXTERNAL", (Object)Boolean.TRUE);
        action.putValue(SELECTOR_KEY, (Object)"FILTER_AND_RANK_SELECTOR");
        action.getAttributeDescriptor(SELECTOR_KEY).setSupplementalProperty("DYNAMIC", (Object)Boolean.FALSE);
        action.getAttributeDescriptor(SELECTOR_KEY).setSupplementalProperty("ENCODE", (Object)Boolean.FALSE);
        action.putValue(TUPLE_ELEMENT, null);
        action.getAttributeDescriptor(TUPLE_ELEMENT).setVisible(false);
        action.putValue("viewerId", null);
    }

    public void setLocaleDependentDefaultAttributes(BaseAction action, String areaType, Locale locale) {
        super.setLocaleDependentDefaultAttributes(action, areaType, locale);
        action.putValue("Name", (Object)RB.getStringResource(RB_KEY, "filterRank.txt", locale));
        String description = RB.getStringResource(RB_KEY, "filterRankActionShortDescription.txt", locale);
        action.putValue("ShortDescription", (Object)description);
        action.putValue(ATTR_TITLE, (Object)description);
    }

    public int getActionStatus(BaseAction action, ActionSupportFilter filter) {
        return ((SelectorActionUtil)this.getUtilObject()).getDisabledIfMeasureAndNotLastElement(filter, super.getActionStatus(action, filter));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.addDynamicValueInfo(TUPLE_ELEMENT, null, null);
        this.addDynamicValueInfo("viewerId", null, null);
    }

    protected Object getDynamicValue(String valueName, ActionSupportFilter filter, Object defaultValue) {
        if (defaultValue == null || valueName == null || !valueName.equals("URLBase")) {
            return super.getDynamicValue(valueName, filter, defaultValue);
        }
        HttpActionProviderViewInterface viewer = (HttpActionProviderViewInterface)filter.getViewer();
        HttpServletRequest request = viewer.getRequest();
        if (request != null) {
            return request.getContextPath() + "/SelectorServlet";
        }
        return "SelectorServlet";
    }
}

