/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.refresh;

import com.sas.actionprovider.HttpActionProvider;
import com.sas.servlet.tbeans.TransformationInterface2;
import com.sas.servlet.tbeans.tableview.ajax.AJAXPacket;
import com.sas.servlet.util.ComponentSessionManager;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerRepository2;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class PartialRefreshActionHandler {
    private static CommonLoggerInterface _log;
    public static final String CONTAINER_ID_PARM = "containerId";
    public static final String DEFAULT_PARTIAL_REFRESH_URL_TEMPLATE = "javascript: void(sas.ajax.doAction('%AJAX_CONTROLLER_URL%QUERYSTRING&CLASS_PARAMETER=com.sas.actionprovider.refresh.PartialRefreshActionHandler&refreshViewerId=%REFRESHVIEWERID&_referringURI=%REFERRINGURI'));";

    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) {
        HttpActionProvider ap = null;
        String apName = request.getParameter("APNAME");
        if (apName != null) {
            ap = (HttpActionProvider)((Object)request.getSession().getAttribute(apName));
        }
        if (ap != null) {
            try {
                ap.executeCommand(request, response, null);
            }
            catch (Exception e) {
                PartialRefreshActionHandler.getLog().error(e.getMessage(), (Throwable)e);
            }
        }
        String viewerId = request.getParameter("refreshViewerId");
        TransformationInterface2 tbean = (TransformationInterface2)ComponentSessionManager.getSessionManager(request).get(viewerId);
        if (tbean == null) {
            throw new IllegalStateException("PartialRefreshActionHandler: Could not find the view component that needs refresh on the session.");
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            tbean.writePartialRefresh(request, response, pw);
            new AJAXPacket().add(sw.toString(), CONTAINER_ID_PARM, tbean.getContainerId()).send(response);
        }
        catch (IOException ioe) {
            PartialRefreshActionHandler.getLog().error(ioe.getMessage(), (Throwable)ioe);
        }
    }

    private static CommonLoggerInterface getLog() {
        if (_log == null) {
            _log = LoggerRepository2.getLogger((String)PartialRefreshActionHandler.class.getName(), null);
        }
        return _log;
    }
}

