/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.codepolicy.SASScope;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class StoredProperties {
    private int capacity = 0;
    private int size = 0;
    public Object[] _keys = null;
    public Object[] _values = null;

    public StoredProperties() {
        this(10);
    }

    public StoredProperties(int capacity) {
        this.capacity = capacity;
    }

    public StoredProperties(StoredProperties sp) {
        this.capacity = sp.size();
        Object[] keys = sp.getKeys();
        Object[] values = sp.getValues();
        for (int i = 0; i < this.capacity; ++i) {
            this.putValue(keys[i], values[i]);
        }
    }

    public StoredProperties(Map<String, Object> map) {
        this.capacity = map.size();
        for (String key : map.keySet()) {
            this.putValue(key, map.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putValue(Object key, Object value) {
        if (key == null) {
            return;
        }
        Object[] keys = this.getKeys();
        Object[] values = this.getValues();
        Object[] objectArray = keys;
        synchronized (keys) {
            Object[] newKeys;
            for (int i = 0; i < this.capacity; ++i) {
                Object currentKey = keys[i];
                if (currentKey != null && !currentKey.equals(key)) continue;
                keys[i] = key;
                values[i] = value;
                if (currentKey == null) {
                    ++this.size;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
            this.capacity += 5;
            this.allocateInternalDataStructures();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            Object[] objectArray2 = newKeys = this.getKeys();
            synchronized (newKeys) {
                Object[] newValues = this.getValues();
                for (int i = 0; i < keys.length && keys[i] != null; ++i) {
                    newKeys[i] = keys[i];
                    newValues[i] = values[i];
                }
                newKeys[i] = key;
                newValues[i] = value;
                ++this.size;
                // ** MonitorExit[var6_7] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Object key) {
        Object[] keys;
        if (key == null) {
            return null;
        }
        Object[] objectArray = keys = this.getKeys();
        synchronized (keys) {
            Object[] values = this.getValues();
            for (int i = 0; i < this.size; ++i) {
                if (!keys[i].equals(key)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return values[i];
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return null;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Object[] keys;
        Object[] objectArray = keys = this.getKeys();
        synchronized (keys) {
            for (int i = 0; i < this.size; ++i) {
                if (!keys[i].equals(key)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(StoredProperties sp) {
        if (sp == null || sp.size != this.size) {
            return false;
        }
        if (this._keys == null) {
            return sp._keys == null;
        }
        Object[] objectArray = this._keys;
        synchronized (this._keys) {
            for (int i = 0; i < this.size; ++i) {
                boolean foundKey = false;
                for (int j = 0; j < this.size; ++j) {
                    if (!this._keys[j].equals(sp._keys[i])) continue;
                    foundKey = true;
                    Object value = this._values[j];
                    Object spValue = sp._values[i];
                    if (value == spValue) continue;
                    if (value == null || spValue == null) {
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return false;
                    }
                    if (value.equals(spValue)) continue;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return false;
                }
                if (foundKey) continue;
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object[] keys;
        if (this._keys == null) {
            return;
        }
        Object[] objectArray = keys = this.getKeys();
        synchronized (keys) {
            Object[] values = this.getValues();
            for (int i = 0; i < this.size; ++i) {
                values[i] = null;
                keys[i] = null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.size = 0;
            return;
        }
    }

    public Object remove(Object key) {
        int keyIndex = this.getKeyIndex(key);
        if (keyIndex < 0) {
            return null;
        }
        Object[] keys = this.getKeys();
        keys[keyIndex] = null;
        Object[] values = this.getValues();
        Object returnValue = values[keyIndex];
        values[keyIndex] = null;
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> toMap() {
        Object[] keys;
        Map<String, Object> map = Collections.synchronizedMap(new HashMap(this.size + 1, 1.0f));
        Object[] objectArray = keys = this.getKeys();
        synchronized (keys) {
            Object[] values = this.getValues();
            for (int i = 0; i < this.size; ++i) {
                map.put((String)keys[i], values[i]);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return map;
        }
    }

    private Object[] getKeys() {
        if (this._keys != null) {
            return this._keys;
        }
        this.allocateInternalDataStructures();
        return this._keys;
    }

    private Object[] getValues() {
        if (this._values != null) {
            return this._values;
        }
        this.allocateInternalDataStructures();
        return this._values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getKeyIndex(Object key) {
        Object[] keys;
        if (key == null) {
            return -1;
        }
        Object[] objectArray = keys = this.getKeys();
        synchronized (keys) {
            for (int i = 0; i < this.size; ++i) {
                Object currentKey = keys[i];
                if (currentKey != key && !currentKey.equals(key)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return i;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return -1;
        }
    }

    private void allocateInternalDataStructures() {
        this._keys = new Object[this.capacity];
        this._values = new Object[this.capacity];
    }
}

