/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider;

import com.sas.actionprovider.BaseAction;
import com.sas.codepolicy.SASScope;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.util.SimpleTemplate;

@SASScope(value="ALL")
public class HttpAction
extends BaseAction {
    private String cmdId;
    private boolean external;
    private String URLBase;
    private SimpleTemplate URLTemplate;
    private boolean link;
    private boolean escapeDynamicAttributeValues;
    boolean scriptActivated;
    static final String RB_KEY = "HttpAction.";

    public HttpAction() {
        this(null);
    }

    public HttpAction(DynamicAttributeCommandInterface command) {
        super(command);
        this.setLink(true);
        this.setScriptActivated(false);
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    public String getCmdId() {
        return this.cmdId;
    }

    public void setCmdId(String cmdId) {
        this.cmdId = cmdId;
    }

    public SimpleTemplate getURLTemplate() {
        return this.URLTemplate;
    }

    public void setURLTemplate(SimpleTemplate URLTemplate) {
        this.URLTemplate = URLTemplate;
        if (URLTemplate != null) {
            String template = URLTemplate.getTemplate();
            if (template != null) {
                if (template.indexOf("javascript:") != -1) {
                    this.setEscapedDynamicAttributeValues(true);
                } else {
                    this.setEscapedDynamicAttributeValues(false);
                }
            } else {
                this.setEscapedDynamicAttributeValues(false);
            }
        } else {
            this.setEscapedDynamicAttributeValues(false);
        }
    }

    public String getURLBase() {
        return this.URLBase;
    }

    public void setURLBase(String URLBase) {
        this.URLBase = URLBase;
    }

    public boolean isLink() {
        return this.link;
    }

    public void setLink(boolean link) {
        this.link = link;
    }

    public boolean isEscapeDynamicAttributeValues() {
        return this.escapeDynamicAttributeValues;
    }

    public void setEscapedDynamicAttributeValues(boolean escape) {
        this.escapeDynamicAttributeValues = escape;
    }

    @SASScope
    public void reset() {
        super.reset();
        this.cmdId = null;
        this.external = false;
        this.URLBase = null;
        this.URLTemplate = null;
        this.link = true;
        this.escapeDynamicAttributeValues = false;
        this.scriptActivated = false;
    }

    @SASScope
    public static void moveAttributes(BaseAction source, BaseAction target) {
        BaseAction.moveAttributes((BaseAction)source, (BaseAction)target);
        HttpAction s = (HttpAction)source;
        HttpAction t = (HttpAction)target;
        t.setExternal(s.isExternal());
        t.setURLBase(s.getURLBase());
        t.setURLTemplate(s.getURLTemplate());
        t.setLink(s.isLink());
        t.setScriptActivated(s.isScriptActivated());
        t.setEscapedDynamicAttributeValues(s.isEscapeDynamicAttributeValues());
    }

    @SASScope
    public boolean isScriptActivated() {
        return this.scriptActivated;
    }

    @SASScope
    public void setScriptActivated(boolean scriptActivated) {
        this.scriptActivated = scriptActivated;
    }
}

