/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.jaxb;

import jakarta.xml.bind.JAXBContext;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashSet;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.oxm.jaxb.Jaxb2Marshaller;

public class Jaxb2DynamicMarshaller
extends Jaxb2Marshaller {
    private static String JAXB_CONTEXT_PATH_FILE = "classpath*:META-INF/jaxb-context.path";

    protected JAXBContext createJaxbContext() throws Exception {
        this.setDynamicContextPath();
        return super.getJaxbContext();
    }

    protected void setDynamicContextPath() throws Exception {
        Resource[] contextPathResources;
        HashSet<String> contextPath = new HashSet<String>();
        for (Resource resource : contextPathResources = new PathMatchingResourcePatternResolver().getResources(JAXB_CONTEXT_PATH_FILE)) {
            String str;
            BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream()));
            do {
                if ((str = reader.readLine()) == null || str.length() <= 0) continue;
                contextPath.add(str);
            } while (str != null);
        }
        if (contextPath.size() > 0) {
            this.setContextPaths(contextPath.toArray(new String[contextPath.size()]));
        }
    }
}

