/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olapgraphics.html;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.codepolicy.SASScope;
import com.sas.entities.AttributeSetException;
import com.sas.graphics.components.esrimap.ESRIMapDataModel;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.servlet.tbeans.dataselectors.html.OLAPMenuBar;
import com.sas.servlet.tbeans.graphics.ESRIMapMenuFactory;
import com.sas.servlet.tbeans.menubar.BaseMenuBar;
import com.sas.servlet.tbeans.menubar.html.Menu;
import com.sas.servlet.tbeans.menubar.html.SelectorMenuBar;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.storage.olap.OLAPException;
import com.sas.swing.util.ActionList;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;

@SASScope(value="ALL")
public class OLAPESRIMapMenu
extends OLAPMenuBar {
    @SASScope
    private OLAPESRIMapChart map = null;

    public OLAPESRIMapMenu() {
        this.setActionSupportType("ESRIMAP_TOOLBAR_SUPPORT");
    }

    protected void setFilterAttributes(ActionSupportFilter toolbarSupportFilter) {
        super.setFilterAttributes(toolbarSupportFilter);
        try {
            String[] s = this.map.getCrossing();
            if (s != null) {
                toolbarSupportFilter.setAttribute("crossing", s.clone());
            }
            toolbarSupportFilter.setAttribute("geo", (Object)this.map.getGeoString());
            toolbarSupportFilter.setAttribute("mapViewer", (Object)this.map);
            ESRIMapDataModel dm = this.getMap().getDataModel();
            if (dm != null) {
                toolbarSupportFilter.setAttribute("model", (Object)((ESRIMapOLAPDataModel)dm).getModel());
            }
        }
        catch (AttributeSetException e1) {
            e1.printStackTrace();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
    }

    public SelectorMenuBar buildMenuBar() {
        ActionSupportFilter menuBarFilter = this.getDefaultFilter(this.getActionSupportType(), "MAP_TOOLBAR_AREA");
        this.setFilterAttributes(menuBarFilter);
        HttpActionProvider actionProvider = this.getActionProvider();
        com.sas.actionprovider.ActionList selectorActions = this.getSelectorActions(menuBarFilter);
        if (selectorActions == null) {
            return null;
        }
        boolean setId = false;
        ESRIMapMenuFactory uiFactory = new ESRIMapMenuFactory(this.map);
        this.selectorMenubar = (SelectorMenuBar)uiFactory.getMenuBar((ActionList)selectorActions, (BaseMenuBar)this.selectorMenubar);
        String defaultId = new StringBuffer().append(this.getId()).append("_").append("mb").toString();
        this.selectorMenubar.setId(defaultId);
        if (actionProvider != null) {
            actionProvider.returnActionList(selectorActions);
        }
        if (this.selectorMenubar == null) {
            return null;
        }
        this.selectorMenubar.setCellSpacing(0);
        this.selectorMenubar.setUseSpan(false);
        String left = this.getLeftImage();
        String right = this.getRightImage();
        String imageLocation = null;
        imageLocation = actionProvider.getImageLocation();
        if (imageLocation == null) {
            imageLocation = ComponentPropertyManager.getInstance((HttpServletRequest)this.getRequest()).getImageLocation();
        }
        ArrayList mymenus = this.selectorMenubar.getMenus();
        Menu menu1 = (Menu)mymenus.get(0);
        if (left != null) {
            menu1.setLeftImage(imageLocation + left);
        }
        Menu lastmenu = (Menu)mymenus.get(mymenus.size() - 1);
        if (right != null) {
            lastmenu.setRightImage(imageLocation + right);
        }
        return this.selectorMenubar;
    }

    public OLAPESRIMapChart getMap() {
        return this.map;
    }

    public void setMap(OLAPESRIMapChart map) {
        this.map = map;
    }
}

