/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olapgraphics.html;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.form.BaseChoiceBox;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.form.html.Image;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.olapgraphics.html.MapOLAPUtil;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapMenu;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPGraphComposite;
import com.sas.servlet.tbeans.olapgraphics.html.RB;
import com.sas.servlet.tbeans.olaptableview.html.OLAPDrillState;
import com.sas.servlet.util.BaseUtil;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.util.MapWithDefaults;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.Dimension;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;

@SASScope(value="ALL")
public class OLAPESRIMapComposite
extends OLAPGraphComposite
implements FormViewInterface {
    @SASScope
    public static final String MAPCOMPOSITE_CONTAINER_STYLE = "MAPCOMPOSITE_CONTAINER_STYLE";
    public static final String MAPCOMPOSITE_MEASURE_DROPDOWN = "MAPCOMPOSITE_MEASURE_DROPDOWN";
    public static final String MAPCOMPOSITE_LEGEND = "MAPCOMPOSITE_LEGEND";
    public static final String MAPCOMPOSITE_DRILLSTATE = "MAPCOMPOSITE_DRILLSTATE";
    public static final String MAPCOMPOSITE_CROSSING_LABEL = "MAPCOMPOSITE_CROSSING_LABEL";
    public static final String MAPCOMPOSITE_CROSSING_TITLE_LABEL = "MAPCOMPOSITE_CROSSING_TITLE_LABEL";
    @SASScope
    public static final String MAPCOMPOSITE_CROSSING_LABEL_STYLE = "MAPCOMPOSITE_CROSSING_LABEL_STYLE";
    @SASScope
    public static final String MAPCOMPOSITE_CROSSING_TITLE_LABEL_STYLE = "MAPCOMPOSITE_CROSSING_TITLE_LABEL_STYLE";
    private static final String INTERNAL_RB_KEY = "MapComposite.";
    @SASScope
    private OLAPDataSetInterface dataModel = null;
    @SASScope
    private OLAPESRIMapChart mapComponent;
    @SASScope
    private OLAPESRIMapMenu mapMenu;
    @SASScope
    private ChoiceBox choiceBox = null;
    @SASScope
    private Image legendImage = null;
    @SASScope
    private Label crossingTitleLabel = null;
    @SASScope
    private Label crossingLabel = null;
    @SASScope
    private Form formObject;
    @SASScope
    private boolean formEnabled;
    @SASScope
    private HashMap additionalParameters;
    @SASScope
    private static final Map defaultStyleMap = new HashMap();
    @SASScope
    private boolean resetMeasureModelAllowed = true;
    @SASScope
    private boolean useSession = true;

    public OLAPESRIMapComposite() {
        this(null);
    }

    public OLAPESRIMapComposite(OLAPDataSetInterface model) {
        this(model, null, null);
    }

    public OLAPESRIMapComposite(OLAPDataSetInterface dataModel, HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
        OLAPESRIMapComposite.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(defaultStyleMap);
        this.setActionSupportType("ESRIMAP_SUPPORT");
        this.mapComponent = new OLAPESRIMapChart();
        this.choiceBox = new ChoiceBox();
        StyleInfo si = this.choiceBox.getStyleInfo();
        si.setStyle("Width: 150px;");
        this.choiceBox.setStyleInfo(si);
        this.choiceBox.setOnChange(this.mapComponent.getId() + "ESRIMap.setMeasure()");
        this.legendImage = new Image();
        this.legendImage.setEnabled(false);
        this.crossingTitleLabel = new Label();
        this.crossingLabel = new Label();
        this.setModel(dataModel);
        this.setComponent("OLAPGRAPH_CHART", (TransformationInterface)this.mapComponent);
        this.setComponent(MAPCOMPOSITE_MEASURE_DROPDOWN, (TransformationInterface)this.choiceBox);
        this.setComponent(MAPCOMPOSITE_CROSSING_TITLE_LABEL, (TransformationInterface)this.crossingTitleLabel);
        this.setComponent(MAPCOMPOSITE_CROSSING_LABEL, (TransformationInterface)this.crossingLabel);
        this.setComponent(MAPCOMPOSITE_LEGEND, (TransformationInterface)this.legendImage);
        TransformationInterface o = this.getComponent("OLAPGRAPH_MENUBAR");
        if (o != null && o instanceof ActionProviderMenuBar) {
            ((ActionProviderMenuBar)o).setViewer((BaseActionTransformation)this.mapComponent);
        }
        this.mapComponent.setActionProvider(this.getActionProvider());
        this.mapMenu = new OLAPESRIMapMenu();
        this.mapMenu.setMap(this.mapComponent);
        this.mapComponent.setMenuBar((ActionProviderMenuBar)this.mapMenu);
        this.setComponent("OLAPGRAPH_MENUBAR", (TransformationInterface)this.mapMenu);
        this.setTemplateFileName("MapComposite.html");
    }

    @SASScope
    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put(MAPCOMPOSITE_CONTAINER_STYLE, new ImmutableStyleInfo("ESRIMapContainer"));
            defaultStyleMap.put("OLAPGRAPH_TITLE_STYLE", new ImmutableStyleInfo("OLAPGraphTitle"));
            defaultStyleMap.put("OLAPGRAPH_FOOTER_STYLE", new ImmutableStyleInfo("OLAPGraphFooter"));
            defaultStyleMap.put("OLAPGRAPH_TOOLBAR_STYLE", new ImmutableStyleInfo("OLAPGraphToolBar"));
            defaultStyleMap.put(MAPCOMPOSITE_CROSSING_LABEL_STYLE, new ImmutableStyleInfo("ESRIMapCrossingLabel"));
            defaultStyleMap.put(MAPCOMPOSITE_CROSSING_TITLE_LABEL_STYLE, new ImmutableStyleInfo("ESRIMapCrossingLabelTitle"));
        }
    }

    public void setModel(OLAPDataSetInterface dataModel) {
        super.setModel(dataModel);
        if (this.dataModel != dataModel) {
            this.dataModel = dataModel;
            ESRIMapOLAPDataModel model = (ESRIMapOLAPDataModel)this.mapComponent.getDataModel();
            model.setModel(dataModel);
        } else {
            try {
                this.mapComponent.setCrossing(null);
            }
            catch (OLAPException model) {
                // empty catch block
            }
        }
        BaseChoiceBox measureChoiceBox = (BaseChoiceBox)this.getComponent(MAPCOMPOSITE_MEASURE_DROPDOWN);
        if (this.resetMeasureModelAllowed && measureChoiceBox != null) {
            measureChoiceBox.setModel(null);
        }
    }

    public OLAPDataSetInterface getModel() {
        return this.dataModel;
    }

    public void write(PrintWriter out) throws IOException {
        if ((OLAPDrillState)this.getComponent("OLAPGRAPH_DRILLSTATE") != null) {
            ((OLAPDrillState)this.getComponent("OLAPGRAPH_DRILLSTATE")).setModel(this.dataModel);
        }
        Dimension d = this.mapComponent.getLegendSize();
        d.height = 40;
        d.width -= 20;
        this.setMeasureComboBoxSize(d);
        this.choiceBox.setId(this.getActionProvider().getParameterPrefix() + "measure");
        String comboOnChange = this.choiceBox.getOnChange();
        this.legendImage.setUseAsFormElement(false);
        if (!this.mapComponent.isAllActionsVisible()) {
            this.choiceBox.setOnChange("");
        }
        this.mapMenu.setLocale(this.getLocale());
        StyleInfo si = (StyleInfo)this.getStyleMap().get(MAPCOMPOSITE_CROSSING_TITLE_LABEL_STYLE);
        this.crossingTitleLabel.setStyleInfo(si);
        StyleInfo si2 = (StyleInfo)this.getStyleMap().get(MAPCOMPOSITE_CROSSING_LABEL_STYLE);
        this.crossingLabel.setStyleInfo(si2);
        HttpServletRequest request = this.getRequest();
        HttpSession session = null;
        if (this.useSession && request != null) {
            session = request.getSession();
        }
        if (this.useSession && session != null) {
            session.setAttribute("ESRIMap", (Object)this.getComponent("OLAPGRAPH_CHART"));
            session.setAttribute("ESRIMenuBar", (Object)this.getComponent("ESRIMAP_TOOLBAR"));
        }
        this.mapComponent = (OLAPESRIMapChart)this.getComponent("OLAPGRAPH_CHART");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("MAP_ID", this.mapComponent.getId());
        m.put("MAP_CONTAINER_ID", this.getId());
        byte[] mimeData = null;
        if (this.mapComponent.isRedrawComponent() && this.mapComponent.isRedrawMap()) {
            this.mapComponent.performAction(true);
            mimeData = this.mapComponent.getLegendImageMimeData();
        } else if (this.useSession && session != null) {
            mimeData = (byte[])session.getAttribute("sas_StreamContentServlet_ContentBytes" + this.getId());
        } else {
            mimeData = this.mapComponent.getLegendImageMimeData();
            if (mimeData == null) {
                this.mapComponent.performAction(true);
                mimeData = this.mapComponent.getLegendImageMimeData();
            }
        }
        this.resetCrossingLabel();
        String legendURL = null;
        if (this.useSession && session != null) {
            String contentServletURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/StreamContentServlet?" + "CONTENT_KEY" + "=" + this.getId() + "&SRCID=" + Math.round(Math.random() * 100000.0) + BaseUtil.getRemoteSessionParameters((HttpServletRequest)request, (boolean)false);
            HttpServletResponse response = this.getResponse();
            if (response != null) {
                contentServletURL = response.encodeURL(contentServletURL);
            }
            legendURL = contentServletURL;
            session.setAttribute("sas_StreamContentServlet_ContentBytes" + this.getId(), (Object)mimeData);
            session.setAttribute("sas_StreamContentServlet_ContentType" + this.getId(), (Object)"image/gif");
            session.setAttribute("sas_StreamContentServlet_ContentDisposition" + this.getId(), (Object)("inline;filename=" + this.getId()));
            session.setAttribute("sas_StreamContentServlet_DisposeContents" + this.getId(), (Object)"false");
        } else {
            legendURL = this.mapComponent.getLegendImage();
        }
        this.legendImage.setImage(legendURL);
        Dimension size = null;
        size = this.mapComponent.isUseTotalSizeForWrite() ? this.mapComponent.getSize() : this.mapComponent.getMapSize();
        Dimension legendSize = this.mapComponent.getLegendSize();
        String style = "width: " + size.width + "px; height: " + size.height + "px;";
        m.put("MAP_STYLE", style);
        if (this.mapComponent.isAllActionsVisible()) {
            String mouseout = "sas_mapMouseOut(this, event, '" + this.mapComponent.getId() + "ESRIMap')";
            m.put("MAP_MOUSEOUT", mouseout);
        }
        String gallery = "yes";
        if (!this.mapComponent.isGalleryImageVisible()) {
            gallery = "no";
        }
        this.legendImage.setCustomAttributes("galleryimg=\"" + gallery + "\"");
        this.setTemplateDictionary(m);
        if (this.resetMeasureModelAllowed) {
            this.resetMeasureComboBoxModel(this.mapComponent.isCrossingSet() || this.mapComponent.isUpdateMeasures());
        }
        this.getFormObject().setName(this.mapComponent.getId() + "_form");
        this.getFormObject().setId(this.mapComponent.getId() + "_form");
        this.getFormObject().writeHeader(out);
        this.writeTemplate((BaseTransformation)this, null, out);
        this.getFormObject().writeFooter(out);
        this.cleanUpResources();
        this.choiceBox.setOnChange(comboOnChange);
    }

    public void cleanUpResources() {
        super.cleanUpResources();
        this.mapComponent = (OLAPESRIMapChart)this.getComponent("OLAPGRAPH_CHART");
        if (this.mapComponent != null) {
            this.mapComponent.cleanUpResources();
        }
    }

    public void setMeasureComboBoxSize(Dimension d) {
        if (this.choiceBox != null) {
            StyleInfo si = this.choiceBox.getStyleInfo();
            si.setStyle("Width: " + d.width + "px;");
            this.choiceBox.setStyleInfo(si);
        }
    }

    @SASScope
    private void resetMeasureComboBoxModel(boolean resetModel) {
        BaseChoiceBox measureChoiceBox = (BaseChoiceBox)this.getComponent(MAPCOMPOSITE_MEASURE_DROPDOWN);
        if (measureChoiceBox == null) {
            return;
        }
        if (resetModel || measureChoiceBox.getModel() == null) {
            ArrayList measures = this.mapComponent.getMeasureList();
            DefaultComboBoxModel model = new DefaultComboBoxModel();
            for (int i = 0; i < measures.size(); ++i) {
                model.addElement(measures.get(i));
            }
            measureChoiceBox.setModel(model);
            try {
                String[] crossingInformation = this.mapComponent.getCrossing();
                for (int i = 0; i < model.getSize(); ++i) {
                    for (int j = 0; j < crossingInformation.length; ++j) {
                        try {
                            JavaScriptNode node;
                            if (!(model.getElementAt(i) instanceof JavaScriptNode) || !(node = (JavaScriptNode)model.getElementAt(i)).getValue().equals(crossingInformation[j])) continue;
                            measureChoiceBox.setSelectedIndex(i);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
        }
    }

    @SASScope
    private void resetCrossingLabel() {
        if (!this.mapComponent.isShowCrossing()) {
            this.crossingTitleLabel.setText("");
            this.crossingLabel.setText("");
            return;
        }
        String str = RB.getStringResource(INTERNAL_RB_KEY, "CrossingTitle.txt", this.getLocale());
        this.crossingTitleLabel.setText(str);
        this.crossingLabel.setEncodeText(false);
        String s = "";
        MapOLAPUtil olapUtil = this.mapComponent.getOLAPUtil();
        try {
            Map crossingTuples = olapUtil.getCrossingTuples();
            if (crossingTuples == null || crossingTuples.size() <= 0) {
                return;
            }
            Object[] tuples = crossingTuples.values().toArray();
            Object[] names = crossingTuples.keySet().toArray();
            if (tuples != null) {
                for (int i = 0; i < tuples.length; ++i) {
                    String label;
                    if (tuples[i] == null || ((TupleElementInterface)tuples[i]).getType() == TupleElementType.MEASURE || (label = olapUtil.getLabel(((TupleElementInterface)tuples[i]).getName())).length() <= 0) continue;
                    s = s + "<b>" + names[i] + ":</b> " + label;
                    if (i == tuples.length - 1) continue;
                    s = s + "<br>";
                }
                this.crossingLabel.setText(s);
                if (s == "") {
                    this.crossingLabel.setText(null);
                    this.crossingTitleLabel.setText(null);
                    this.crossingTitleLabel.setVisible(false);
                    this.crossingLabel.setVisible(false);
                }
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
    }

    public void setFormObject(Form form) {
        this.formObject = form;
    }

    public Form getFormObject() {
        if (this.formObject == null) {
            this.formObject = this.getDefaultFormObject();
        }
        return this.formObject;
    }

    public Form getDefaultFormObject() {
        return BaseUtil.getDefaultFormObject((Object)((Object)this), (HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse());
    }

    public HashMap getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setAdditionalParameters(HashMap map) {
        this.additionalParameters = map;
    }

    public void setAdditionalParameter(String name, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap();
        }
        this.additionalParameters.put(name, value);
    }

    public void setFormEnabled(boolean enable) {
        this.formEnabled = enable;
    }

    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    public byte[] getPrintImage() {
        return this.mapComponent.getPrintImage();
    }

    @SASScope
    public boolean isResetMeasureModelAllowed() {
        return this.resetMeasureModelAllowed;
    }

    @SASScope
    public void setResetMeasureModelAllowed(boolean resetMeasureModelAllowed) {
        this.resetMeasureModelAllowed = resetMeasureModelAllowed;
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
        if (this.mapComponent != null) {
            this.mapComponent.setUseSession(useSession);
        }
    }
}

