/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olapgraphics.html;

import com.sas.actionprovider.ActionList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionProviderViewInterface;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.HttpActionProvider;
import com.sas.actionprovider.commands.MapClearSelectionsCommand;
import com.sas.actionprovider.commands.MapFilterSelectionsCommand;
import com.sas.actionprovider.commands.MapIdentifyCommand;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.commands.DynamicAttributeCommandInterface;
import com.sas.entities.AttributeSetException;
import com.sas.framework.themes.client.BrowserType;
import com.sas.framework.themes.client.Theme;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.NoteModel;
import com.sas.graphics.components.esrimap.ESRIMapDataModel;
import com.sas.graphics.components.esrimap.ESRIMapModel;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.graphics.map.ESRIConnection;
import com.sas.graphics.map.ESRIException;
import com.sas.graphics.map.ESRIMap;
import com.sas.graphics.map.MapImageUtil;
import com.sas.graphics.util.FontManager;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.rpf.Context;
import com.sas.rpf.RuleInterface;
import com.sas.rpf.data.DataVector;
import com.sas.rpf.data.DataVectorInterface;
import com.sas.rpf.data.IncompatibleTypeException;
import com.sas.rpf.data.MissingValue;
import com.sas.rpf.data.NumericValue;
import com.sas.rpf.data.ValueInterface;
import com.sas.rpf.data.VariableNotFoundException;
import com.sas.rpf.expr.EvaluateException;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.ComplexStyleInterface;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.dataselectors.crossing.html.MapCrossingSelector;
import com.sas.servlet.tbeans.graphics.BaseESRIMapChart;
import com.sas.servlet.tbeans.graphics.BaseGraphics;
import com.sas.servlet.tbeans.html.Label;
import com.sas.servlet.tbeans.menus.model.PopupMenuItem;
import com.sas.servlet.tbeans.menus.popupmenu.html.PopupMenu;
import com.sas.servlet.tbeans.olapgraphics.html.ESRIElement;
import com.sas.servlet.tbeans.olapgraphics.html.MapOLAPUtil;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapMenu;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPGraphCompositeStyleKeysInterface;
import com.sas.servlet.tbeans.olapgraphics.html.RB;
import com.sas.servlet.tbeans.tableview.TableRowRenderer;
import com.sas.servlet.tbeans.tableview.html.DefaultTableRowRenderer;
import com.sas.servlet.tbeans.tableview.html.ResizingUtil;
import com.sas.servlet.tbeans.tableview.html.TableView;
import com.sas.servlet.util.BaseUtil;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.servlet.util.Components;
import com.sas.servlet.util.DocType;
import com.sas.servlet.util.JavaScriptIncludeHandler;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleInterface;
import com.sas.text.SASFormat;
import com.sas.util.MapWithDefaults;
import com.sas.util.SimpleTemplate;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
public class OLAPESRIMapChart
extends BaseESRIMapChart
implements ContentsChangedListener,
PropertyChangeListener,
ComplexStyleInterface,
OLAPGraphCompositeStyleKeysInterface {
    @SASScope
    public static String DEFAULT_TEMPLATE_FILE_NAME = "DefaultSelectorTemplate.html";
    @SASScope
    private MapOLAPUtil olapUtil;
    @SASScope
    private String datasetName = null;
    @SASScope
    private boolean showCrossing = true;
    @SASScope
    private boolean updateMeasures = false;
    @SASScope
    private String formAction;
    @SASScope
    private int nMiss = 0;
    @SASScope
    private String geoString = null;
    @SASScope
    private boolean useTotalSizeForWrite = false;
    @SASScope
    private Dimension mapSize = new Dimension(600, 300);
    @SASScope
    private Dimension legendSize = new Dimension(200, 250);
    @SASScope
    private boolean crossingSet = false;
    @SASScope
    private boolean reportLinkingOn = false;
    @SASScope
    private String reportLinkingText = null;

    public OLAPESRIMapChart() {
        this.setActionSupportType("ESRIMAP_SUPPORT");
        this.olapUtil = new MapOLAPUtil();
        this.graphModel = new ESRIMapModel();
        this.model = new ESRIMapOLAPDataModel();
        this.model.addPropertyChangeListener(this);
        this.getGraph().setMinimumSize(new Dimension(400, 250));
        CategorizationModel cm = CategorizationModel.newCategorizationModel((int)12001, (int)5);
        ((ESRIMapOLAPDataModel)this.model).setCategorizationModel(cm);
        this.graphModel.addPropertyChangeListener(this);
        try {
            this.getDataModel().getESRIConnection().setConnectionProperties("empty.com", "empty", "user", "pwd");
            this.getDataModel().getESRIConnection().setMapServiceName("Map");
            this.logger = LogManager.getLogger(OLAPESRIMapChart.class);
            if (this.logger.isDebugEnabled()) {
                this.debug = true;
                this.logger.debug("Debugging turned on for MapComponent");
            } else {
                this.debug = false;
            }
        }
        catch (Exception e) {
            this.debug = false;
        }
        this.setActionSupportType("ESRIMAP_SUPPORT");
        OLAPESRIMapChart.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(defaultStyleMap);
        ((ESRIMapOLAPDataModel)this.model).setLevelToLayerMap(new HashMap());
        this.recalculateGeoString();
    }

    public void performAction() {
        String outputMessage = null;
        boolean everythingWorked = true;
        ESRIMap myMap = this.getESRIMap();
        if (myMap == null) {
            outputMessage = RB.getStringResource("MapComponent.", "GenericConnectionError.txt", this.getLocale());
            everythingWorked = false;
        } else {
            this.textMessage = null;
            try {
                if (this.clearSelectionsFlag) {
                    myMap.clearSelections();
                    this.olapUtil.setIsCrossingValidated(false);
                    this.clearSelectionsFlag = false;
                }
                MapCrossingSelector es = new MapCrossingSelector();
                es.setActionProvider(this.getActionProvider());
                ArrayList valueList = new ArrayList(6);
                ArrayList descriptorList = new ArrayList(6);
                ArrayList exceptionList = new ArrayList(6);
                String topVisibleLayer = this.setupMap(myMap, this.autoZoom, valueList, descriptorList, exceptionList);
                if (this.useSavedMapExtents) {
                    myMap.setMapExtents(this.mapExtents[0], this.mapExtents[1], this.mapExtents[2], this.mapExtents[3]);
                }
                if (this.olapUtil.getLegendFormat() != null) {
                    myMap.setLegendValueFormat(this.olapUtil.getLegendFormat());
                }
                for (int i = 0; i < valueList.size(); ++i) {
                    if (!((String)descriptorList.get(i)).equalsIgnoreCase(".")) continue;
                    descriptorList.remove(i);
                    valueList.remove(i);
                    if (exceptionList != null && exceptionList.size() >= i) {
                        exceptionList.remove(i);
                    }
                    --i;
                }
                CategorizationModel cm = ((ESRIMapOLAPDataModel)this.model).getCategorizationModel();
                CategorizationModel cm2 = CategorizationModel.newCategorizationModel((int)cm.getCategorizationType(), (int)Math.min(cm.getParameter(), valueList.size() - this.nMiss));
                if (cm.getSegmentedRangeModel() != null) {
                    cm2.setSegmentedRangeModel(cm.getSegmentedRangeModel());
                }
                if (valueList.size() > 0) {
                    myMap.classify(cm2, topVisibleLayer, (String)((ESRIMapOLAPDataModel)this.model).getLayerToFieldMap().get(topVisibleLayer.toLowerCase()), descriptorList.toArray(new String[0]), valueList.toArray(new Double[0]), exceptionList.toArray(new Boolean[0]));
                }
                this.mapImageMimeData = myMap.getImageMimeData();
                if (valueList.size() <= 0) {
                    String t = RB.getStringResource("MapComponent.", "NoMapInfoForData.txt", this.getLocale());
                    this.mapImageMimeData = this.addNote(this.mapImageMimeData, t);
                }
                if (this.olapUtil.getLegendTitle() != null) {
                    myMap.setLegendTitle(this.olapUtil.getLegendTitle());
                }
                this.legendImageMimeData = myMap.getLegendMimeData(valueList.size() <= 0);
                this.mapDesc = myMap.getMapDescription();
                this.imageDesc = myMap.getImageDescription();
                this.mapExtents = myMap.getMapExtents();
                if (valueList.size() > 0) {
                    myMap.undoClassification(topVisibleLayer);
                }
            }
            catch (Exception e) {
                outputMessage = RB.getStringResource("MapComponent.", "MapCreationError.txt", this.getLocale());
                everythingWorked = false;
                this.printDebugInfo(myMap);
            }
        }
        if (!everythingWorked) {
            this.resetMapLegend();
            this.textMessage = outputMessage;
            this.mapImageMimeData = this.createErrorImage(this.textMessage, this.mapSize.width, this.mapSize.height);
            this.legendImageMimeData = this.createErrorImage(null, this.legendSize.width, this.legendSize.height);
        }
        this.actionPerformed = true;
        if (this.graphModel.isDebug() || this.debug) {
            this.printDebugInfo(myMap);
        }
        try {
            if (myMap != null) {
                myMap.disconnect();
            }
            myMap = null;
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    @SASScope
    private byte[] createErrorImage(String text, int w, int h) {
        if (w <= 0) {
            w = 1;
        }
        if (h <= 0) {
            h = 1;
        }
        BufferedImage bimage = new BufferedImage(w, h, 1);
        Graphics g = bimage.getGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, w, h);
        if (text != null) {
            g.setColor(Color.BLACK);
            g.drawString(text, 10, 10);
        }
        byte[] bs = null;
        try {
            bs = MapImageUtil.getPngByteStream(bimage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }

    @Override
    @SASScope
    public void clearSelections(ESRIMap myMap) {
        try {
            myMap.clearSelections();
            this.olapUtil.setIsCrossingValidated(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setShowFilter(false);
    }

    @SASScope
    private String setupMap(ESRIMap myMap, boolean autoZoom, List valueList, List descriptorList, List exceptionList) throws ESRIException, OLAPException {
        int i;
        Map layerMap = ((ESRIMapOLAPDataModel)this.model).getLevelToLayerMap();
        List elemList = this.olapUtil.getElements();
        boolean doZoom = false;
        if (this.debug) {
            this.logger.debug("Dumping " + elemList.size() + " elements in setupMap()");
            this.logger.debug("==============================");
            for (int iter = 0; iter < elemList.size(); ++iter) {
                this.logger.debug("  " + iter + ") " + elemList.get(iter).toString());
            }
        }
        String[] layerNames = this.getLayerNames(layerMap);
        if (this.debug) {
            this.logger.debug("Dumping " + layerNames.length + " layerNames");
            for (i = 0; i < layerNames.length; ++i) {
                this.logger.debug("   " + layerNames[i]);
            }
        }
        ESRIElement e = null;
        Object[] sa = ((ESRIMapOLAPDataModel)this.model).getLevelToLayerMap().values().toArray();
        for (i = 0; i < sa.length; ++i) {
            if (this.debug) {
                this.logger.debug("Turning off layer " + (String)sa[i]);
            }
            myMap.setLayerVisibility((String)sa[i], "AlwaysOff");
        }
        myMap.setShowMissing(false);
        this.nMiss = 0;
        RuleInterface curRule2 = null;
        Context rulesContext = this.model.getRulesContext();
        if (rulesContext != null) {
            Collection rules = rulesContext.getRules();
            for (RuleInterface curRule2 : rules) {
            }
        }
        List[] zoomLayerDescriptionList = new List[layerNames.length];
        for (i = 0; i < layerNames.length; ++i) {
            zoomLayerDescriptionList[i] = new ArrayList(6);
            if (this.debug) {
                this.logger.debug("Processing layer " + layerNames[i]);
            }
            ArrayList<String> l = new ArrayList<String>(6);
            for (int k = 0; k < elemList.size(); ++k) {
                NumericValue value;
                String tempStr;
                e = (ESRIElement)elemList.get(k);
                if (autoZoom && e.layer.equals(layerNames[i]) && (tempStr = e.uniqueID) != null && tempStr.length() > 0) {
                    zoomLayerDescriptionList[i].add(tempStr);
                }
                if (!e.layer.equals(layerNames[i])) continue;
                tempStr = e.uniqueID;
                if (this.debug) {
                    this.logger.debug("Layer " + layerNames[i] + " value - " + tempStr);
                }
                if (tempStr == null || tempStr.length() <= 0) continue;
                l.add(tempStr);
                if (i != layerNames.length - 1) continue;
                if (e.value instanceof Double) {
                    if (this.debug) {
                        this.logger.debug("Adding " + tempStr + " - " + e.value);
                    }
                    descriptorList.add(tempStr);
                    valueList.add((Double)e.value);
                    if (curRule2 != null) {
                        value = null;
                        value = new NumericValue(((Double)e.value).doubleValue());
                        this.checkRule(curRule2, (ValueInterface)value, exceptionList);
                        continue;
                    }
                    exceptionList.add(Boolean.FALSE);
                    continue;
                }
                if (!(e.value instanceof String) || !((String)e.value).equals(".")) continue;
                if (this.debug) {
                    this.logger.debug("Handling a missing value");
                }
                myMap.setShowMissing(true);
                descriptorList.add(tempStr);
                valueList.add(new Double(Double.NaN));
                if (curRule2 != null) {
                    value = null;
                    value = new MissingValue();
                    this.checkRule(curRule2, (ValueInterface)value, exceptionList);
                } else {
                    exceptionList.add(Boolean.FALSE);
                }
                ++this.nMiss;
            }
            if (l.isEmpty()) continue;
            myMap.setLayerVisibility(layerNames[i], "UseMapServiceRules");
            if (!((ESRIMapOLAPDataModel)this.model).getLayerToFieldMap().containsKey(layerNames[i].toLowerCase())) continue;
            myMap.subset(layerNames[i], (String)((ESRIMapOLAPDataModel)this.model).getLayerToFieldMap().get(layerNames[i].toLowerCase()), l.toArray(new String[0]));
            doZoom = true;
        }
        if (valueList.size() <= 0) {
            myMap.zoomFullExtent();
        } else if (autoZoom && doZoom) {
            double[] totalExtents = new double[4];
            totalExtents[2] = Double.MAX_VALUE;
            totalExtents[0] = Double.MAX_VALUE;
            totalExtents[3] = -1.7976931348623157E308;
            totalExtents[1] = -1.7976931348623157E308;
            for (int index = 0; index < layerNames.length; ++index) {
                double[] layerExtents = myMap.zoomFeatures(layerNames[index], (String)((ESRIMapOLAPDataModel)this.model).getLayerToFieldMap().get(layerNames[index].toLowerCase()), zoomLayerDescriptionList[index].toArray(new String[0]));
                totalExtents = this.union(totalExtents, layerExtents);
            }
            myMap.setMapExtents(totalExtents[0], totalExtents[1], totalExtents[2], totalExtents[3]);
        }
        String topVisibleLayer = null;
        if (--i != -1 && layerNames != null && layerNames.length > i) {
            topVisibleLayer = layerNames[i];
        }
        return topVisibleLayer;
    }

    @SASScope
    private void checkRule(RuleInterface curRule, ValueInterface value, List exceptionList) throws OLAPException {
        block7: {
            if (curRule != null) {
                DataVector dataVec = new DataVector();
                String name = this.olapUtil.getResultSetId();
                dataVec.setValue(name, value);
                this.olapUtil.addTuplesToDataVector(dataVec);
                try {
                    if (curRule.execute((DataVectorInterface)dataVec)) {
                        exceptionList.add(Boolean.TRUE);
                        break block7;
                    }
                    exceptionList.add(Boolean.FALSE);
                }
                catch (IncompatibleTypeException e1) {
                    exceptionList.add(Boolean.FALSE);
                }
                catch (VariableNotFoundException e2) {
                    exceptionList.add(Boolean.FALSE);
                }
                catch (EvaluateException e2) {
                    exceptionList.add(Boolean.FALSE);
                }
            } else {
                exceptionList.add(Boolean.FALSE);
            }
        }
    }

    @SASScope
    private double[] union(double[] a1, double[] a2) {
        if (a1 == null && a2 == null) {
            return null;
        }
        if (a1 == null) {
            return a2;
        }
        if (a2 == null) {
            return a1;
        }
        double[] retArray = new double[]{Math.min(a1[0], a2[0]), Math.max(a1[1], a2[1]), Math.min(a1[2], a2[2]), Math.max(a1[3], a2[3])};
        return retArray;
    }

    @Override
    public void printDebugInfo(ESRIMap myMap) {
        int i;
        Map.Entry[] o;
        String[] crossing = null;
        try {
            crossing = this.olapUtil.getCrossing();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        ESRIConnection connection = this.getDataModel().getESRIConnection();
        System.out.println("----------------------------------------------------------------");
        System.out.println("ESRI Server Connection Information");
        System.out.println("   Server:" + connection.getGisServer());
        System.out.println("   Service:" + connection.getMapServiceName());
        System.out.println("   Domain:" + connection.getDomain());
        System.out.println("   UserName:" + connection.getUserName());
        System.out.println();
        if (crossing == null) {
            System.out.println("Map Crossing is null");
        } else {
            System.out.println("Map Crossing");
            for (int i2 = 0; i2 < crossing.length; ++i2) {
                System.out.println("   " + crossing[i2]);
            }
        }
        System.out.println();
        if (((ESRIMapOLAPDataModel)this.model).getLevelToLayerMap() == null) {
            System.out.println("LevelToLayerMap is null");
        } else {
            System.out.println("LevelToLayerMap");
            Set s = ((ESRIMapOLAPDataModel)this.model).getLevelToLayerMap().entrySet();
            o = s.toArray(new Map.Entry[0]);
            if (s == null || s.size() == 0) {
                System.out.println("   no values");
            } else {
                for (i = 0; i < o.length; ++i) {
                    String found = "";
                    if (myMap != null) {
                        try {
                            found = "Not Found";
                            if (myMap.isValidLayer((String)o[i].getValue())) {
                                found = "Found";
                            }
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    System.out.println("   " + o[i].getKey() + ":" + o[i].getValue() + "              " + found);
                }
            }
        }
        System.out.println();
        if (((ESRIMapOLAPDataModel)this.model).getLayerToFieldMap() == null) {
            System.out.println("LayerToFieldMap is null");
        } else {
            System.out.println("LayerToFieldMap");
            Set s = ((ESRIMapOLAPDataModel)this.model).getLayerToFieldMap().entrySet();
            o = s.toArray(new Map.Entry[0]);
            if (s == null || s.size() == 0) {
                System.out.println("   no values");
            } else {
                for (i = 0; i < o.length; ++i) {
                    String vString = "";
                    try {
                        if (myMap != null) {
                            vString = "";
                            vString = !myMap.isValidLayer((String)o[i].getKey()) ? "Invalid Layer" : (myMap.isValidLayerAndField((String)o[i].getKey(), (String)o[i].getValue()) ? "Valid" : "Invalid field");
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    System.out.println("   " + o[i].getKey() + ":" + o[i].getValue() + "       " + vString);
                }
            }
        }
        if (myMap != null) {
            String[] s = null;
            try {
                s = myMap.getLayerNames();
            }
            catch (ESRIException o2) {
                // empty catch block
            }
            if (s != null) {
                System.out.println();
                System.out.println("Map Layers");
                for (int i3 = 0; i3 < s.length; ++i3) {
                    System.out.println("   " + s[i3]);
                }
            }
        }
    }

    @SASScope
    public void performAction(boolean internal) {
        this.performAction();
        this.actionPerformed = internal;
    }

    @SASScope
    public ActionList getMapActions() {
        ActionSupportFilter supportFilter = new ActionSupportFilter("ESRIMAP_SUPPORT", "MAP_AREA", (ActionProviderViewInterface)this, false);
        supportFilter.setPoolingOn(false);
        supportFilter.setSwing(false);
        supportFilter.setViewerId(this.getId() + "_MapActions");
        try {
            supportFilter.setAttribute("mapViewer", (Object)this);
        }
        catch (AttributeSetException e) {
            System.out.println("Couldn't set the mapViewer");
        }
        ActionList mapActions = this.getActionProvider().getActions(supportFilter);
        return mapActions;
    }

    @SASScope
    public ActionList getOtherMapActions() {
        ActionSupportFilter supportFilter = new ActionSupportFilter("ESRIMAP_SUPPORT", "MAP_OTHER_AREA", (ActionProviderViewInterface)this, false);
        supportFilter.setPoolingOn(false);
        supportFilter.setSwing(false);
        supportFilter.setViewerId(this.getId() + "_OtherActions");
        try {
            supportFilter.setAttribute("mapViewer", (Object)this);
        }
        catch (AttributeSetException e) {
            System.out.println("Couldn't set the mapViewer");
        }
        ActionList mapActions = this.getActionProvider().getActions(supportFilter);
        return mapActions;
    }

    @SASScope
    public ActionList getToolbarActions() {
        ActionSupportFilter toolbarSupportFilter = new ActionSupportFilter("ESRIMAP_TOOLBAR_SUPPORT", "MAP_TOOLBAR_AREA", (ActionProviderViewInterface)this.menuBar, false);
        try {
            toolbarSupportFilter.setAttribute("model", (Object)this.getOLAPDataModel());
            String[] s = this.getCrossing();
            if (s != null) {
                toolbarSupportFilter.setAttribute("crossing", s.clone());
            }
            toolbarSupportFilter.setAttribute("geo", (Object)this.getGeoString());
            toolbarSupportFilter.setAttribute("mapViewer", (Object)this);
            toolbarSupportFilter.setViewerId(this.getId() + "_ToolbarActions");
        }
        catch (AttributeSetException e1) {
            e1.printStackTrace();
        }
        catch (OLAPException e1) {
            // empty catch block
        }
        toolbarSupportFilter.setPoolingOn(false);
        toolbarSupportFilter.setSwing(false);
        ActionList toolbarActions = this.getActionProvider().getActions(toolbarSupportFilter);
        return toolbarActions;
    }

    public void write(PrintWriter out) throws IOException {
        super.write(out);
        if (this.isAllActionsVisible() && this.isResizable()) {
            new ResizingUtil((BaseActionTransformation)this).writeGraphResizingScript(out, (BaseGraphics)this);
        }
        ActionList mapActions = this.getMapActions();
        ActionList toolbarActions = this.getToolbarActions();
        ActionList otherActions = this.getOtherMapActions();
        HttpAction drillDownAction = (HttpAction)mapActions.get("DRILLDOWN_ACTION");
        HttpAction expandAction = (HttpAction)mapActions.get("EXPAND_ACTION");
        HttpAction collapseAction = (HttpAction)mapActions.get("COLLAPSE_ACTION");
        HttpAction selectAction = (HttpAction)mapActions.get("SELECT_ACTION");
        HttpAction rectangularSelectAction = (HttpAction)mapActions.get("RECTANGULARSELECT_ACTION");
        HttpAction zoomInAction = (HttpAction)mapActions.get("ZOOMIN_ACTION");
        HttpAction zoomOutAction = (HttpAction)mapActions.get("ZOOMOUT_ACTION");
        HttpAction panAction = (HttpAction)mapActions.get("PAN_ACTION");
        HttpAction identifyAction = (HttpAction)mapActions.get("IDENTIFY_ACTION");
        HttpAction fullExtentsAction = (HttpAction)toolbarActions.get("FULLEXTENTS_ACTION");
        HttpAction filterSelectionsAction = (HttpAction)toolbarActions.get("FILTERSELECTIONS_ACTION");
        HttpAction clearSelectionsAction = (HttpAction)toolbarActions.get("CLEARSELECTIONS_ACTION");
        HttpAction drillUpAction = (HttpAction)toolbarActions.get("DRILLUP_ACTION");
        HttpAction setMeasureAction = (HttpAction)otherActions.get("SETMEASURE_ACTION");
        HttpAction reportLinkingAction = (HttpAction)mapActions.get("REPORTLINKING_ACTION");
        if (filterSelectionsAction != null) {
            this.filterCommand = (MapFilterSelectionsCommand)filterSelectionsAction.getCommand();
        }
        if (this.clearSelectionsCommand != null) {
            this.clearSelectionsCommand = (MapClearSelectionsCommand)clearSelectionsAction.getCommand();
        }
        HttpSession session = null;
        HttpServletRequest request = this.getRequest();
        if (this.useSession && request != null) {
            session = request.getSession();
        }
        if (this.redrawMap && !this.actionPerformed) {
            this.performAction(false);
        }
        if (this.isAllActionsVisible()) {
            JavaScriptIncludeHandler.writeIncludes((Writer)out, (Object)"MAP", (HttpServletRequest)this.getRequest());
            JavaScriptIncludeHandler.writeIncludes((Writer)out, (Object)"FASTCLICKPROTECTION", (HttpServletRequest)this.getRequest());
            if (request != null) {
                this.writeFastClickProtection(out, this.getRequest().isSecure());
            }
        }
        HashMap argumentMap = ActionProviderMapPool.getMap();
        String id = this.getId() + "ESRIMap";
        out.print("<div");
        out.print(" id=\"" + this.getId() + "overallLayer\"");
        if (this.isAllActionsVisible()) {
            out.print(" onmouseout=\"sas_mapMouseOut('" + id + "',event)\" ");
        }
        out.println(">");
        StyleInfo styleInfo = (StyleInfo)this.getStyleMap().get("MAPCOMPOSITE_BACKGROUNDLAYERSTYLE");
        if (this.isAllActionsVisible()) {
            out.print("<div");
            if (this.isDisabledImage()) {
                out.print(" disabled");
            }
            out.print(" id=\"" + this.getId() + "backgroundLayer\" style=\"position:absolute; z-index:0\" class=\"" + styleInfo.getClassid() + "\"");
            out.print(" onmousedown=\"sas_mapMouseDown('" + id + "',event)\" ");
            out.print(" onmouseup=\"sas_mapMouseUp('" + id + "',event)\" ");
            out.print(" onmousemove=\"sas_mapMouseMove('" + id + "',event)\" ");
            out.println(">");
            out.println("</div>");
            styleInfo = (StyleInfo)this.getStyleMap().get("MAPCOMPOSITE_ZOOMLAYERSTYLE");
            out.print("<div");
            if (this.isDisabledImage()) {
                out.print(" disabled");
            }
            out.print(" id=\"" + this.getId() + "zoomLayer\" style=\"position:absolute; visibility:hidden; z-index:1\" class=\"" + styleInfo.getClassid() + "\"");
            out.print(" onmousedown=\"sas_mapMouseDown('" + id + "',event)\" ");
            out.print(" onmouseup=\"sas_mapMouseUp('" + id + "',event)\" ");
            out.print(" onmousemove=\"sas_mapMouseMove('" + id + "',event)\" ");
            out.println(">");
            out.println("</div>");
            styleInfo = (StyleInfo)this.getStyleMap().get("MAPCOMPOSITE_SELECTLAYERSTYLE");
            out.print("<div");
            if (this.isDisabledImage()) {
                out.print(" disabled");
            }
            out.print(" id=\"" + this.getId() + "selectLayer\" style=\"position:absolute; visibility:hidden; z-index:1\" class=\"" + styleInfo.getClassid() + "\"");
            out.print(" onmousedown=\"sas_mapMouseDown('" + id + "',event)\" ");
            out.print(" onmouseup=\"sas_mapMouseUp('" + id + "',event)\" ");
            out.print(" onmousemove=\"sas_mapMouseMove('" + id + "',event)\" ");
            out.println(">");
            out.println("</div>");
        }
        styleInfo = (StyleInfo)this.getStyleMap().get("MAPCOMPOSITE_MAPLAYERSTYLE");
        out.print("<div");
        if (this.isDisabledImage()) {
            out.print(" disabled");
        }
        out.print(" id=\"" + this.getId() + "mapLayer\" style=\"position:absolute; z-index:0\" class=\"" + styleInfo.getClassid() + "\"");
        if (this.isAllActionsVisible()) {
            out.print(" onmousedown=\"sas_mapMouseDown('" + id + "',event)\" ");
            out.print(" onmouseup=\"sas_mapMouseUp('" + id + "',event)\" ");
            out.print(" onmousemove=\"sas_mapMouseMove('" + id + "',event)\" ");
            out.print(" onclick=\"sas_mapOnClick('" + id + "',event)\" ");
        }
        out.println(">");
        if (this.textMessage != null) {
            Label myLabel = new Label(this.textMessage);
            myLabel.write(out);
        } else {
            String url = null;
            if (this.getImage() != null) {
                url = this.getImage();
            } else if (this.useSession && session != null) {
                String contentServletURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/StreamContentServlet?" + "CONTENT_KEY" + "=" + this.getId() + "&SRCID=" + Math.round(Math.random() * 100000.0) + BaseUtil.getRemoteSessionParameters((HttpServletRequest)request, (boolean)false);
                HttpServletResponse response = this.getResponse();
                if (response != null) {
                    contentServletURL = response.encodeURL(contentServletURL);
                }
                url = contentServletURL;
                if (this.redrawMap) {
                    session.setAttribute("sas_StreamContentServlet_ContentBytes" + this.getId(), (Object)this.mapImageMimeData);
                } else {
                    Object d = session.getAttribute("sas_StreamContentServlet_ContentBytes" + this.getId());
                    if (d == null) {
                        this.performAction(false);
                        d = this.mapImageMimeData;
                    }
                    session.setAttribute("sas_StreamContentServlet_ContentBytes" + this.getId(), d);
                }
                session.setAttribute("sas_StreamContentServlet_ContentType" + this.getId(), (Object)"image/gif");
                session.setAttribute("sas_StreamContentServlet_ContentDisposition" + this.getId(), (Object)("inline;filename=" + this.getId()));
                session.setAttribute("sas_StreamContentServlet_DisposeContents" + this.getId(), (Object)"false");
            }
            out.print(" <input");
            if (this.isDisabledImage()) {
                out.print(" disabled");
            }
            Dimension tempSize = null;
            tempSize = this.isUseTotalSizeForWrite() ? this.getSize() : this.mapSize;
            out.print(" type=\"IMAGE\" width=\"" + tempSize.getWidth() + "\" height=\"" + tempSize.getHeight() + "\"");
            if (this.isAllActionsVisible()) {
                out.print(" onmouseover=\"sas_mapMouseOver('" + id + "',event)\" ");
            }
            if (!this.isGalleryImageVisible()) {
                out.print(" galleryimg=\"no\"");
            }
            out.print(" id=\"" + this.getId() + "ESRIMapImage\"  src=\"" + url + "\" name=\"map\" />");
        }
        out.println("</div>");
        out.println("</div>");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "clickX\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "clickX\" value=\"\">");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "clickY\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "clickY\" value=\"\">");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "width\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "width\" value=\"\">");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "height\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "height\" value=\"\">");
        out.println("<input type=\"HIDDEN\" name=\"" + this.getActionProvider().getParameterPrefix() + "controlPressed\"id=\"" + this.getId() + this.getActionProvider().getParameterPrefix() + "controlPressed\" value=\"\">");
        if (this.reportLinkingOn) {
            PopupMenu popupArea3 = new PopupMenu("popupArea3");
            popupArea3.setModel(this.getPopupModel());
            popupArea3.setRequest(request);
            popupArea3.setResponse(this.getResponse());
            popupArea3.attachTo(this.getId() + "mapLayer", "{text:\"ReportLink\"}", "oncontextmenu");
            popupArea3.write(out);
        }
        if (this.isAllActionsVisible()) {
            SimpleTemplate template;
            out.println("<script type='text/javascript'> ");
            HttpAction zoomInModeAction = (HttpAction)toolbarActions.get("ZOOMINMODE_ACTION");
            HttpAction zoomOutModeAction = (HttpAction)toolbarActions.get("ZOOMOUTMODE_ACTION");
            HttpAction panModeAction = (HttpAction)toolbarActions.get("PANMODE_ACTION");
            HttpAction drillDownModeAction = (HttpAction)toolbarActions.get("DRILLDOWNMODE_ACTION");
            HttpAction expandModeAction = (HttpAction)toolbarActions.get("EXPANDMODE_ACTION");
            HttpAction collapseModeAction = (HttpAction)toolbarActions.get("COLLAPSEMODE_ACTION");
            HttpAction selectModeAction = (HttpAction)toolbarActions.get("SELECTMODE_ACTION");
            HttpAction rectangularSelectModeAction = (HttpAction)toolbarActions.get("RECTANGULARSELECTMODE_ACTION");
            HttpAction identifyModeAction = (HttpAction)toolbarActions.get("IDENTIFYMODE_ACTION");
            String zoomInSelectedImage = this.getSelectedImage(zoomInModeAction);
            String zoomOutSelectedImage = this.getSelectedImage(zoomOutModeAction);
            String panSelectedImage = this.getSelectedImage(panModeAction);
            String drilldownSelectedImage = this.getSelectedImage(drillDownModeAction);
            String expandSelectedImage = this.getSelectedImage(expandModeAction);
            String collapseSelectedImage = this.getSelectedImage(collapseModeAction);
            String selectSelectedImage = this.getSelectedImage(selectModeAction);
            String rectangularSelectSelectedImage = this.getSelectedImage(rectangularSelectModeAction);
            String identifySelectedImage = this.getSelectedImage(identifyModeAction);
            String zoomInImage = this.getImage(zoomInModeAction);
            String zoomOutImage = this.getImage(zoomOutModeAction);
            String panImage = this.getImage(panModeAction);
            String drilldownImage = drillDownModeAction != null && drillDownModeAction.isEnabled() ? this.getImage(drillDownModeAction) : this.getDisabledImage(drillDownModeAction);
            String expandImage = expandModeAction != null && expandModeAction.isEnabled() ? this.getImage(expandModeAction) : this.getDisabledImage(expandModeAction);
            String collapseImage = collapseModeAction != null && collapseModeAction.isEnabled() ? this.getImage(collapseModeAction) : this.getDisabledImage(collapseModeAction);
            String selectImage = this.getImage(selectModeAction);
            String rectangularSelectImage = this.getImage(rectangularSelectModeAction);
            String identifyImage = this.getImage(identifyModeAction);
            this.resolveMode(drillDownModeAction, drillUpAction, expandModeAction, collapseModeAction);
            out.println("window." + this.getId() + "ESRIMap = new sas_ESRIMap(\"" + this.getId() + "\");");
            out.println(this.getId() + "ESRIMap.imageLocation=\"" + this.getImageLocation() + "\";");
            out.println(this.getId() + "ESRIMap.zoomInSelectedImage=\"" + zoomInSelectedImage + "\";");
            out.println(this.getId() + "ESRIMap.zoomOutSelectedImage=\"" + zoomOutSelectedImage + "\";");
            out.println(this.getId() + "ESRIMap.panSelectedImage=\"" + panSelectedImage + "\";");
            out.println(this.getId() + "ESRIMap.drilldownSelectedImage=\"" + drilldownSelectedImage + "\";");
            out.println(this.getId() + "ESRIMap.expandSelectedImage=\"" + expandSelectedImage + "\";");
            out.println(this.getId() + "ESRIMap.collapseSelectedImage=\"" + collapseSelectedImage + "\";");
            out.println(this.getId() + "ESRIMap.selectSelectedImage=\"" + selectSelectedImage + "\";");
            out.println(this.getId() + "ESRIMap.rectangularSelectSelectedImage=\"" + rectangularSelectSelectedImage + "\";");
            out.println(this.getId() + "ESRIMap.identifySelectedImage=\"" + identifySelectedImage + "\";");
            out.println(this.getId() + "ESRIMap.zoomInImage=\"" + zoomInImage + "\";");
            out.println(this.getId() + "ESRIMap.zoomOutImage=\"" + zoomOutImage + "\";");
            out.println(this.getId() + "ESRIMap.panImage=\"" + panImage + "\";");
            out.println(this.getId() + "ESRIMap.drilldownImage=\"" + drilldownImage + "\";");
            out.println(this.getId() + "ESRIMap.expandImage=\"" + expandImage + "\";");
            out.println(this.getId() + "ESRIMap.collapseImage=\"" + collapseImage + "\";");
            out.println(this.getId() + "ESRIMap.selectImage=\"" + selectImage + "\";");
            out.println(this.getId() + "ESRIMap.rectangularSelectImage=\"" + rectangularSelectImage + "\";");
            out.println(this.getId() + "ESRIMap.identifyImage=\"" + identifyImage + "\";");
            out.println(this.getId() + "ESRIMap.menuId=\"" + this.getId() + "toolbarContainer\";");
            if (this.preOnClickFunctionName != null) {
                out.println(this.getId() + "ESRIMap.preOnClickFunctionName=\"" + this.preOnClickFunctionName + "\";");
            }
            if (this.postOnClickFunctionName != null) {
                out.println(this.getId() + "ESRIMap.postOnClickFunctionName=\"" + this.postOnClickFunctionName + "\";");
            }
            String menuStyle = ((StyleInfo)this.getStyleMap().get("MAPCOMPONENT_MENUSTYLE")).getClassid();
            String selectedMenuStyle = ((StyleInfo)this.getStyleMap().get("MAPCOMPONENT_SELECTEDMENUSTYLE")).getClassid();
            out.println(this.getId() + "ESRIMap.menuStyle=\"" + menuStyle + "\";");
            if (selectedMenuStyle != null && selectedMenuStyle.length() == 0) {
                out.println(this.getId() + "ESRIMap.selectedMenuStyle=null;");
            } else if (selectedMenuStyle != null) {
                out.println(this.getId() + "ESRIMap.selectedMenuStyle=\"" + selectedMenuStyle + "\";");
            }
            out.println(this.getId() + "ESRIMap.mapWidth=\"" + this.mapSize.width + "\";");
            out.println(this.getId() + "ESRIMap.mapHeight=\"" + this.mapSize.height + "\";");
            out.println(this.getId() + "ESRIMap.prefix=\"" + this.getActionProvider().getParameterPrefix() + "\";");
            out.println(this.getId() + "ESRIMap.mode=\"" + this.mode + "\";");
            String s = "";
            if (reportLinkingAction != null) {
                s = ", reportLinking:\"" + reportLinkingAction.getAttribute("URL") + "\" ";
            }
            if ((template = fullExtentsAction.getURLTemplate()) != null) {
                template.getValueDictionary().put("ESRIMAPID", this.getId() + "ESRIMap");
            }
            if ((template = zoomInAction.getURLTemplate()) != null) {
                template.getValueDictionary().put("ESRIMAPID", this.getId() + "ESRIMap");
            }
            out.println(this.getId() + "ESRIMap.urls={drillDown:\"" + OLAPESRIMapChart.getUrl(drillDownAction) + "\", drillUp:\"" + OLAPESRIMapChart.getUrl(drillUpAction) + "\", expand:\"" + OLAPESRIMapChart.getUrl(expandAction) + "\", collapse:\"" + OLAPESRIMapChart.getUrl(collapseAction) + "\", select:\"" + OLAPESRIMapChart.getUrl(selectAction) + "\", rectangularSelect:\"" + OLAPESRIMapChart.getUrl(rectangularSelectAction) + "\", fullExtents:\"" + OLAPESRIMapChart.getUrl(fullExtentsAction) + "\", filterSelections:\"" + OLAPESRIMapChart.getUrl(filterSelectionsAction) + "\", clearSelections:\"" + OLAPESRIMapChart.getUrl(clearSelectionsAction) + "\", zoomIn:\"" + OLAPESRIMapChart.getUrl(zoomInAction) + "\", zoomOut:\"" + OLAPESRIMapChart.getUrl(zoomOutAction) + "\", pan:\"" + OLAPESRIMapChart.getUrl(panAction) + "\", identify:\"" + OLAPESRIMapChart.getUrl(identifyAction) + "\", setMeasure:\"" + OLAPESRIMapChart.getUrl(setMeasureAction) + "\" " + s + "};");
            out.println(this.getId() + "ESRIMap.mapInit();");
            out.println("</script>");
            this.writeFeatures(out);
        }
        this.setAutoZoom(true);
        this.setCrossingSet(false);
        this.redrawMap = false;
    }

    @SASScope
    private void resolveMode(HttpAction drillDown, HttpAction drillUp, HttpAction expand, HttpAction collapse) {
        boolean collapseEnabled;
        boolean drillDownEnabled = drillDown == null || drillDown.isEnabled();
        boolean expandEnabled = expand == null || expand.isEnabled();
        boolean bl = collapseEnabled = collapse == null || collapse.isEnabled();
        if (this.mode == 0 && !drillDownEnabled) {
            this.mode = 2;
        } else if (this.mode == 7 && !expandEnabled) {
            this.mode = collapseEnabled ? 8 : 2;
        } else if (this.mode == 8 && !collapseEnabled) {
            this.mode = expandEnabled ? 7 : 2;
        }
    }

    public byte[] getPrintImage() {
        NoteModel nm = this.getFootnote1();
        int noteHeight = 0;
        if (nm != null && nm.getText() != null && nm.getText().length() > 0) {
            noteHeight = nm.getTextStyle().getFont().getSize();
        }
        Dimension totalSize = new Dimension(this.mapSize.width + this.legendSize.width, this.mapSize.height + noteHeight * 2);
        BufferedImage bimage = new BufferedImage(totalSize.width, totalSize.height, 1);
        Graphics2D g = bimage.createGraphics();
        g.setColor(Color.white);
        g.fillRect(0, 0, bimage.getWidth(), bimage.getHeight());
        this.performAction(false);
        if (this.mapImageMimeData == null) {
            this.getMapImageMimeData();
        }
        if (this.legendImageMimeData == null) {
            this.getLegendImageMimeData();
        }
        BufferedImage mi = MapImageUtil.getImageFromByteStream(this.mapImageMimeData, this.mapSize.width, this.mapSize.height);
        g.drawImage((Image)mi, 0, 0, null);
        BufferedImage li = MapImageUtil.getImageFromByteStream(this.legendImageMimeData, this.legendSize.width, this.legendSize.height);
        g.drawImage((Image)li, this.mapSize.width, this.mapSize.height - this.legendSize.height, null);
        String s = this.olapUtil.getLegendTitle();
        if (s != null) {
            Font bigFont;
            FontMetrics bigFontM;
            char[] measureString = s.toCharArray();
            g.setColor(Color.black);
            RectangularShape rect = null;
            for (int fontSize = 12; fontSize > 6 && !((rect = (bigFontM = g.getFontMetrics(bigFont = FontManager.getFont((String)FontManager.getDefaultFont().getFamily(), (int)0, (int)fontSize))).getStringBounds(measureString, 0, measureString.length, (Graphics)g)).getWidth() <= (double)this.legendSize.width); --fontSize) {
            }
            ((Graphics)g).drawString(s, this.mapSize.width + this.legendSize.width / 2 - (int)rect.getWidth() / 2, 10);
        }
        if (nm != null && nm.getText() != null && nm.getText().length() > 0) {
            g.setColor(nm.getTextStyle().getColor());
            Font f = nm.getTextStyle().getFont();
            FontMetrics fm = g.getFontMetrics(f);
            char[] footnoteString = nm.getText().toCharArray();
            Rectangle2D r = fm.getStringBounds(footnoteString, 0, footnoteString.length, (Graphics)g);
            int i = totalSize.height - noteHeight / 2;
            ((Graphics)g).drawString(nm.getText(), totalSize.width / 2 - (int)r.getWidth() / 2, i);
        }
        this.cleanUpImages();
        byte[] bs = null;
        try {
            bs = MapImageUtil.getPngByteStream(bimage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }

    public String[] identify(int x, int y) {
        ESRIMap myMap = new ESRIMap(this.getDataModel().getESRIConnection());
        myMap.setLocale(this.getLocale());
        myMap.setMapImageSize(this.mapSize);
        try {
            myMap.connect();
            if (this.mapDesc != null && this.imageDesc != null) {
                myMap.getMap(this.mapDesc, this.imageDesc);
            } else {
                myMap.getMap();
            }
            ArrayList valueList = new ArrayList(6);
            ArrayList descriptorList = new ArrayList(6);
            ArrayList exceptionList = new ArrayList(6);
            String topVisibleLayer = this.setupMap(myMap, false, valueList, descriptorList, exceptionList);
            String[] sval = myMap.identify(x, y);
            String fieldName = (String)((ESRIMapOLAPDataModel)this.model).getLayerToFieldMap().get(topVisibleLayer.toLowerCase());
            String fieldValue = null;
            Object value = null;
            for (int i = 0; i < sval.length; i += 2) {
                if (!sval[i].equals(fieldName)) continue;
                fieldValue = sval[i + 1];
                int index = descriptorList.indexOf(fieldValue);
                if (index == -1) break;
                value = valueList.get(index);
                break;
            }
            ArrayList<String> myArray = new ArrayList<String>();
            for (int i = 0; i < sval.length; i += 2) {
                myArray.add(sval[i]);
                myArray.add(sval[i + 1]);
            }
            if (value != null) {
                myArray.add(0, this.olapUtil.getLegendTitle());
                if (((Double)value).isNaN()) {
                    myArray.add(1, RB.getStringResource("MapComponent.", "Missing.txt", this.getLocale()));
                } else if (value instanceof Double) {
                    SASFormat format = SASFormat.getInstance((String)this.olapUtil.getLegendFormat());
                    String s = format.format(value).trim();
                    myArray.add(1, s);
                } else {
                    myArray.add(1, value.toString());
                }
            }
            myMap.disconnect();
            return myArray.toArray(new String[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @SASScope
    public static void servletInvocationMethod(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        String type = request.getParameter("ServletName");
        PrintWriter out = response.getWriter();
        if (type != null && type.equalsIgnoreCase("IdentifyWindow")) {
            DynamicAttributeCommandInterface command;
            String apName = request.getParameter("APNAME");
            HttpActionProvider ap = null;
            ap = (HttpActionProvider)session.getAttribute(apName);
            MapIdentifyCommand identifyCommand = null;
            if (ap != null && (command = ap.getExecutableCommand(request)) instanceof MapIdentifyCommand) {
                identifyCommand = (MapIdentifyCommand)command;
            }
            if (identifyCommand == null) {
                return;
            }
            OLAPESRIMapChart map = (OLAPESRIMapChart)identifyCommand.getMapViewer();
            String[] crossingValues = null;
            Label crossingLabel = new Label(RB.getStringResource("MapComponent.", "CrossingInformation.txt", request.getLocale()));
            TableView crossingTableView = null;
            Object[] headers = null;
            try {
                crossingValues = map.getCrossing();
            }
            catch (OLAPException oLAPException) {
                // empty catch block
            }
            if (crossingValues != null) {
                headers = new Object[]{RB.getStringResource("MapComponent.", "Dimension.txt", request.getLocale()), RB.getStringResource("MapComponent.", "Value.txt", request.getLocale())};
                Object[][] tableValues = new Object[crossingValues.length - 1][2];
                int tableIndex = 0;
                for (int i = 0; i < crossingValues.length; ++i) {
                    int j;
                    if (crossingValues[i].indexOf("Measure") >= 0 || (j = crossingValues[i].indexOf(".")) < 0) continue;
                    tableValues[tableIndex][0] = crossingValues[i].substring(0, crossingValues[i].indexOf("."));
                    tableValues[tableIndex++][1] = crossingValues[i].substring(crossingValues[i].indexOf(".") + 1);
                }
                crossingTableView = new TableView(tableValues, headers);
                crossingTableView.setRowHeaderVisible(false);
            }
            ComponentPropertyManager propertyManager = ComponentPropertyManager.getInstance((HttpServletRequest)request);
            DocType.write((PrintWriter)out, (String)"xhtml.transitional");
            out.println("<html xmlns=\"http://www.w3.org/1999/xhtml\"> \n<head>");
            out.println("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\" />");
            out.println("<head>");
            out.println("<title> " + RB.getStringResource("MapComponent.", "MapInformation.txt", request.getLocale()) + "</title>");
            Theme theme = (Theme)request.getAttribute("sas.framework.themeobject");
            if (theme != null) {
                BrowserType browserType = (BrowserType)request.getAttribute("sas.framework.browsertype");
                String stylesString = BaseUtil.getStyleSheetLinks((Theme)theme, (BrowserType)browserType, null);
                out.println(stylesString);
            }
            Components.init((PrintWriter)out, (HttpServletRequest)request);
            out.println("<SCRIPT>\n");
            out.println("function sas_init_dialog() {");
            out.println("var container = document.getElementById(\"outerSelectorContainer\");");
            out.println("var w = container.scrollWidth;");
            out.println("var margin = eval(document.body.rightMargin)+eval(document.body.leftMargin)-8;");
            out.println("w += (margin | 2);");
            out.println("var h = container.scrollHeight;");
            out.println("margin = eval(document.body.topMargin)+eval(document.body.bottomMargin)+8;");
            out.println("h += (margin | 32);");
            out.println("window.resizeTo( w, h );");
            out.println("window.focus();");
            out.println("}");
            out.println("</SCRIPT>");
            out.println("</head>");
            out.println("<body onload=\"sas_init_dialog()\">");
            out.println("<div id=\"outerSelectorContainer\">");
            if (crossingTableView != null && crossingValues.length > 1) {
                StyleInfo labelStyle = (StyleInfo)map.getStyleMap().get("MAPCOMPOSITE_IDENTIFYLABELSTYLE");
                crossingLabel.setStyleInfo(labelStyle);
                crossingLabel.write(out);
                out.println("<br>");
                crossingTableView.write(out);
                out.println("<br>");
            }
            out.println(map.writeIdentify(request));
            out.println("</div>");
            out.println("</body>");
            out.println("</html>");
        } else if (type != null && (type.equalsIgnoreCase("ZoomIn") || type.equalsIgnoreCase("ZoomOut") || type.equalsIgnoreCase("FullExtents") || type.equalsIgnoreCase("RectangularSelect") || type.equalsIgnoreCase("Select") || type.equalsIgnoreCase("Pan"))) {
            String apName = request.getParameter("APNAME");
            HttpActionProvider ap = null;
            ap = (HttpActionProvider)session.getAttribute(apName);
            OLAPESRIMapChart map = (OLAPESRIMapChart)session.getAttribute("ESRIMap");
            ap.executeCommand(request, response, (Object)out);
            map.performAction(false);
            String contentServletURL = request.getContextPath() + "/StreamContentServlet?" + "CONTENT_KEY" + "=" + map.getId() + "&SRCID=" + Math.round(Math.random() * 100000.0) + BaseUtil.getRemoteSessionParameters((HttpServletRequest)request, (boolean)false);
            if (response != null) {
                contentServletURL = response.encodeURL(contentServletURL);
            }
            String url = contentServletURL;
            session.setAttribute("sas_StreamContentServlet_ContentBytes" + map.getId(), (Object)map.getMapImageMimeData());
            OLAPESRIMapMenu mapMenu = (OLAPESRIMapMenu)((Object)session.getAttribute("ESRIMenuBar"));
            mapMenu.setRequest(request);
            mapMenu.write(out);
            out.println("<script>");
            out.println(map.getId() + "ESRIMap.setSource( \"" + url + "\");");
            out.println("</script> ");
        }
    }

    @SASScope
    public String writeIdentify(HttpServletRequest request) {
        int zoomX = Integer.parseInt(request.getParameter("endx"));
        int zoomY = Integer.parseInt(request.getParameter("endy"));
        String[] identifyPairs = this.identify(zoomX, zoomY);
        String[] crossingValues = null;
        Map styleMap = this.getStyleMap();
        StyleInfo labelStyle = (StyleInfo)styleMap.get("MAPCOMPOSITE_IDENTIFYLABELSTYLE");
        StyleInfo textStyle = (StyleInfo)styleMap.get("MAPCOMPOSITE_IDENTIFYTEXTSTYLE");
        StyleInfo containerStyle = (StyleInfo)styleMap.get("MAPCOMPOSITE_IDENTIFYCONTAINERSTYLE");
        Label mapLabel = new Label(RB.getStringResource("MapComponent.", "RegionDetail.txt", request.getLocale()));
        mapLabel.setStyleInfo(labelStyle);
        Label measureLabel = null;
        Label measure = null;
        TableView mapTableView = null;
        Object[] mapInfoHeaders = null;
        String measureString = null;
        String measureName = null;
        try {
            crossingValues = this.getCrossing();
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        if (crossingValues != null) {
            for (int i = 0; i < crossingValues.length; ++i) {
                if (crossingValues[i] == null || crossingValues[i].indexOf("Measure") < 0) continue;
                measureString = crossingValues[i];
                measureName = measureString.substring(measureString.lastIndexOf("[") + 1, measureString.lastIndexOf("]"));
            }
        }
        if (measureString != null) {
            measureLabel = new Label(RB.getStringResource("MapComponent.", "measure.txt", request.getLocale()));
            measureLabel.setStyleInfo(labelStyle);
            measure = new Label(measureString.substring(measureString.lastIndexOf("[") + 1, measureString.lastIndexOf("]")));
            measure.setStyleInfo(textStyle);
        } else {
            measureLabel = new Label(" ");
        }
        if (identifyPairs != null) {
            int numPairs = identifyPairs.length;
            mapInfoHeaders = new Object[]{RB.getStringResource("MapComponent.", "Field.txt", request.getLocale()), " ", RB.getStringResource("MapComponent.", "Value.txt", request.getLocale())};
            Object[][] values = new Object[numPairs / 2][3];
            int index = 0;
            for (int i = 0; i < identifyPairs.length; i += 2) {
                if (identifyPairs[i] != null && measureName != null && identifyPairs[i].equalsIgnoreCase(measureName)) {
                    measureLabel.setText(measureName + ":");
                    measure.setText(identifyPairs[i + 1]);
                    continue;
                }
                values[index][0] = identifyPairs[i];
                values[index][1] = "";
                values[index][2] = identifyPairs[i + 1];
                ++index;
            }
            mapTableView = new TableView(values, mapInfoHeaders);
            DefaultTableRowRenderer oddRowRenderer = new DefaultTableRowRenderer();
            DefaultTableRowRenderer evenRowRenderer = new DefaultTableRowRenderer();
            oddRowRenderer.setStyleInfo(new StyleInfo("tableOddRow"));
            evenRowRenderer.setStyleInfo(new StyleInfo("tableEvenRow"));
            mapTableView.getStyleMap().put("TABLEVIEW_DATA_STYLE", new StyleInfo("ESRIMapIdentifyTableData"));
            mapTableView.setAllActionsVisible(false);
            mapTableView.getStyleMap().put("TABLEVIEW_STYLE", new StyleInfo("ESRIMapIdentifyTableView"));
            mapTableView.setRowRenderer(1, -1, 2, (TableRowRenderer)oddRowRenderer);
            mapTableView.setRowRenderer(2, -1, 2, (TableRowRenderer)evenRowRenderer);
            mapTableView.setRowHeaderVisible(false);
            mapTableView.setColumnHeaderVisible(false);
        }
        StringBuffer out = new StringBuffer();
        if (measureLabel != null) {
            out.append("<br />");
            out.append("<div align=\"left\" >");
            out.append("<table cellpadding=\"0\" cellspacing=\"0\" ><tr><td>");
            out.append(measureLabel.toString());
            out.append("</td>");
            out.append("<td colspan=\"5\"></td>");
            out.append("<td>");
            if (measure != null) {
                out.append(measure.toString());
            }
            out.append("</td></tr></table>\n");
            out.append("</div>");
        }
        if (mapTableView != null && identifyPairs != null && identifyPairs.length > 0) {
            out.append("<div align=\"left\" >");
            out.append(mapLabel.toString());
            out.append("</div>");
            out.append("<div class=\"").append(containerStyle.getClassid()).append("\">");
            mapTableView.setFormEnabled(false);
            out.append(mapTableView.toString());
            out.append("</div>");
        }
        out.append("<br /><br />");
        return out.toString();
    }

    @SASScope
    public void setCrossing(String[] memberNames) throws OLAPException {
        this.redrawMap = true;
        this.olapUtil.setCrossing(memberNames);
        this.setCrossingSet(true);
    }

    @SASScope
    public String[] getCrossing() throws OLAPException {
        return this.olapUtil.getCrossing();
    }

    public void setFormAction(String action) {
        this.formAction = action;
    }

    public String getFormAction() {
        if (this.formAction != null) {
            return this.formAction;
        }
        HttpActionProvider ap = this.getActionProvider();
        if (ap != null && ap.getControllerURL() != null) {
            return ap.getControllerURL();
        }
        if (this.getRequest() != null) {
            return this.getRequest().getRequestURI();
        }
        return null;
    }

    @SASScope
    private boolean isParent(OLAPDataSetInterface model1, OLAPDataSetInterface model2) {
        BusinessQuery b2;
        if (!(model1 instanceof BusinessQueryToOLAPDataSetAdapter) || !(model2 instanceof BusinessQueryToOLAPDataSetAdapter)) {
            return model1 == model2;
        }
        BusinessQuery b1 = ((BusinessQueryToOLAPDataSetAdapter)model1).getBusinessQuery();
        if (b1 == (b2 = ((BusinessQueryToOLAPDataSetAdapter)model2).getBusinessQuery())) {
            return true;
        }
        while (b1.getParentQuery() != null) {
            b1 = b1.getParentQuery();
        }
        while (b2.getParentQuery() != null) {
            b2 = b2.getParentQuery();
        }
        return b1 == b2;
    }

    @SASScope
    public void contentsChanged(ContentsChangedEvent event) {
        OLAPDataSetInterface mymodel = null;
        if (this.model instanceof ESRIMapOLAPDataModel) {
            mymodel = ((ESRIMapOLAPDataModel)this.model).getModel();
        }
        if (mymodel == null) {
            return;
        }
        if (!(event.getSource() instanceof OLAPDataSetInterface) || !this.isParent((OLAPDataSetInterface)event.getSource(), mymodel)) {
            return;
        }
        this.clearSelectionsFlag = true;
        this.setUpdateMeasures(true);
        this.redrawMap = true;
    }

    @Override
    public void setDataModel(ESRIMapDataModel model) {
        super.setDataModel(model);
        this.updateModel();
        model.addPropertyChangeListener(this);
        this.setAutoZoom(true);
        this.redrawMap = true;
    }

    @SASScope
    private void updateModel() {
        if (this.model instanceof ESRIMapOLAPDataModel) {
            try {
                String s = ((ESRIMapOLAPDataModel)this.model).getModel().getCubeName();
                if (this.datasetName == null || !this.datasetName.equals(s)) {
                    this.getNewMap = true;
                    this.datasetName = s;
                }
            }
            catch (Exception s) {
                // empty catch block
            }
            this.olapUtil.setDataModel(((ESRIMapOLAPDataModel)this.model).getModel());
            OLAPDataSetInterface mymodel = ((ESRIMapOLAPDataModel)this.model).getModel();
            if (mymodel instanceof BusinessQueryToOLAPDataSetAdapter) {
                ((BusinessQueryToOLAPDataSetAdapter)mymodel).addContentsChangedListener((ContentsChangedListener)this);
            }
        }
    }

    @SASScope
    private OLAPDataSetInterface getOLAPDataModel() {
        return this.olapUtil.getDataModel();
    }

    @SASScope
    public String[] getLayerNames(Map layerMap) throws OLAPException {
        ArrayList l = new ArrayList(6);
        Map levelMap = this.olapUtil.getLevelToMetaLevelMap();
        if (levelMap != null) {
            for (String name : levelMap.values()) {
                if (!layerMap.containsKey(name.toLowerCase())) continue;
                l.add(layerMap.get(name.toLowerCase()));
            }
        }
        return l.toArray(new String[0]);
    }

    @SASScope
    private void recalculateGeoString() {
        String s;
        Object[] o = ((ESRIMapOLAPDataModel)this.model).getLevelToLayerMap().keySet().toArray();
        if (o.length >= 1 && (s = (String)o[0]).indexOf("[") >= 0) {
            int start = s.indexOf(91) + 1;
            int end = s.indexOf(93);
            this.geoString = s = s.substring(start, end);
        }
    }

    @SASScope
    public void printResultSet(OLAPDataSetInterface newModel) throws ESRIException {
        try {
            AxisInterface[] axes = newModel.getResultSetMetadata().getAxes(0, -1);
            for (int i = 0; i < axes.length; ++i) {
                TupleInterface[] tuples = axes[i].getTuples(0, -1);
                for (int j = 0; j < tuples.length; ++j) {
                    TupleElementInterface[] te = tuples[j].getElements(0, -1);
                    System.out.print(" TupleElements: " + j);
                    for (int k = 0; k < te.length; ++k) {
                        System.out.print("  " + te[k].getName());
                    }
                    System.out.println();
                }
            }
        }
        catch (OLAPException e) {
            throw new ESRIException(RB.getStringResource("BaseActionTransformation.", "OLAPError.txt", this.getLocale()), e);
        }
    }

    @SASScope
    public boolean isMapEnabled() {
        return true;
    }

    @SASScope
    public String getGeoString() {
        return this.geoString;
    }

    @SASScope
    public void setGeoString(String geoString) {
        this.geoString = geoString;
    }

    @SASScope
    public MapOLAPUtil getOLAPUtil() {
        return this.olapUtil;
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.mapSize = new Dimension((int)((double)width * 0.75), height);
        this.legendSize = new Dimension((int)((double)width * 0.25), height - 45);
    }

    @SASScope
    public ArrayList getMeasureList() {
        if (this.olapUtil != null) {
            return this.olapUtil.getMeasureList();
        }
        return null;
    }

    @Override
    @SASScope
    public void propertyChange(PropertyChangeEvent arg0) {
        String pName = arg0.getPropertyName();
        if (pName.equals("LevelToLayerMap")) {
            this.recalculateGeoString();
            this.olapUtil.setLevelToLayerMap(((ESRIMapOLAPDataModel)this.model).getLevelToLayerMap());
        }
        if (pName.equals("model")) {
            this.updateModel();
        }
    }

    @SASScope
    public boolean isCrossingSet() {
        return this.crossingSet;
    }

    @SASScope
    public void setCrossingSet(boolean crossingSet) {
        this.crossingSet = crossingSet;
    }

    @SASScope
    public boolean isUpdateMeasures() {
        return this.updateMeasures;
    }

    @SASScope
    public void setUpdateMeasures(boolean updateMeasures) {
        this.updateMeasures = updateMeasures;
    }

    public boolean isShowCrossing() {
        return this.showCrossing;
    }

    public void setShowCrossing(boolean showCrossing) {
        this.showCrossing = showCrossing;
    }

    public List getPopupModel() {
        ArrayList<PopupMenuItem> menuItemsB = new ArrayList<PopupMenuItem>();
        PopupMenuItem itemB1 = new PopupMenuItem();
        String s = null;
        s = this.reportLinkingText == null ? RB.getStringResource("MapComponent.", "ReportLinking.txt", this.getLocale()) : this.reportLinkingText;
        itemB1.setText(s);
        itemB1.setJavascript(this.getId() + "ESRIMap.linkToReport();");
        itemB1.setImage("report_link_default.gif");
        menuItemsB.add(itemB1);
        return menuItemsB;
    }

    public boolean isReportLinkingOn() {
        return this.reportLinkingOn;
    }

    public void setReportLinkingOn(boolean reportLinkingOn) {
        this.reportLinkingOn = reportLinkingOn;
    }

    public String getReportLinkingText() {
        return this.reportLinkingText;
    }

    public void setReportLinkingText(String reportLinkingText) {
        this.reportLinkingText = reportLinkingText;
    }

    @SASScope
    public boolean isUseTotalSizeForWrite() {
        return this.useTotalSizeForWrite;
    }

    @SASScope
    public void setUseTotalSizeForWrite(boolean useTotalExtentsForWrite) {
        this.useTotalSizeForWrite = useTotalExtentsForWrite;
    }

    static {
        JavaScriptIncludeHandler.addAlias(OLAPESRIMapChart.class, (String)"MAP");
    }
}

