/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.olapgraphics.html;

import com.sas.codepolicy.SASScope;
import com.sas.iquery.dataretrieval.QueryConnector;
import com.sas.iquery.execution2.ResultSetInterface;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessItem;
import com.sas.iquery.metadata.business.BusinessModel;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.DataItemReference;
import com.sas.iquery.metadata.business.DataSelection;
import com.sas.iquery.metadata.business.DataSelectionFactory;
import com.sas.iquery.metadata.business.Role;
import com.sas.rpf.data.DataVector;
import com.sas.servlet.tbeans.models.JavaScriptNode;
import com.sas.servlet.tbeans.olapgraphics.html.ESRIElement;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.olap.AxisInterface;
import com.sas.storage.olap.Filter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.MemberLevelComparator;
import com.sas.storage.olap.MetadataInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.ResultSetMetadataInterface;
import com.sas.storage.olap.TupleElementInterface;
import com.sas.storage.olap.TupleElementType;
import com.sas.storage.olap.TupleInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope
public class MapOLAPUtil {
    private TupleInterface[] memberTupleArray;
    private OLAPDataSetInterface dsi = null;
    private Map elementList;
    private TupleInterface[] tupleArray;
    private Map crossingTuples;
    private String[] crossing;
    private String legendTitle;
    private String legendFormat;
    private Map levelToLayerMap;
    private Map levelToMetaLevelMap;
    private String currentGeoDimension;
    private AxisInterface currentGeoAxis;
    private boolean isCrossingValidated;
    private TupleElementInterface measureElement;
    private boolean debug;
    private Logger logger = LogManager.getLogger(MapOLAPUtil.class);
    private static String[] EMPTY_STRING_ARRAY = new String[0];

    public MapOLAPUtil() {
        try {
            if (this.logger.isDebugEnabled()) {
                this.debug = true;
                this.logger.debug("Debugging turned on for MapOLAPUtil");
            } else {
                this.debug = false;
            }
        }
        catch (Exception e) {
            this.debug = false;
        }
    }

    public void setDataModel(OLAPDataSetInterface i) {
        this.dsi = i;
        this.isCrossingValidated = false;
        if (this.debug) {
            this.logger.debug("in setDataModel(): OLAPDataSetInterface model = " + this.dsi);
        }
    }

    public OLAPDataSetInterface getDataModel() {
        return this.dsi;
    }

    public List getElements() throws OLAPException {
        if (this.dsi == null) {
            if (this.debug) {
                this.logger.debug("OLAPDatasetInterface is null.  getElements() is returning an empty string array");
            }
            return Arrays.asList(EMPTY_STRING_ARRAY);
        }
        this.getCrossing();
        if (!this.isCrossingValidated || this.crossing == null || this.currentGeoAxis == null) {
            if (this.debug) {
                this.logger.debug("Crossing not validated or null.  getElements() is returning a 0-sized ArrayList");
            }
            return new ArrayList(0);
        }
        int memberAxisNumber = this.currentGeoAxis.getAxisNumber();
        if (memberAxisNumber != 1 && memberAxisNumber != 0) {
            if (this.debug) {
                this.logger.debug("memberAxisNumber: " + memberAxisNumber);
                this.logger.debug("getElements() is returning aa 0-sized ArrayList");
            }
            return new ArrayList(0);
        }
        return this.createElements();
    }

    public String getResultSetId() {
        String result = null;
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.dsi).getBusinessQuery();
            DataItem dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, (OLAPDataSetInterface)this.dsi, (Object)this.measureElement, (int)1);
            result = dataItem.getResultSetID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void addLevels(DataVector dataVector, TupleElementInterface[] tuples) throws OLAPException {
        for (int i = 0; i < tuples.length; ++i) {
            TupleElementInterface tuple = tuples[i];
            if (tuple.getType() == TupleElementType.MEASURE) continue;
            String uLevelName = tuple.getUniqueLevelName();
            int index1 = uLevelName.indexOf(93, 1);
            String dim = uLevelName.substring(1, index1);
            int index2 = uLevelName.indexOf(93, index1 + 1);
            String hierarchy = uLevelName.substring(index1 + 3, index2);
            int index3 = uLevelName.indexOf(93, index2 + 1);
            String level = null;
            if (index3 < 0) {
                level = hierarchy;
                hierarchy = "*";
                String startingDim = uLevelName.substring(0, index1 + 1);
                hierarchy = MapOLAPUtil.findHierarchyForDimension(tuple, startingDim);
            } else {
                level = uLevelName.substring(index2 + 3, index3);
            }
            dataVector.setDrillLevel(dim, hierarchy, level);
        }
    }

    private static String findHierarchyForDimension(TupleElementInterface tuple, String startingDim) throws OLAPException {
        String[] hiers = tuple.getTuple().getAxis().getHierarchyNames();
        for (int j = 0; j < hiers.length; ++j) {
            String hier = hiers[j];
            if (!hier.startsWith(startingDim)) continue;
            return hier.substring(startingDim.length() + 2, hier.length() - 1);
        }
        return null;
    }

    private TupleInterface[] executeQuery() throws OLAPException {
        try {
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)this.dsi).getBusinessQuery();
            String levelName = this.getLevelNames()[0];
            DataItem dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, (OLAPDataSetInterface)this.dsi, (Object)levelName, (int)3);
            if (dataItem != null) {
                String propertyName1 = "SAS_SPATIAL_ID";
                ArrayList<String> props = new ArrayList<String>();
                props.add(propertyName1);
                BusinessModel businessModel = businessQuery.getBusinessModel();
                DataSelection dataSelection = DataSelectionFactory.newDataSelection((BusinessModel)businessModel);
                DataItemReference ref = dataSelection.newDataItemReference(dataItem);
                ref.setSteps(dataItem.getSteps());
                ref.setMemberProperties(props);
                dataSelection.addBusinessItem((BusinessItem)ref);
                dataSelection.addResultItem((DataItem)ref, Role.COLUMN);
                QueryConnector connector = new QueryConnector();
                ArrayList<DataSelection> selectionList = new ArrayList<DataSelection>(1);
                selectionList.add(dataSelection);
                Map results = connector.retrieveQueryResultMap(selectionList);
                String modelID = dataSelection.getID();
                ResultSetInterface iqResultSet = (ResultSetInterface)results.get(modelID);
                Object resultSet = iqResultSet.getResultSet();
                if (this.debug) {
                    this.logger.debug("executeQuery Query=" + ((OLAPDataSetInterface)resultSet).getQueryStatement());
                }
                AxisInterface cAxis = ((OLAPDataSetInterface)resultSet).getResultSetMetadata().getAxes(0, 1)[0];
                TupleInterface[] tuples = cAxis.getTuples(0, -1);
                if (this.debug) {
                    this.logger.debug("executeQuery Number of Tuples for the query=" + tuples.length);
                }
                iqResultSet.close();
                dataSelection.dispose();
                return tuples;
            }
            if (this.debug) {
                this.logger.debug("executeQuery DataItem is null for level = " + levelName + " returning a null TupleInterface array");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private List createElements() throws OLAPException {
        String propertyName = "SAS_SPATIAL_ID";
        String key = "[" + this.currentGeoDimension + "].[" + propertyName + "]";
        if (this.debug) {
            this.logger.debug("createElements key value: " + key);
        }
        this.elementList = new HashMap(20);
        ArrayList<ESRIElement> returnList = new ArrayList<ESRIElement>(20);
        TupleInterface[] mapTuples = this.executeQuery();
        int[] block = this.getBlock();
        Object[] cellValues = this.dsi.getCells((long)block[0], (long)block[1]);
        if (this.debug) {
            this.logger.debug("executeQuery Number of cells =" + cellValues.length);
        }
        if (cellValues == null || cellValues.length == 0) {
            return returnList;
        }
        boolean j = false;
        for (int i = 0; mapTuples != null && i < mapTuples.length; ++i) {
            TupleElementInterface mapElement = mapTuples[i].getElement(mapTuples[i].getTupleDepth() - 1);
            TupleElementInterface tableElement = this.tupleBelongsTo(this.memberTupleArray, mapElement.getName());
            if (tableElement == null || tableElement.isContextual()) continue;
            ESRIElement esriElem = new ESRIElement();
            Map propMap = mapElement.getProperties();
            esriElem.uniqueID = (String)propMap.get(key);
            esriElem.layer = (String)this.levelToLayerMap.get(tableElement.getUniqueLevelName().toLowerCase());
            if (esriElem.layer == null) {
                String levelName = (String)this.levelToMetaLevelMap.get(tableElement.getUniqueLevelName().toLowerCase());
                if (levelName == null || !this.levelToLayerMap.containsKey(levelName.toLowerCase())) continue;
                esriElem.layer = (String)this.levelToLayerMap.get(levelName.toLowerCase());
            }
            esriElem.value = cellValues[tableElement.getTuple().getTupleIndex()];
            returnList.add(esriElem);
            Map<String, Object> valueMap = esriElem.layer != null && this.elementList.containsKey(esriElem.layer) ? (Map)this.elementList.get(esriElem.layer) : new HashMap<String, TupleElementInterface>(10);
            valueMap.put(esriElem.uniqueID, tableElement);
            this.elementList.put(esriElem.layer, valueMap);
        }
        if (this.debug) {
            this.logger.debug("executeQuery Number of Esri elements=" + returnList.size());
        }
        return returnList;
    }

    private TupleElementInterface tupleBelongsTo(TupleInterface[] tArray, String name) throws OLAPException {
        int index = -1;
        for (int i = 0; tArray != null && i < tArray.length; ++i) {
            TupleElementInterface[] te = tArray[i].getElements(0, -1);
            index = MapOLAPUtil.elemBelongsTo(te, name);
            if (index < 0) continue;
            return te[index];
        }
        return null;
    }

    private static int elemBelongsTo(TupleElementInterface[] teArray, String name) throws OLAPException {
        if (teArray != null) {
            for (int i = 0; i < teArray.length; ++i) {
                if (!name.equals(teArray[i].getName())) continue;
                return i;
            }
        }
        return -1;
    }

    private AxisInterface getMemberAxis(String uniqueLevelNames) throws OLAPException {
        AxisInterface[] axes = this.dsi.getResultSetMetadata().getAxes(0, -1);
        for (int i = 0; i < axes.length; ++i) {
            String[] levelNames = axes[i].getUniqueLevelNames();
            for (int j = 0; j < levelNames.length; ++j) {
                if (!uniqueLevelNames.equalsIgnoreCase(levelNames[j])) continue;
                return axes[i];
            }
        }
        if (this.debug) {
            this.logger.debug("getMemberAxis() : GeoAxis is null");
        }
        return null;
    }

    private String getDimensionName(String uniqueLevelNames) throws OLAPException {
        AxisInterface[] axes = this.dsi.getResultSetMetadata().getAxes(0, -1);
        for (int i = 0; i < axes.length; ++i) {
            String[] levelNames = axes[i].getUniqueLevelNames();
            String[] dimNames = axes[i].getDimensionNames();
            for (int j = 0; j < levelNames.length; ++j) {
                if (!uniqueLevelNames.equalsIgnoreCase(levelNames[j])) continue;
                return dimNames[j];
            }
        }
        if (this.debug) {
            this.logger.debug("getDimensionName() : Dimension is null for level=" + uniqueLevelNames);
        }
        return null;
    }

    public String[] getLevelNames() throws OLAPException {
        int j;
        String[] levelNames;
        int i;
        if (this.dsi == null) {
            return EMPTY_STRING_ARRAY;
        }
        String[] levelKeys = this.levelToLayerMap.keySet().toArray(EMPTY_STRING_ARRAY);
        this.levelToMetaLevelMap = new LinkedHashMap(3);
        ArrayList<String> levelList = new ArrayList<String>(6);
        AxisInterface[] axes = this.dsi.getResultSetMetadata().getAxes(0, -1);
        boolean found = false;
        for (i = 0; !found && i < axes.length; ++i) {
            levelNames = axes[i].getUniqueLevelNames();
            for (j = 0; j < levelNames.length; ++j) {
                String name = levelNames[j];
                for (int k = 0; k < levelKeys.length; ++k) {
                    if (!name.equalsIgnoreCase(levelKeys[k])) continue;
                    levelList.add(name);
                    this.levelToMetaLevelMap.put(name.toLowerCase(), levelKeys[k]);
                    found = true;
                }
            }
        }
        if (!found) {
            for (i = 0; i < axes.length; ++i) {
                levelNames = axes[i].getUniqueLevelNames();
                for (j = 0; j < levelNames.length; ++j) {
                    String uniqueLevelName = levelNames[j];
                    Filter f = new Filter();
                    f.setCubeName(this.dsi.getCubeName());
                    f.setUniqueLevelName(uniqueLevelName);
                    LevelInterface level = this.dsi.getDatabaseMetadata().getLevel(f);
                    if (level == null) continue;
                    StringBuffer sb = new StringBuffer();
                    sb.append("[");
                    sb.append(level.getHierarchy().getDimension().getName());
                    sb.append("].[");
                    sb.append(level.getName());
                    sb.append("]");
                    String name = sb.toString();
                    for (int k = 0; k < levelKeys.length; ++k) {
                        if (!name.equalsIgnoreCase(levelKeys[k])) continue;
                        levelList.add(uniqueLevelName);
                        this.levelToMetaLevelMap.put(uniqueLevelName.toLowerCase(), name);
                    }
                }
            }
        }
        if (this.debug) {
            this.logger.debug("getLevelNames() : levelToLayerMap=" + this.levelToLayerMap);
        }
        if (this.debug) {
            this.logger.debug("getLevelNames() : LevelNames=" + levelList);
        }
        if (this.debug) {
            this.logger.debug("getLevelNames() : LevelToMetaLevelMap (important only if multiple hierarchy in Geo dimension=" + this.levelToMetaLevelMap);
        }
        return levelList.toArray(EMPTY_STRING_ARRAY);
    }

    public Map getLevelToMetaLevelMap() {
        return this.levelToMetaLevelMap;
    }

    private int[] getBlock() throws OLAPException {
        int numAxes = this.dsi.getResultSetMetadata().getAxes(0, -1).length;
        int[] startCoords = new int[numAxes];
        int[] endCoords = new int[numAxes];
        int memberAxisIndex = this.currentGeoAxis.getAxisNumber();
        if (memberAxisIndex == -1) {
            memberAxisIndex = numAxes - 1;
        }
        for (int i = 0; i < this.tupleArray.length; ++i) {
            int index = this.tupleArray[i].getAxis().getAxisNumber();
            if (index == -1) {
                index = numAxes - 1;
            }
            startCoords[index] = this.tupleArray[i].getTupleIndex();
            endCoords[index] = this.tupleArray[i].getTupleIndex();
        }
        startCoords[memberAxisIndex] = 0;
        endCoords[memberAxisIndex] = this.memberTupleArray[this.memberTupleArray.length - 1].getTupleIndex();
        int[] ordinals = new int[]{OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)this.dsi.getResultSetMetadata(), (int[])startCoords), OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)this.dsi.getResultSetMetadata(), (int[])endCoords)};
        return ordinals;
    }

    public void reset() {
        this.memberTupleArray = null;
        this.elementList = null;
        this.tupleArray = null;
        this.crossing = null;
        this.legendTitle = null;
        this.legendFormat = null;
        this.measureElement = null;
        this.isCrossingValidated = false;
        this.levelToMetaLevelMap = null;
        this.currentGeoDimension = null;
        this.currentGeoAxis = null;
    }

    public void setCrossing(String[] memberNames) throws OLAPException {
        this.reset();
        if (memberNames == null) {
            this.crossing = null;
        } else {
            this.crossing = new String[memberNames.length];
            System.arraycopy(memberNames, 0, this.crossing, 0, memberNames.length);
        }
    }

    public String[] getCrossing() throws OLAPException {
        if (!this.isCrossingValidated) {
            if (this.debug) {
                this.logger.debug("in getCrossing(): Crossing is not validated");
            }
            if (this.dsi != null && this.validateandSet(this.crossing)) {
                this.isCrossingValidated = true;
            }
        }
        if (this.debug && this.crossing == null) {
            this.logger.debug("in getCrossing(): Crossing is null, returning empty array");
        }
        return this.crossing == null ? EMPTY_STRING_ARRAY : this.crossing;
    }

    public void setIsCrossingValidated(boolean isValidated) throws OLAPException {
        this.isCrossingValidated = isValidated;
    }

    public boolean isCrossingValidated() throws OLAPException {
        return this.isCrossingValidated;
    }

    private TupleElementInterface getNumericMeasure(TupleElementInterface[] elements, int index) throws OLAPException {
        int elementIndex = index >= 0 ? index : 0;
        TupleElementInterface measure = elements[elementIndex];
        if (this.debug) {
            this.logger.debug("in getNumericMeasure(): defaultMeasure=" + measure);
        }
        int axisIndex = measure.getTuple().getAxis().getAxisNumber();
        AxisInterface[] axes = this.dsi.getResultSetMetadata().getAxes(0, -1);
        int axisCount = axes.length - 1;
        int[] coordinates = new int[axisCount];
        boolean found = false;
        while (!found) {
            for (int i = 0; i < coordinates.length; ++i) {
                coordinates[i] = i == axisIndex ? measure.getTuple().getTupleIndex() : 0;
            }
            int cellOrdinal = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)this.dsi.getResultSetMetadata(), (int[])coordinates);
            Object[] sampleCell = this.dsi.getCells((long)cellOrdinal, (long)cellOrdinal);
            if (sampleCell == null || sampleCell.length == 0) break;
            if (sampleCell[0] instanceof Double || sampleCell[0] instanceof Long || sampleCell[0] instanceof Short) {
                found = true;
                break;
            }
            if (sampleCell[0].equals(".")) {
                int i;
                for (int i2 = 0; i2 < coordinates.length; ++i2) {
                    coordinates[i2] = i2 == axisIndex ? measure.getTuple().getTupleIndex() : axes[i2].getTupleCount() - 1;
                }
                int endOrdinal = OLAPUtil.calculateCellOrdinal((ResultSetMetadataInterface)this.dsi.getResultSetMetadata(), (int[])coordinates);
                sampleCell = this.dsi.getCells((long)cellOrdinal, (long)endOrdinal);
                for (i = 1; i < sampleCell.length; ++i) {
                    if (sampleCell[i] instanceof Double || sampleCell[i] instanceof Long || sampleCell[i] instanceof Short) {
                        found = true;
                        break;
                    }
                    if (!sampleCell[i].equals(".")) break;
                }
                if (i == sampleCell.length && !found) {
                    found = true;
                    break;
                }
            }
            if (++elementIndex >= elements.length) continue;
            measure = elements[elementIndex];
        }
        if (this.debug) {
            this.logger.debug("in getNumericMeasure(): Returned numericMeasure=" + (found ? measure : elements[0]));
        }
        return found ? measure : elements[0];
    }

    public String[] getMemberNames(String layer, List uniqueIDList) throws OLAPException {
        if (this.elementList != null && layer != null) {
            HashMap teMap = (HashMap)this.elementList.get(layer);
            int size = uniqueIDList.size();
            String[] memberNames = new String[size];
            for (int i = 0; i < size; ++i) {
                memberNames[i] = ((TupleElementInterface)teMap.get(uniqueIDList.get(i))).getName();
            }
            return memberNames;
        }
        if (this.debug) {
            this.logger.debug("in getMemberNames(): Return null for layer= " + layer + " for list= " + uniqueIDList);
        }
        return null;
    }

    public void addTuplesToDataVector(DataVector vec) throws OLAPException {
        AxisInterface[] axes = this.dsi.getResultSetMetadata().getAxes(0, -1);
        for (int i = 0; i < axes.length; ++i) {
            TupleInterface[] tuples = axes[i].getTuples(0, -1);
            for (int j = 0; j < tuples.length; ++j) {
                TupleElementInterface[] elems = tuples[j].getElements(0, -1);
                this.addLevels(vec, elems);
            }
        }
    }

    private boolean validateandSet(String[] memberNames) throws OLAPException {
        int i;
        String[] levelNames;
        if (this.debug) {
            this.logger.debug("in validateandSet(): memberNames to be validated= " + memberNames);
        }
        if ((levelNames = this.getLevelNames()) == null || levelNames.length <= 0) {
            return false;
        }
        this.currentGeoDimension = this.getDimensionName(levelNames[0]);
        this.currentGeoAxis = this.getMemberAxis(levelNames[0]);
        ArrayList<TupleInterface> tupleList = new ArrayList<TupleInterface>();
        ArrayList<TupleInterface> memberTupleList = new ArrayList<TupleInterface>();
        ArrayList<String> crossingList = new ArrayList<String>();
        this.crossingTuples = new HashMap();
        AxisInterface[] axes = this.dsi.getResultSetMetadata().getAxes(0, -1);
        if (this.currentGeoAxis == null) {
            return false;
        }
        memberNames = this.resolveMemberNames(memberNames);
        if (this.debug) {
            this.logger.debug("in validateandSet(): resolved memberNames from query= " + memberNames);
        }
        List<String> memberList = Arrays.asList(memberNames);
        for (int i2 = 0; i2 < axes.length; ++i2) {
            TupleInterface[] tuples = axes[i2].getTuples(0, -1);
            boolean isMemberAxis = this.currentGeoAxis.getAxisNumber() == axes[i2].getAxisNumber();
            for (int j = 0; j < tuples.length; ++j) {
                TupleElementInterface[] elems = tuples[j].getElements(0, -1);
                for (int k = 0; k < elems.length && (elems[k].isContextual() || memberList.contains(elems[k].getName())); ++k) {
                    if (elems[k].getType() == TupleElementType.MEASURE) {
                        this.legendTitle = elems[k].getLabel();
                        this.measureElement = elems[k];
                        if (this.dsi != null && this.dsi instanceof BusinessQueryProviderInterface) {
                            BusinessQuery bq = ((BusinessQueryProviderInterface)this.dsi).getBusinessQuery();
                            this.legendFormat = BusinessQueryToOLAPDataSetAdapter.getFormat((BusinessQuery)bq, (TupleElementInterface)elems[k]);
                        }
                    }
                    if (k != elems.length - 1) continue;
                    if (isMemberAxis) {
                        memberTupleList.add(tuples[j]);
                        continue;
                    }
                    tupleList.add(tuples[j]);
                }
            }
        }
        this.tupleArray = tupleList.toArray(new TupleInterface[0]);
        int len = tupleList.size();
        for (i = 0; i < len; ++i) {
            TupleInterface tuple = (TupleInterface)tupleList.get(i);
            TupleElementInterface[] elements = tuple.getElements(0, -1);
            for (int j = 0; j < elements.length; ++j) {
                if (elements[j].isContextual() || crossingList.contains(elements[j].getName())) continue;
                crossingList.add(elements[j].getName());
                String dimName = this.getDimensionName(elements[j].getUniqueLevelName());
                this.crossingTuples.put(dimName, elements[j]);
            }
        }
        len = memberTupleList.size();
        for (i = 0; i < len; ++i) {
            TupleInterface tuple = (TupleInterface)memberTupleList.get(i);
            TupleElementInterface[] elements = tuple.getElements(0, -1);
            for (int j = 0; j < elements.length; ++j) {
                String lvlName = elements[j].getUniqueLevelName();
                if ((elements[j].getType() == TupleElementType.TOTAL || elements[j].getType() == TupleElementType.SUBTOTAL) && this.isLevelInGeoDimension(lvlName) || elements[j].isContextual() || this.isLevelInGeoDimension(lvlName) || crossingList.contains(elements[j].getName())) continue;
                crossingList.add(elements[j].getName());
                String dimName = this.getDimensionName(elements[j].getUniqueLevelName());
                this.crossingTuples.put(dimName, elements[j]);
            }
        }
        if (this.debug) {
            this.logger.debug("in validateandSet(): legendTitle/measureElement= " + this.legendTitle);
        }
        this.memberTupleArray = memberTupleList.toArray(new TupleInterface[0]);
        if (this.debug) {
            this.logger.debug("in validateandSet(): geography dim members memberTupleArray.length = " + this.memberTupleArray.length);
        }
        this.crossing = crossingList.toArray(new String[0]);
        return true;
    }

    private String[] resolveMemberNames(String[] memberNames) throws OLAPException {
        AxisInterface[] axes = this.dsi.getResultSetMetadata().getAxes(0, -1);
        ArrayList<String> layerList = new ArrayList<String>();
        LinkedHashMap<String, String> tempCrossing = new LinkedHashMap<String, String>();
        for (int axisIndex = 0; axisIndex < axes.length; ++axisIndex) {
            TupleInterface[] tuples = axes[axisIndex].getTuples(0, -1);
            int maximumDepth = axes[axisIndex].getMaximumTupleDepth();
            String[] hierarchyNames = axes[axisIndex].getHierarchyNames();
            for (int hierIndex = 0; hierIndex < hierarchyNames.length; ++hierIndex) {
                if (tempCrossing.containsKey(hierarchyNames[hierIndex])) continue;
                tempCrossing.put(hierarchyNames[hierIndex], null);
            }
            for (int levelIndex = 0; levelIndex < maximumDepth; ++levelIndex) {
                TupleElementInterface[] elements = OLAPUtil.getTupleElementsForLevel((int)levelIndex, (TupleInterface[])tuples, (boolean)false, (int)-1);
                TupleElementInterface elem = elements[0];
                int l = 0;
                while (l < elements.length && elem.getType() == TupleElementType.TOTAL || elem.getType() == TupleElementType.SUBTOTAL) {
                    elem = elements[l++];
                }
                boolean isLayerLevel = this.isLevelInGeoDimension(elem.getUniqueLevelName());
                if (!isLayerLevel) {
                    TupleElementInterface element;
                    int index = this.memberMatches(memberNames, elements);
                    if (index >= 0) {
                        if (elements[index].isContextual()) {
                            int k;
                            TupleInterface t = elements[index].getTuple();
                            TupleElementInterface e = t.getElements(elements[index].getTupleElementIndex() + 1, 1)[0];
                            for (k = e.getTupleElementIndex() + 1; e.isContextual() && k < t.getTupleDepth(); ++k) {
                                e = t.getElements(k, 1)[0];
                            }
                            tempCrossing.put(hierarchyNames[levelIndex], e.getName());
                            levelIndex = k - 1;
                            continue;
                        }
                        if (elements[index].getType() != TupleElementType.MEASURE) {
                            tempCrossing.put(hierarchyNames[levelIndex], elements[index].getName());
                            continue;
                        }
                        element = this.getNumericMeasure(elements, index);
                        if (element == null) continue;
                        tempCrossing.put(hierarchyNames[levelIndex], element.getName());
                        continue;
                    }
                    if (!elements[0].isContextual()) {
                        if (tempCrossing.get(hierarchyNames[levelIndex]) != null) continue;
                        if (elements[0].getType() != TupleElementType.MEASURE) {
                            tempCrossing.put(hierarchyNames[levelIndex], elements[0].getName());
                            continue;
                        }
                        element = this.getNumericMeasure(elements, 0);
                        if (element == null) continue;
                        tempCrossing.put(hierarchyNames[levelIndex], element.getName());
                        continue;
                    }
                    if (!elements[0].isContextual()) continue;
                }
                if (this.debug) {
                    this.logger.debug("in resolveMemberNames(): layerLevel = " + elem.getUniqueLevelName());
                }
                for (int i = 0; i < elements.length; ++i) {
                    layerList.add(elements[i].getName());
                }
            }
        }
        for (int i = 0; memberNames != null && i < memberNames.length; ++i) {
            MemberInterface[] members;
            block20: {
                if (memberNames[i] == null) continue;
                members = null;
                try {
                    Filter f = new Filter();
                    f.setCubeName(this.dsi.getCubeName());
                    f.setUniqueMemberName(memberNames[i]);
                    f.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
                    members = this.dsi.getDatabaseMetadata().getMembers(f, 0, -1);
                }
                catch (Exception e) {
                    if (!this.debug) break block20;
                    this.logger.debug("in resolveMemberNames(): metadataMember unresolved = " + memberNames[i]);
                }
            }
            for (int j = 0; members != null && j < members.length; ++j) {
                String uniqueLevelName = members[j].getLevel().getUniqueName();
                for (int l = 0; l < axes.length; ++l) {
                    String[] levelNames2 = axes[l].getUniqueLevelNames();
                    int index = MapOLAPUtil.belongsTo(levelNames2, uniqueLevelName);
                    if (index < 0) continue;
                    tempCrossing.put(members[j].getLevel().getHierarchy().getUniqueName(), members[j].getUniqueName());
                }
            }
        }
        for (Object value : tempCrossing.values()) {
            if (value == null) continue;
            layerList.add((String)value);
        }
        if (this.debug) {
            this.logger.debug("in resolveMemberNames(): returned layerList = " + layerList);
        }
        return layerList.toArray(EMPTY_STRING_ARRAY);
    }

    public ArrayList getMeasureList() {
        ArrayList<JavaScriptNode> measures;
        block7: {
            if (this.dsi == null) {
                return new ArrayList();
            }
            measures = new ArrayList<JavaScriptNode>();
            try {
                ResultSetMetadataInterface resultSet = this.dsi.getResultSetMetadata();
                AxisInterface[] axis = resultSet.getAxes(0, -1);
                boolean found = false;
                for (int i = 0; !found && i < axis.length; ++i) {
                    int maxLevel = axis[i].getUniqueLevelNames().length;
                    for (int j = 0; !found && j < maxLevel; ++j) {
                        TupleInterface[] tuples = axis[i].getTuples(0, -1);
                        TupleElementInterface[] elements = OLAPUtil.getTupleElementsForLevel((int)j, (TupleInterface[])tuples, (boolean)false, (int)-1);
                        for (int k = 0; k < elements.length; ++k) {
                            if (elements[k].getType() != TupleElementType.MEASURE) continue;
                            JavaScriptNode tupleNode = new JavaScriptNode();
                            tupleNode.setText(elements[k].getLabel().trim());
                            tupleNode.setValue(elements[k].getName().trim());
                            measures.add(tupleNode);
                            found = true;
                        }
                    }
                }
            }
            catch (OLAPException e) {
                if (!this.debug) break block7;
                this.logger.debug("in getMeasureList(): measureList is empty");
            }
        }
        if (this.debug) {
            this.logger.debug("in getMeasureList(): returned measureList = " + measures);
        }
        return measures;
    }

    private boolean isLevelInGeoDimension(String uniqueLevelName) throws OLAPException {
        if (this.currentGeoDimension == null || uniqueLevelName == null) {
            return false;
        }
        String dimName = this.getDimensionName(uniqueLevelName);
        if (dimName == null) {
            Filter f = new Filter();
            f.setCubeName(this.dsi.getCubeName());
            f.setUniqueLevelName(uniqueLevelName);
            LevelInterface level = this.dsi.getDatabaseMetadata().getLevel(f);
            if (level != null) {
                dimName = level.getHierarchy().getDimension().getName();
            }
        }
        if (dimName != null) {
            return dimName.equals(this.currentGeoDimension);
        }
        if (this.debug) {
            this.logger.debug("in isLevelInGeoDimension(): Level not in Geo dimension = " + uniqueLevelName);
        }
        return false;
    }

    public TupleElementInterface getTupleElement(String layer, String uniqueID) {
        if (this.elementList != null && layer != null) {
            HashMap teMap = (HashMap)this.elementList.get(layer);
            return (TupleElementInterface)teMap.get(uniqueID);
        }
        if (this.debug) {
            this.logger.debug("in getTupleElement(): No element found for layer= " + layer + " uniqueID=" + uniqueID);
        }
        return null;
    }

    private int memberMatches(String[] memberNames, TupleElementInterface[] elements) throws OLAPException {
        for (int i = 0; i < elements.length; ++i) {
            int j = MapOLAPUtil.belongsTo(memberNames, elements[i].getName());
            if (j < 0) continue;
            memberNames[j] = null;
            return i;
        }
        return -1;
    }

    private static int belongsTo(String[] nameArray, String name) {
        if (nameArray != null) {
            for (int i = 0; i < nameArray.length; ++i) {
                if (!name.equals(nameArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public TupleElementInterface getMeasureElement() {
        return this.measureElement;
    }

    public String getLegendFormat() {
        return this.legendFormat;
    }

    public void setLegendFormat(String legendFormat) {
        this.legendFormat = legendFormat;
    }

    public String getLegendTitle() {
        return this.legendTitle;
    }

    public void setLegendTitle(String legendTitle) {
        this.legendTitle = legendTitle;
    }

    public Map getLevelToLayerMap() {
        return this.levelToLayerMap;
    }

    public void setLevelToLayerMap(Map levelToLayerMap) {
        this.levelToLayerMap = levelToLayerMap;
    }

    public int getLevelDepthFromName(String levelName) {
        try {
            Filter f = new Filter();
            f.setCubeName(this.dsi.getCubeName());
            f.setUniqueLevelName(levelName);
            MetadataInterface metadata = this.dsi.getDatabaseMetadata();
            LevelInterface level = metadata.getLevel(f);
            int levelDepth = level.getDepth();
            return levelDepth;
        }
        catch (OLAPException oLAPException) {
            return -1;
        }
    }

    public int getMaximumDepth(String levelName) {
        try {
            Filter f = new Filter();
            f.setCubeName(this.dsi.getCubeName());
            f.setUniqueLevelName(levelName);
            MetadataInterface metadata = this.dsi.getDatabaseMetadata();
            LevelInterface level = metadata.getLevel(f);
            LevelInterface[] levels = level.getHierarchy().getLevels();
            return levels.length - 1;
        }
        catch (OLAPException oLAPException) {
            return 0;
        }
    }

    public String getLabel(String uniqueMemberName) {
        StringBuffer label = new StringBuffer();
        if (uniqueMemberName != null) {
            Filter filter = new Filter();
            filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
            filter.setUniqueMemberName(uniqueMemberName);
            try {
                if (this.dsi.getDatabaseMetadata() != null) {
                    filter.setCubeName(this.dsi.getCubeName());
                    MemberInterface[] members = this.dsi.getDatabaseMetadata().getMembers(filter, 0, -1);
                    Arrays.sort(members, MemberLevelComparator.defaultInstance);
                    for (int i = 0; i < members.length; ++i) {
                        if (members[i].getType() == 2) continue;
                        String text = members[i].getLabel().trim();
                        if (label.length() > 0) {
                            label.append(".");
                        }
                        label.append(text);
                    }
                }
            }
            catch (OLAPException oe) {
                label = new StringBuffer(uniqueMemberName);
            }
        }
        return label.toString();
    }

    public Map getCrossingTuples() {
        return this.crossingTuples;
    }

    public MemberInterface[] getLevels(TupleElementInterface element) {
        try {
            MetadataInterface metadata = this.dsi.getDatabaseMetadata();
            String cubeName = this.dsi.getCubeName();
            if (cubeName != null && metadata != null) {
                Filter filter = new Filter();
                filter.setTreeOperator(Filter.ANCESTORS_TREE_OPERATOR | Filter.SELF_TREE_OPERATOR);
                filter.setUniqueMemberName(element.getName());
                filter.setCubeName(cubeName);
                MemberInterface[] members = metadata.getMembers(filter, 0, -1);
                Arrays.sort(members, MemberLevelComparator.defaultInstance);
                return members;
            }
        }
        catch (OLAPException oLAPException) {
            // empty catch block
        }
        return null;
    }
}

