/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics.html;

import com.sas.graphics.components.esrimap.ESRIMapTableDataModel;
import com.sas.servlet.tbeans.BaseActionTransformation;
import com.sas.servlet.tbeans.BaseTransformation;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleInfo;
import com.sas.servlet.tbeans.TransformationInterface;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.form.html.ChoiceBox;
import com.sas.servlet.tbeans.form.html.Form;
import com.sas.servlet.tbeans.form.html.FormViewInterface;
import com.sas.servlet.tbeans.form.html.Image;
import com.sas.servlet.tbeans.graphics.html.ESRIMapChart;
import com.sas.servlet.tbeans.graphics.html.ESRIMapMenu;
import com.sas.servlet.tbeans.graphics.html.GraphComposite;
import com.sas.servlet.util.BaseUtil;
import com.sas.util.MapWithDefaults;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.awt.Dimension;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;

public class ESRIMapComposite
extends GraphComposite
implements FormViewInterface {
    public static final String MAPCOMPOSITE_CONTAINER_STYLE = "MAPCOMPOSITE_CONTAINER_STYLE";
    public static final String MAPCOMPOSITE_MENUBAR_CONTAINER = "MAPCOMPOSITE_MENUBAR_CONTAINER";
    public static final String MAPCOMPOSITE_LEGEND = "MAPCOMPOSITE_LEGEND";
    private TableModel dataModel = null;
    private ESRIMapChart mapComponent;
    private ESRIMapMenu mapMenu;
    private ChoiceBox choiceBox = null;
    private Image legendImage = null;
    private Form formObject;
    private boolean formEnabled;
    private HashMap additionalParameters;
    private static final Map defaultStyleMap = new HashMap();
    private boolean useSession = true;

    public ESRIMapComposite() {
        this(null);
    }

    public ESRIMapComposite(TableModel model) {
        this(model, null, null);
    }

    public ESRIMapComposite(TableModel dataModel, HttpServletRequest request, HttpServletResponse response) {
        super(request, response);
        ESRIMapComposite.setupDefaultStyleMap();
        ((MapWithDefaults)this.getStyleMap()).setDefaultMap(defaultStyleMap);
        this.setActionSupportType("ESRIMAP_SUPPORT");
        this.mapComponent = new ESRIMapChart();
        this.choiceBox = new ChoiceBox();
        StyleInfo si = this.choiceBox.getStyleInfo();
        si.setStyle("Width: 150px; Height: 40px;");
        this.choiceBox.setStyleInfo(si);
        this.choiceBox.setOnChange(this.mapComponent.getId() + "ESRIMap.setMeasure()");
        this.legendImage = new Image();
        this.legendImage.setEnabled(false);
        this.setModel(dataModel);
        this.setComponent("GRAPH_CHART", (TransformationInterface)this.mapComponent);
        this.setComponent(MAPCOMPOSITE_LEGEND, (TransformationInterface)this.legendImage);
        TransformationInterface o = this.getComponent("GRAPH_MENUBAR");
        if (o != null && o instanceof ActionProviderMenuBar) {
            ((ActionProviderMenuBar)o).setViewer((BaseActionTransformation)this.mapComponent);
        }
        this.mapComponent.setActionProvider(this.getActionProvider());
        this.mapMenu = new ESRIMapMenu();
        this.mapMenu.setMap(this.mapComponent);
        this.mapComponent.setMenuBar((ActionProviderMenuBar)this.mapMenu);
        this.setComponent("GRAPH_MENUBAR", (TransformationInterface)this.mapMenu);
        this.setTemplateFileName("MapComposite.html");
    }

    private static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put(MAPCOMPOSITE_CONTAINER_STYLE, new ImmutableStyleInfo("ESRIMapContainer"));
            defaultStyleMap.put("GRAPH_TITLE_STYLE", new ImmutableStyleInfo("OLAPGraphTitle"));
            defaultStyleMap.put("GRAPH_FOOTER_STYLE", new ImmutableStyleInfo("OLAPGraphFooter"));
            defaultStyleMap.put("GRAPH_TOOLBAR_STYLE", new ImmutableStyleInfo("OLAPGraphToolBar"));
        }
    }

    public void setModel(TableModel dataModel) {
        super.setModel(dataModel);
        if (this.dataModel != dataModel) {
            this.dataModel = dataModel;
            this.mapComponent.setDataModel(new ESRIMapTableDataModel(dataModel));
        }
    }

    public TableModel getModel() {
        return this.dataModel;
    }

    public void write(PrintWriter out) throws IOException {
        this.mapMenu.setLocale(this.getLocale());
        HttpServletRequest request = this.getRequest();
        HttpSession session = null;
        if (this.useSession && request != null) {
            session = request.getSession();
        }
        if (this.useSession && session != null) {
            session.setAttribute("ESRIMap", (Object)this.getComponent("GRAPH_CHART"));
            session.setAttribute("ESRIMenuBar", (Object)this.getComponent("ESRIMAP_TOOLBAR"));
        }
        this.mapComponent = (ESRIMapChart)this.getComponent("GRAPH_CHART");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("MAP_ID", this.mapComponent.getId());
        m.put("MAP_CONTAINER_ID", this.getId());
        m.put(MAPCOMPOSITE_MENUBAR_CONTAINER, this.mapComponent.getId() + "MENUBAR_CONTAINER");
        byte[] mimeData = null;
        if (this.mapComponent.isRedrawComponent() && this.mapComponent.isRedrawMap()) {
            this.mapComponent.performAction(true);
            mimeData = this.mapComponent.getLegendImageMimeData();
        } else if (this.useSession && session != null) {
            mimeData = (byte[])session.getAttribute("sas_StreamContentServlet_ContentBytes" + this.getId());
        } else {
            this.mapComponent.performAction(true);
            mimeData = this.mapComponent.getLegendImageMimeData();
        }
        String legendURL = null;
        if (this.useSession && session != null) {
            String contentServletURL = request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort() + request.getContextPath() + "/StreamContentServlet?" + "CONTENT_KEY" + "=" + this.getId() + "&SRCID=" + Math.round(Math.random() * 100000.0) + BaseUtil.getRemoteSessionParameters((HttpServletRequest)request, (boolean)false);
            HttpServletResponse response = this.getResponse();
            if (response != null) {
                contentServletURL = response.encodeURL(contentServletURL);
            }
            legendURL = contentServletURL;
            session.setAttribute("sas_StreamContentServlet_ContentBytes" + this.getId(), (Object)mimeData);
            session.setAttribute("sas_StreamContentServlet_ContentType" + this.getId(), (Object)"image/gif");
            session.setAttribute("sas_StreamContentServlet_ContentDisposition" + this.getId(), (Object)("inline;filename=" + this.getId()));
            session.setAttribute("sas_StreamContentServlet_DisposeContents" + this.getId(), (Object)"false");
        } else {
            legendURL = this.mapComponent.getLegendImage();
        }
        this.legendImage.setImage(legendURL);
        Dimension size = this.mapComponent.getMapSize();
        Dimension legendSize = this.mapComponent.getLegendSize();
        String style = "width: " + size.width + "px; height: " + size.height + "px;";
        m.put("MAP_STYLE", style);
        if (this.mapComponent.isAllActionsVisible()) {
            String mouseout = "sas_mapMouseOut(this, event, '" + this.mapComponent.getId() + "ESRIMap')";
            m.put("MAP_MOUSEOUT", mouseout);
        }
        String gallery = "yes";
        if (!this.mapComponent.isGalleryImageVisible()) {
            gallery = "no";
        }
        this.legendImage.setCustomAttributes("galleryimg=\"" + gallery + "\"");
        this.setTemplateDictionary(m);
        ActionProviderMenuBar mb = (ActionProviderMenuBar)this.getComponent("GRAPH_MENUBAR");
        if (mb != null) {
            this.mapComponent.setMenuBar(mb);
        }
        this.getFormObject().setName(this.mapComponent.getId() + "_form");
        this.getFormObject().setId(this.mapComponent.getId() + "_form");
        this.getFormObject().writeHeader(out);
        this.writeTemplate((BaseTransformation)this, null, out);
        this.getFormObject().writeFooter(out);
        this.cleanUpResources();
    }

    public void cleanUpResources() {
        super.cleanUpResources();
        this.mapComponent = (ESRIMapChart)this.getComponent("GRAPH_CHART");
        if (this.mapComponent != null) {
            this.mapComponent.cleanUpResources();
        }
    }

    public void setFormObject(Form form) {
        this.formObject = form;
    }

    public Form getFormObject() {
        if (this.formObject == null) {
            this.formObject = this.getDefaultFormObject();
        }
        return this.formObject;
    }

    public Form getDefaultFormObject() {
        return BaseUtil.getDefaultFormObject((Object)((Object)this), (HttpServletRequest)this.getRequest(), (HttpServletResponse)this.getResponse());
    }

    public HashMap getAdditionalParameters() {
        return this.additionalParameters;
    }

    public void setAdditionalParameters(HashMap map) {
        this.additionalParameters = map;
    }

    public void setAdditionalParameter(String name, String value) {
        if (this.additionalParameters == null) {
            this.additionalParameters = new HashMap();
        }
        this.additionalParameters.put(name, value);
    }

    public void setFormEnabled(boolean enable) {
        this.formEnabled = enable;
    }

    public boolean isFormEnabled() {
        return this.formEnabled;
    }

    public byte[] getPrintImage() {
        return this.mapComponent.getPrintImage();
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
        if (this.mapComponent != null) {
            this.mapComponent.setUseSession(useSession);
        }
    }

    public TransformationInterface setComponent(String componentKey, TransformationInterface tbean) {
        return super.setComponent(componentKey, tbean);
    }
}

