/*
 * Decompiled with CFR 0.152.
 */
package com.sas.servlet.tbeans.graphics;

import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.commands.MapClearSelectionsCommand;
import com.sas.actionprovider.commands.MapFilterSelectionsCommand;
import com.sas.actionprovider.strategies.BaseMapStrategy;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.esrimap.ESRIMapDataModel;
import com.sas.graphics.components.esrimap.ESRIMapModel;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.graphics.map.ESRIException;
import com.sas.graphics.map.ESRIMap;
import com.sas.graphics.map.MapImageUtil;
import com.sas.graphics.util.FontManager;
import com.sas.servlet.tbeans.ImmutableStyleInfo;
import com.sas.servlet.tbeans.StyleMap;
import com.sas.servlet.tbeans.dataselectors.html.ActionProviderMenuBar;
import com.sas.servlet.tbeans.graphics.BaseGraph;
import com.sas.servlet.tbeans.olapgraphics.html.RB;
import com.sas.servlet.util.ComponentPropertyManager;
import com.sas.text.Message;
import com.sas.util.MapWithDefaults;
import jakarta.servlet.http.HttpServletRequest;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@SASScope(value="ALL")
public abstract class BaseESRIMapChart
extends BaseGraph {
    @SASScope
    public static final int DRILLDOWN = 0;
    @SASScope
    public static final int DRILLUP = 1;
    @SASScope
    public static final int ZOOMIN = 2;
    @SASScope
    public static final int ZOOMOUT = 3;
    @SASScope
    public static final int PAN = 4;
    @SASScope
    public static final int FULLEXTENT = 5;
    @SASScope
    public static final int IDENTIFY = 6;
    @SASScope
    public static final int EXPAND = 7;
    @SASScope
    public static final int COLLAPSE = 8;
    @SASScope
    public static final int SELECT = 9;
    @SASScope
    public static final int CLEARSELECTION = 10;
    @SASScope
    public static final int FILTER = 11;
    @SASScope
    public static final int REPORTLINKING = 12;
    @SASScope
    public static final int RECTANGULARSELECT = 13;
    @SASScope
    public static final String MAPCOMPONENT_MENUSTYLE = "MAPCOMPONENT_MENUSTYLE";
    @SASScope
    public static final String MAPCOMPONENT_SELECTEDMENUSTYLE = "MAPCOMPONENT_SELECTEDMENUSTYLE";
    @SASScope
    public static final String MAPCOMPOSITE_MAPLAYERSTYLE = "MAPCOMPOSITE_MAPLAYERSTYLE";
    @SASScope
    public static final String MAPCOMPOSITE_BACKGROUNDLAYERSTYLE = "MAPCOMPOSITE_BACKGROUNDLAYERSTYLE";
    @SASScope
    public static final String MAPCOMPOSITE_ZOOMLAYERSTYLE = "MAPCOMPOSITE_ZOOMLAYERSTYLE";
    @SASScope
    public static final String MAPCOMPOSITE_SELECTLAYERSTYLE = "MAPCOMPOSITE_SELECTLAYERSTYLE";
    @SASScope
    public static final String MAPCOMPOSITE_IDENTIFYLABELSTYLE = "MAPCOMPOSITE_IDENTIFYLABELSTYLE";
    @SASScope
    public static final String MAPCOMPOSITE_IDENTIFYTEXTSTYLE = "MAPCOMPOSITE_IDENTIFYTEXTSTYLE";
    @SASScope
    public static final String MAPCOMPOSITE_IDENTIFYCONTAINERSTYLE = "MAPCOMPOSITE_IDENTIFYCONTAINERSTYLE";
    @SASScope
    protected static final ImmutableStyleInfo menuStyle = new ImmutableStyleInfo("ESRIMenu");
    @SASScope
    protected static final ImmutableStyleInfo selectedMenuStyle = new ImmutableStyleInfo("");
    @SASScope
    protected static final ImmutableStyleInfo mapLayerStyle = new ImmutableStyleInfo("ESRIMapLayer");
    @SASScope
    protected static final ImmutableStyleInfo backgroundLayerStyle = new ImmutableStyleInfo("ESRIBackgroundLayer");
    @SASScope
    protected static final ImmutableStyleInfo zoomLayerStyle = new ImmutableStyleInfo("ESRIZoomLayer");
    @SASScope
    protected static final ImmutableStyleInfo selectLayerStyle = new ImmutableStyleInfo("ESRISelectLayer");
    @SASScope
    protected static final ImmutableStyleInfo identifyLabelStyle = new ImmutableStyleInfo("ESRIIdentifyLabel");
    @SASScope
    protected static final ImmutableStyleInfo identifyTextStyle = new ImmutableStyleInfo("ESRIIdentifyText");
    @SASScope
    protected static final ImmutableStyleInfo identifyContainerStyle = new ImmutableStyleInfo("ESRIIdentifyContainer");
    @SASScope
    protected static final String INTERNAL_RB_KEY = "MapComponent.";
    @SASScope
    protected static final Map defaultStyleMap = new HashMap();
    @SASScope
    private MapWithDefaults styleMap;
    @SASScope
    private boolean showFilter = false;
    @SASScope
    protected MapFilterSelectionsCommand filterCommand = null;
    @SASScope
    protected MapClearSelectionsCommand clearSelectionsCommand = null;
    protected int mode = 0;
    @SASScope
    protected String mapDesc = null;
    @SASScope
    protected String imageDesc = null;
    @SASScope
    protected boolean redrawMap = true;
    @SASScope
    protected boolean autoZoom = true;
    @SASScope
    protected boolean useSession = true;
    @SASScope
    protected ESRIMapDataModel model;
    @SASScope
    protected ESRIMapModel graphModel;
    @SASScope
    protected double[] mapExtents = new double[4];
    @SASScope
    protected boolean useSavedMapExtents = false;
    @SASScope
    protected Dimension mapSize = new Dimension(600, 300);
    protected Dimension legendSize = new Dimension(200, 250);
    @SASScope
    protected byte[] mapImageMimeData;
    @SASScope
    protected byte[] legendImageMimeData;
    @SASScope
    protected String preOnClickFunctionName = "";
    @SASScope
    protected String postOnClickFunctionName = "";
    @SASScope
    protected HashMap layerVisMap = null;
    @SASScope
    protected boolean clearSelectionsFlag = false;
    @SASScope
    private String legendImage = null;
    @SASScope
    protected ActionProviderMenuBar menuBar = null;
    @SASScope
    private Locale locale = null;
    @SASScope
    private String imageLocation;
    @SASScope
    private boolean disabledImage = false;
    @SASScope
    protected boolean actionPerformed = false;
    @SASScope
    protected boolean redrawComponent = true;
    @SASScope
    protected boolean debug;
    @SASScope
    protected Logger logger = LogManager.getLogger(BaseESRIMapChart.class);
    protected GraphStyle graphStyle;
    @SASScope
    protected boolean getNewMap = false;
    @SASScope
    protected String textMessage = null;

    public BaseESRIMapChart() {
        super((Object)new MyGraph());
        this.styleMap = new StyleMap();
    }

    @SASScope
    protected static synchronized void setupDefaultStyleMap() {
        if (defaultStyleMap.size() == 0) {
            defaultStyleMap.put(MAPCOMPONENT_MENUSTYLE, menuStyle);
            defaultStyleMap.put(MAPCOMPONENT_SELECTEDMENUSTYLE, selectedMenuStyle);
            defaultStyleMap.put(MAPCOMPOSITE_MAPLAYERSTYLE, mapLayerStyle);
            defaultStyleMap.put(MAPCOMPOSITE_BACKGROUNDLAYERSTYLE, backgroundLayerStyle);
            defaultStyleMap.put(MAPCOMPOSITE_ZOOMLAYERSTYLE, zoomLayerStyle);
            defaultStyleMap.put(MAPCOMPOSITE_SELECTLAYERSTYLE, selectLayerStyle);
            defaultStyleMap.put(MAPCOMPOSITE_IDENTIFYLABELSTYLE, identifyLabelStyle);
            defaultStyleMap.put(MAPCOMPOSITE_IDENTIFYTEXTSTYLE, identifyTextStyle);
            defaultStyleMap.put(MAPCOMPOSITE_IDENTIFYCONTAINERSTYLE, identifyContainerStyle);
        }
    }

    public Map getStyleMap() {
        return this.styleMap;
    }

    public void setStyleMap(StyleMap styleMap) {
        this.styleMap = styleMap;
    }

    @SASScope
    public void clearSelections(ESRIMap myMap) {
        try {
            myMap.clearSelections();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setShowFilter(false);
    }

    @SASScope
    public void setShowFilter(boolean b) {
        this.showFilter = b;
        if (this.filterCommand != null) {
            this.filterCommand.setFilterEnabled(b);
        }
        if (this.clearSelectionsCommand != null) {
            this.clearSelectionsCommand.setFilterEnabled(b);
        }
    }

    @SASScope
    public boolean isShowFilter() {
        return this.showFilter;
    }

    @SASScope
    public int getMode() {
        return this.mode;
    }

    @SASScope
    public void setMode(int mode) {
        this.mode = mode;
    }

    @SASScope
    public void resetToMap(ESRIMap map) {
        this.mapDesc = map.getMapDescription();
    }

    public boolean isRedrawMap() {
        return this.redrawMap;
    }

    public void setRedrawMap(boolean redrawMap) {
        this.redrawMap = redrawMap;
    }

    public boolean isAutoZoom() {
        return this.autoZoom;
    }

    public void setAutoZoom(boolean autoZoom) {
        this.autoZoom = autoZoom;
    }

    public void setGraphModel(ESRIMapModel m) {
        this.graphModel = m;
    }

    public ESRIMapModel getGraphModel() {
        return this.graphModel;
    }

    public void setDataModel(ESRIMapDataModel model) {
        this.model = model;
    }

    public ESRIMapDataModel getDataModel() {
        return this.model;
    }

    public void setMapExtents(double xmin, double xmax, double ymin, double ymax) {
        this.mapExtents[0] = xmin;
        this.mapExtents[1] = xmax;
        this.mapExtents[2] = ymin;
        this.mapExtents[3] = ymax;
    }

    public double[] getMapExtents() {
        double[] extents = new double[4];
        System.arraycopy(this.mapExtents, 0, extents, 0, 4);
        return this.mapExtents;
    }

    public void setMapExtents(double[] extents) {
        System.arraycopy(extents, 0, this.mapExtents, 0, 4);
    }

    @SASScope
    public boolean isUseSavedMapExtents() {
        return this.useSavedMapExtents;
    }

    public void setUseSavedMapExtents(boolean useSavedMapExtents) {
        this.useSavedMapExtents = useSavedMapExtents;
    }

    public void setSize(int width, int height) {
        width = Math.max(Math.min(width, 2000), 50);
        height = Math.max(Math.min(height, 2000), 50);
        super.setSize(width, height);
        this.mapSize = new Dimension((int)((double)width * 0.75), height);
        this.legendSize = new Dimension((int)((double)width * 0.25), height - 45);
    }

    public Dimension getMapSize() {
        return new Dimension(this.mapSize);
    }

    public Dimension getLegendSize() {
        return new Dimension(this.legendSize);
    }

    public byte[] getLegendImageMimeData() {
        return this.legendImageMimeData;
    }

    @SASScope
    public void resetMapLegend() {
        this.legendImageMimeData = null;
    }

    public byte[] getMapImageMimeData() {
        return this.mapImageMimeData;
    }

    @SASScope
    public void cleanUpResources() {
        super.cleanUpResources();
        this.cleanUpImages();
    }

    @SASScope
    public void cleanUpImages() {
        this.mapImageMimeData = null;
        this.legendImageMimeData = null;
    }

    @SASScope
    public String getPostOnClickFunctionName() {
        return this.postOnClickFunctionName;
    }

    @SASScope
    public void setPostOnClickFunctionName(String postOnClickFunctionName) {
        this.postOnClickFunctionName = postOnClickFunctionName;
    }

    @SASScope
    public String getPreOnClickFunctionName() {
        return this.preOnClickFunctionName;
    }

    @SASScope
    public void setPreOnClickFunctionName(String preOnClickFunctionName) {
        this.preOnClickFunctionName = preOnClickFunctionName;
    }

    @SASScope
    private HashMap getLayerVisibilitiesFromESRIMap(ESRIMap esriMap) {
        try {
            HashMap map = esriMap.getLayerVisibilities();
            if (this.model instanceof ESRIMapOLAPDataModel) {
                String[] s = ((ESRIMapOLAPDataModel)this.model).getLevelToLayerMap().values().toArray(new String[0]);
                for (int i = 0; i < s.length; ++i) {
                    map.remove(s[i]);
                }
            }
            return map;
        }
        catch (ESRIException e) {
            return null;
        }
    }

    public HashMap getLayerVisibilities() {
        if (this.layerVisMap == null) {
            ESRIMap myMap = this.getESRIMap();
            if (myMap != null) {
                this.layerVisMap = this.getLayerVisibilitiesFromESRIMap(myMap);
            }
            try {
                if (myMap != null) {
                    myMap.disconnect();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            return this.layerVisMap;
        }
        return this.layerVisMap;
    }

    public HashMap getDefaultLayerVisibilities() {
        HashMap layerVisMap = null;
        this.getNewMap = true;
        ESRIMap myMap = this.getESRIMap();
        this.resetToMap(myMap);
        if (myMap != null) {
            layerVisMap = this.getLayerVisibilitiesFromESRIMap(myMap);
            if (layerVisMap == null) {
                return null;
            }
            if (this.model instanceof ESRIMapOLAPDataModel) {
                String[] s = ((ESRIMapOLAPDataModel)this.model).getLevelToLayerMap().values().toArray(new String[0]);
                for (int i = 0; i < s.length; ++i) {
                    layerVisMap.remove(s[i]);
                }
            }
        }
        try {
            if (myMap != null) {
                myMap.disconnect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return layerVisMap;
    }

    public void setLayerVisibility(String layer, String visible) {
        HashMap hash = this.getLayerVisibilities();
        hash.put(layer, visible);
    }

    public void setLayerVisibilities(HashMap hash) {
        this.layerVisMap = (HashMap)hash.clone();
    }

    public boolean isUseSession() {
        return this.useSession;
    }

    public void setUseSession(boolean useSession) {
        this.useSession = useSession;
    }

    @SASScope
    public String getLegendImage() {
        return this.legendImage;
    }

    @SASScope
    public void setLegendImage(String legendImage) {
        this.legendImage = legendImage;
    }

    @SASScope
    protected void writeFastClickProtection(PrintWriter out, boolean isConnectionSecure) throws IOException {
        out.println("<script type='text/javascript'>");
        String processText = "Processing";
        out.println(" if ( sas_FastClick_createFastClickManager != null && typeof sas_FastClick_createFastClickManager == 'function' ) ");
        out.println(" { ");
        if (isConnectionSecure) {
            out.println(" sas_FastClick_createFastClickManager('\\StreamContentServlet?NOOP=true',\"" + processText + "\");");
        } else {
            out.println(" sas_FastClick_createFastClickManager(null,\"" + processText + "\");");
        }
        out.println(" } ");
        out.println("</script>");
    }

    @SASScope
    protected void setStyleOnESRIMap(ESRIMap map) {
        try {
            Color selectionColor = this.graphModel.getSelectionColor();
            map.applyGraphStyle(this.graphStyle);
            map.setSelectionColor(selectionColor);
            map.setUseTwoColorRamp(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void applyGraphStyle(GraphStyle style) {
        this.graphStyle = style;
    }

    @SASScope
    public void setColorScheme(String colorScheme) {
    }

    @SASScope
    public ActionProviderMenuBar getMenuBar() {
        return this.menuBar;
    }

    @SASScope
    public void setMenuBar(ActionProviderMenuBar menuBar) {
        this.menuBar = menuBar;
    }

    public void setLocale(Locale loc) {
        if (loc != null && !loc.equals(this.locale) || this.locale != null && !this.locale.equals(loc)) {
            if (loc == null) {
                if (!Locale.getDefault().equals(this.locale)) {
                    this.setLocaleDependentProperties(Locale.getDefault());
                }
            } else {
                this.setLocaleDependentProperties(loc);
            }
            this.locale = loc;
        }
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return this.getRequestLocale() == null ? Locale.getDefault() : this.getRequestLocale();
        }
        return this.locale;
    }

    public String getImageLocation() {
        if (this.imageLocation != null) {
            return this.imageLocation;
        }
        return ComponentPropertyManager.getInstance((HttpServletRequest)this.getRequest()).getImageLocation();
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public boolean isDisabledImage() {
        return this.disabledImage;
    }

    public void setDisabledImage(boolean disabledImage) {
        this.disabledImage = disabledImage;
    }

    @SASScope
    public boolean isRedrawComponent() {
        return this.redrawComponent;
    }

    @SASScope
    public void setRedrawComponent(boolean redrawComponent) {
        this.redrawComponent = redrawComponent;
    }

    @SASScope
    protected byte[] addNote(byte[] imageData, String note) {
        BufferedImage bimage = new BufferedImage(this.mapSize.width, this.mapSize.height, 1);
        Graphics2D g = bimage.createGraphics();
        BufferedImage mi = MapImageUtil.getImageFromByteStream(imageData, this.mapSize.width, this.mapSize.height);
        g.drawImage((Image)mi, 0, 0, null);
        if (note != null) {
            g.setColor(Color.black);
            Font f = FontManager.getDefaultFont();
            FontMetrics fm = g.getFontMetrics(f);
            char[] footnoteString = note.toCharArray();
            int ascent = fm.getAscent();
            int descent = fm.getDescent();
            int centerY = this.mapSize.height / 2;
            int top = centerY - ascent;
            int height = ascent + descent;
            top -= height / 2;
            height *= 2;
            Rectangle2D r = fm.getStringBounds(footnoteString, 0, footnoteString.length, (Graphics)g);
            int i = this.mapSize.height / 2 - f.getSize() / 2;
            int xLoc = this.mapSize.width / 2 - (int)r.getWidth() / 2;
            g.setColor(Color.WHITE);
            int x1 = (int)((double)r.getBounds().width * 0.2);
            int y1 = (int)((double)r.getBounds().width * 1.4);
            g.fillRect(xLoc - (int)((double)r.getBounds().width * 0.2), top, (int)((double)r.getBounds().width * 1.4), height);
            g.setColor(Color.BLACK);
            ((Graphics)g).drawString(note, this.mapSize.width / 2 - (int)r.getWidth() / 2, centerY);
            g.drawRect(xLoc - (int)((double)r.getBounds().width * 0.2), top, (int)((double)r.getBounds().width * 1.4), height);
        }
        byte[] bs = null;
        try {
            bs = MapImageUtil.getPngByteStream(bimage);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bs;
    }

    @SASScope
    protected String getSelectedImage(HttpAction action) {
        if (action != null) {
            return (String)action.getAttribute(BaseMapStrategy.SELECTED_IMAGE);
        }
        return null;
    }

    @SASScope
    protected String getImage(HttpAction action) {
        if (action != null) {
            return (String)action.getAttribute("SmallIconName");
        }
        return null;
    }

    @SASScope
    protected String getDisabledImage(HttpAction action) {
        if (action != null) {
            return (String)action.getAttribute("SmallDisabledIconName");
        }
        return null;
    }

    @SASScope
    protected static String getUrl(HttpAction action) {
        if (action != null) {
            return (String)action.getAttribute("URL");
        }
        return null;
    }

    @SASScope
    public ESRIMap getESRIMap() {
        ESRIMap myMap;
        block7: {
            myMap = null;
            try {
                myMap = new ESRIMap(this.getDataModel().getESRIConnection());
                myMap.setLocale(this.getLocale());
                myMap.setMapImageSize(this.mapSize);
                myMap.setLegendImageSize(this.legendSize);
                myMap.connect();
                if (this.mapDesc != null && this.imageDesc != null && !this.getNewMap) {
                    myMap.getMap(this.mapDesc, this.imageDesc);
                } else {
                    myMap.getMap();
                    this.getNewMap = false;
                }
                this.setStyleOnESRIMap(myMap);
                if (this.layerVisMap == null || this.layerVisMap.size() <= 0) break block7;
                String[] s = this.layerVisMap.values().toArray(new String[0]);
                String[] o = this.layerVisMap.keySet().toArray(new String[0]);
                try {
                    for (int i = 0; i < s.length; ++i) {
                        myMap.setLayerVisibility(o[i], s[i]);
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (Exception e) {
                String s = Message.format((String)RB.getStringResource(INTERNAL_RB_KEY, "ConnectionError.fmt.txt", this.getLocale()), (Object)this.getDataModel().getESRIConnection().getMapServiceName(), (Object)this.getDataModel().getESRIConnection().getGisServer());
                System.out.println(s);
                this.textMessage = s;
                this.actionPerformed = true;
                this.printDebugInfo(myMap);
                this.resetMapLegend();
                return null;
            }
        }
        return myMap;
    }

    public abstract void printDebugInfo(ESRIMap var1);

    public boolean isDebug() {
        return this.graphModel.isDebug();
    }

    public void setDebug(boolean debug) {
        this.graphModel.setDebug(debug);
    }

    @SASScope
    private static class MyGraph
    extends Graph {
        private MyGraph() {
        }

        public void prepareToPaint() {
        }

        public void setAutoRepaintEnabled(boolean arg0) {
        }

        public boolean isAutoRepaintEnabled() {
            return false;
        }

        protected void applyDataModel() {
        }

        protected void selectionChanged() {
        }

        protected void updateDataModelListeners() {
        }
    }
}

