/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.esrimap;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.map.ESRIConnection;
import com.sas.graphics.map.ESRIMap;
import com.sas.graphics.map.MapImageUtil;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

@SASScope
public class ESRIMapComponent
extends JComponent {
    public static final int MODE_ZOOM_IN = 0;
    public static final int MODE_ZOOM_OUT = 1;
    public static final int MODE_PAN = 2;
    public static final int MODE_FULL_EXTENTS = 3;
    private ESRIConnection connection = null;
    private String mapDesc = null;
    private String imageDesc = null;
    private BufferedImage bi = null;
    private int mode = 0;

    public ESRIMapComponent(ESRIConnection c) {
        this.connection = c;
    }

    @Override
    public void paint(Graphics g) {
        ESRIMap map = new ESRIMap(this.connection);
        try {
            map.setMapImageSize(this.getSize());
            map.connect();
            if (this.mapDesc != null && this.imageDesc != null) {
                map.getMap(this.mapDesc, this.imageDesc);
            } else {
                map.getMap();
            }
            byte[] mapImageMimeData = map.getImageMimeData();
            this.mapDesc = map.getMapDescription();
            this.imageDesc = map.getImageDescription();
            map.disconnect();
            this.bi = MapImageUtil.getImageFromByteStream(mapImageMimeData, 600, 300);
            g.drawImage(this.bi, 0, 0, null);
        }
        catch (Exception mapImageMimeData) {
            // empty catch block
        }
        try {
            if (map != null) {
                map.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ESRIConnection getConnection() {
        return this.connection;
    }

    public void setConnection(ESRIConnection connection) {
        this.connection = connection;
    }
}

