/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.support;

import com.sas.actionprovider.ActionOrderList;
import com.sas.actionprovider.ActionProviderMapPool;
import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.Area;
import com.sas.actionprovider.BaseAction;
import com.sas.actionprovider.HttpAction;
import com.sas.actionprovider.strategies.ActionStrategyInterface;
import com.sas.actionprovider.strategies.ESRIMapStrategyFactory;
import com.sas.actionprovider.strategies.MapActionValueKeys;
import com.sas.actionprovider.support.BaseActionProviderSupport;
import com.sas.codepolicy.SASScope;
import java.util.HashMap;
import java.util.Map;

@SASScope
public class RelationalESRIMapSupport
extends BaseActionProviderSupport
implements MapActionValueKeys {
    public RelationalESRIMapSupport(Class actionClass) {
        super(actionClass);
        this.addAreaType("MAP_AREA");
        this.addAreaType("DATA_VALUE_AREA");
    }

    protected BaseAction createAndRegisterAction(String areaType, String actionType) {
        BaseAction action = this.newActionInstance(areaType, actionType);
        this.addDefaultAction(action, areaType);
        return action;
    }

    protected void registerDynamicValueInfo() {
        this.addDynamicValueInfo("MAP_AREA", "model", null, null, null, false);
    }

    public BaseAction newActionInstance(String actionArea, String actionType) {
        HttpAction action = null;
        Class _actionClass = this.getActionClass();
        if (_actionClass != null) {
            ActionStrategyInterface asi = ESRIMapStrategyFactory.getActionStrategy(actionArea, actionType, true);
            try {
                action = (HttpAction)_actionClass.newInstance();
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (IllegalAccessException ie) {
                return null;
            }
            if (actionType.equals("IDENTIFY_ACTION")) {
                action.setURLBase("MethodInvocationServlet?CLASS_PARAMETER=com.sas.servlet.tbeans.graphics.html.ESRIMapChart&ServletName=IdentifyWindow");
            } else if (actionType.equals("ZOOMIN_ACTION")) {
                action.setURLBase("MethodInvocationServlet?CLASS_PARAMETER=com.sas.servlet.tbeans.graphics.html.ESRIMapChart&ServletName=ZoomIn");
            } else if (actionType.equals("ZOOMOUT_ACTION")) {
                action.setURLBase("MethodInvocationServlet?CLASS_PARAMETER=com.sas.servlet.tbeans.graphics.html.ESRIMapChart&ServletName=ZoomOut");
            } else if (actionType.equals("PAN_ACTION")) {
                action.setURLBase("MethodInvocationServlet?CLASS_PARAMETER=com.sas.servlet.tbeans.graphics.html.ESRIMapChart&ServletName=Pan");
            } else if (actionType.equals("SELECT_ACTION")) {
                action.setURLBase("MethodInvocationServlet?CLASS_PARAMETER=com.sas.servlet.tbeans.graphics.html.ESRIMapChart&ServletName=Select");
            } else if (actionType.equals("RECTANGULARSELECT_ACTION")) {
                action.setURLBase("MethodInvocationServlet?CLASS_PARAMETER=com.sas.servlet.tbeans.graphics.html.ESRIMapChart&ServletName=RectangularSelect");
            }
            action.setActionStrategy(asi);
            action.setActionType(actionType);
            action.setActionStrategy(asi);
            asi.initializeAction((BaseAction)action, actionArea, this.getLocale());
        }
        return action;
    }

    protected Map getAreaScopeAttributeMap(ActionSupportFilter filter) {
        HashMap areaScopeAttributeMap = ActionProviderMapPool.getMap();
        return areaScopeAttributeMap;
    }

    protected boolean validArea(Area area, ActionSupportFilter filter) {
        return true;
    }

    protected Map initializeShortActionTypeMap() {
        Map shortActionTypeMap = super.initializeShortActionTypeMap();
        shortActionTypeMap.put("DRILLDOWN_ACTION", "DRILLDOWN_ACTION");
        shortActionTypeMap.put("EXPAND_ACTION", "EXPAND_ACTION");
        shortActionTypeMap.put("COLLAPSE_ACTION", "COLLAPSE_ACTION");
        shortActionTypeMap.put("SELECT_ACTION", "SELECT_ACTION");
        shortActionTypeMap.put("RECTANGULARSELECT_ACTION", "RECTANGULARSELECT_ACTION");
        shortActionTypeMap.put("ZOOMIN_ACTION", "ZOOMIN_ACTION");
        shortActionTypeMap.put("ZOOMOUT_ACTION", "ZOOMOUT_ACTION");
        shortActionTypeMap.put("PAN_ACTION", "PAN_ACTION");
        shortActionTypeMap.put("IDENTIFY_ACTION", "IDENTIFY_ACTION");
        shortActionTypeMap.put("REPORTLINKING_ACTION", "REPORTLINKING_ACTION");
        shortActionTypeMap.put("RESIZE_GRAPH_ACTION", "RESIZE_GRAPH_ACTION");
        shortActionTypeMap.put("SETMEASURE_ACTION", "SETMEASURE_ACTION");
        return shortActionTypeMap;
    }

    public void initialize() {
        this.createAndRegisterAction("MAP_AREA", "SELECT_ACTION");
        this.createAndRegisterAction("MAP_AREA", "RECTANGULARSELECT_ACTION");
        this.createAndRegisterAction("MAP_AREA", "ZOOMIN_ACTION");
        this.createAndRegisterAction("MAP_AREA", "ZOOMOUT_ACTION");
        this.createAndRegisterAction("MAP_AREA", "PAN_ACTION");
        this.createAndRegisterAction("MAP_AREA", "IDENTIFY_ACTION");
        this.createAndRegisterAction("DATA_VALUE_AREA", "RESIZE_GRAPH_ACTION");
        this.createAndRegisterAction("MAP_AREA", "REPORTLINKING_ACTION");
        ActionOrderList newOrderList = new ActionOrderList("ROOT_NAME");
        newOrderList.setEnabledIfEmpty(false);
        newOrderList.add((Object)"SELECT_ACTION");
        newOrderList.add((Object)"RECTANGULARSELECT_ACTION");
        newOrderList.add((Object)"ZOOMIN_ACTION");
        newOrderList.add((Object)"ZOOMOUT_ACTION");
        newOrderList.add((Object)"PAN_ACTION");
        newOrderList.add((Object)"IDENTIFY_ACTION");
        this.setActionOrderList(newOrderList, null, "MAP_AREA");
    }
}

