/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.commands.MapBaseCommand;
import com.sas.graphics.map.ESRIMap;
import com.sas.servlet.tbeans.graphics.BaseESRIMapChart;
import jakarta.servlet.http.HttpServletRequest;

public class MapZoomInCommand
extends MapBaseCommand {
    private int clickX;
    private int clickY;
    private int width;
    private int height;
    private Object mapViewer;

    public MapZoomInCommand(String name) {
        super(name);
    }

    @Override
    public void execute(Object o) {
        BaseESRIMapChart map = (BaseESRIMapChart)((Object)this.getMapViewer());
        if (map == null) {
            return;
        }
        map.setRequest((HttpServletRequest)this.getAttribute("request"));
        ESRIMap esriMap = map.getESRIMap();
        try {
            if (this.width < 0) {
                this.clickX += this.width;
                this.width = 0 - this.width;
            }
            if (this.height < 0) {
                this.clickY += this.height;
                this.height = 0 - this.height;
            }
            if (this.width != 0 && this.height != 0) {
                esriMap.zoomTo(this.clickX, this.clickY, this.clickX + this.width, this.clickY + this.height);
                esriMap.resetMapDescription();
                map.resetToMap(esriMap);
                map.setMapExtents(esriMap.getMapExtents());
            }
            map.setAutoZoom(false);
            map.setRedrawMap(true);
            map.setMode(2);
            this.contentsChanged = true;
            this.eventInfo.clear();
            this.eventInfo.put("ESRIMAP", "ZOOMIN");
            this.setEventSource((Object)map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            esriMap.disconnect();
            esriMap = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        return 0;
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }

    public int getClickX() {
        return this.clickX;
    }

    public void setClickX(int clickX) {
        this.clickX = clickX;
    }

    public int getClickY() {
        return this.clickY;
    }

    public void setClickY(int clickY) {
        this.clickY = clickY;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

