/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.BaseCommand;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.graphics.components.esrimap.ESRIMapTableDataModel;
import com.sas.graphics.map.ESRIMap;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.servlet.tbeans.graphics.BaseESRIMapChart;
import com.sas.servlet.tbeans.graphics.html.ESRIMapChart;
import com.sas.servlet.tbeans.olapgraphics.html.MapOLAPUtil;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.iquery.BusinessQueryToTableModelAdapter;
import com.sas.storage.olap.LevelInterface;
import com.sas.storage.olap.MemberInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.OLAPUtil;
import com.sas.storage.olap.TupleElementInterface;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class MapReportLinkingCommand
extends BaseCommand {
    private Object mapViewer;
    private ArrayList parmValues = null;

    public MapReportLinkingCommand(String name) {
        super(name);
    }

    public void execute(Object o) {
        this.parmValues = new ArrayList();
        BaseESRIMapChart map = (BaseESRIMapChart)((Object)this.getMapViewer());
        if (map == null) {
            return;
        }
        map.setRequest((HttpServletRequest)this.getAttribute("request"));
        ESRIMap esriMap = map.getESRIMap();
        try {
            if (map instanceof OLAPESRIMapChart) {
                String[] selectList = esriMap.getSelectList(((ESRIMapOLAPDataModel)map.getDataModel()).getLayerToFieldMap());
                String[] layerList = new String[selectList.length / 2];
                String[] valueList = new String[selectList.length / 2];
                for (int i = 0; i < selectList.length; i += 2) {
                    layerList[i / 2] = selectList[i];
                    valueList[i / 2] = selectList[i + 1];
                }
                ArrayList myList = this.getTuples(map, layerList, valueList);
                int count = myList.size();
                for (int j = 0; j < count; ++j) {
                    TupleElementInterface tuple = (TupleElementInterface)myList.get(j);
                    DataItem di = this.getDataItem((OLAPESRIMapChart)map, tuple);
                    ArrayList tempValues = this.getLevelValuePairs((OLAPESRIMapChart)map, tuple);
                    ReportLinkElement rle = new ReportLinkElement(di, tempValues, tuple);
                    this.parmValues.add(rle);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            esriMap.disconnect();
            esriMap = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private DataItem getDataItem(OLAPESRIMapChart map, TupleElementInterface te) {
        MapOLAPUtil olapUtil = map.getOLAPUtil();
        try {
            OLAPDataSetInterface dsi = olapUtil.getDataModel();
            BusinessQuery businessQuery = ((BusinessQueryProviderInterface)dsi).getBusinessQuery();
            DataItem dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, null, (Object)te, (int)1);
            return dataItem;
        }
        catch (Exception e) {
            return null;
        }
    }

    private ArrayList getLevelValuePairs(OLAPESRIMapChart mapChart, TupleElementInterface tuple) throws OLAPException {
        ArrayList<LevelValuePair> al = new ArrayList<LevelValuePair>();
        MapOLAPUtil olapUtil = mapChart.getOLAPUtil();
        MemberInterface[] mi = olapUtil.getLevels(tuple);
        for (int j = 0; j < mi.length; ++j) {
            if (OLAPUtil.isAllLevel((LevelInterface)mi[j].getLevel())) continue;
            String s = mi[j].getLevel().getUniqueName();
            LevelValuePair mvp = new LevelValuePair(s, mi[j].getLabel());
            al.add(mvp);
        }
        return al;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        return 0;
    }

    private ArrayList getTuples(BaseESRIMapChart mapChart, String[] layerNames, String[] values) {
        HashMap map = new HashMap(layerNames.length);
        for (int i = 0; i < layerNames.length; ++i) {
            List<String> value = map.containsKey(layerNames[i]) ? (List)map.get(layerNames[i]) : new ArrayList<String>();
            value.add(values[i]);
            map.put(layerNames[i], value);
        }
        return this.getTuples(mapChart, map);
    }

    private ArrayList getTuples(BaseESRIMapChart mapChart, Map layerUniqueNames) {
        block8: {
            ESRIMapTableDataModel dm;
            TableModel tm;
            ArrayList<TupleElementInterface> myList = new ArrayList<TupleElementInterface>();
            if (mapChart instanceof OLAPESRIMapChart) {
                try {
                    MapOLAPUtil olapUtil = ((OLAPESRIMapChart)mapChart).getOLAPUtil();
                    OLAPDataSetInterface dsi = olapUtil.getDataModel();
                    if (dsi != null && dsi instanceof BusinessQueryProviderInterface) {
                        for (String layerName : layerUniqueNames.keySet()) {
                            List l = (List)layerUniqueNames.get(layerName);
                            if (l.isEmpty()) continue;
                            for (int i = 0; i < l.size(); ++i) {
                                String uniqueID = (String)l.get(i);
                                TupleElementInterface te = olapUtil.getTupleElement(layerName, uniqueID);
                                myList.add(te);
                            }
                        }
                        return myList;
                    }
                    break block8;
                }
                catch (Exception oe) {
                    return null;
                }
            }
            if (mapChart instanceof ESRIMapChart && (tm = (dm = (ESRIMapTableDataModel)mapChart.getDataModel()).getModel()) instanceof BusinessQueryToTableModelAdapter) {
                BusinessQueryToTableModelAdapter query = (BusinessQueryToTableModelAdapter)tm;
                BusinessQuery bq = query.getBusinessQuery();
                for (String layerName : layerUniqueNames.keySet()) {
                    List l = (List)layerUniqueNames.get(layerName);
                    if (l.isEmpty()) continue;
                }
            }
        }
        return null;
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }

    public ArrayList getParmValues() {
        return this.parmValues;
    }

    protected class ReportLinkElement {
        DataItem dataItem;
        TupleElementInterface tupleElement;
        ArrayList levelsAndValues;

        public ReportLinkElement(DataItem di, ArrayList l, TupleElementInterface te) {
            this.dataItem = di;
            this.levelsAndValues = l;
            this.tupleElement = te;
        }

        public DataItem getDataItem() {
            return this.dataItem;
        }

        public void setDataItem(DataItem dataItem) {
            this.dataItem = dataItem;
        }

        public ArrayList getLevelsAndValues() {
            return this.levelsAndValues;
        }

        public void setLevelsAndValues(ArrayList level) {
            this.levelsAndValues = level;
        }

        public TupleElementInterface getTupleElement() {
            return this.tupleElement;
        }

        public void setTupleElement(TupleElementInterface tupleElement) {
            this.tupleElement = tupleElement;
        }
    }

    protected class LevelValuePair {
        String level;
        String value;

        public LevelValuePair(String l, String v) {
            this.level = l;
            this.value = v;
        }

        public String getLevel() {
            return this.level;
        }

        public void setLevel(String level) {
            this.level = level;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

