/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.dataselectors.BaseSelectorCommand;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.esrimap.ESRIMapModel;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.graphics.components.esrimap.ESRIMapTableDataModel;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.servlet.tbeans.dataselectors.crossing.html.MapCrossingSelector;
import com.sas.servlet.tbeans.dataselectors.customizer.html.MapPropertySelector;
import com.sas.servlet.tbeans.dataselectors.html.SelectorPanel;
import com.sas.servlet.tbeans.graphics.BaseESRIMapChart;
import com.sas.servlet.tbeans.graphics.html.ESRIMapChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapPropertyCommand
extends BaseSelectorCommand {
    private Object mapViewer;
    private String[] crossing;
    private Object geo;
    private int numberOfColors;
    private String size;
    private int width;
    private int height;
    private int colorRegions;
    private boolean showCrossing;
    private String selectedRegionColor;
    private String[] layers;
    private String[] selectedCrossing;
    private String measure;
    private List layersList;

    public MapPropertyCommand(String name) {
        super(name);
    }

    public MapPropertyCommand(String name, String actionClass) {
        this(name);
        this.actionClass = actionClass;
    }

    protected void show(Object o) {
        this.model = this.getModel();
        BaseESRIMapChart mc = null;
        if (this.getMapViewer() != null) {
            mc = (BaseESRIMapChart)((Object)this.getMapViewer());
        }
        MapPropertySelector selector = null;
        if (this.getSelector() != null) {
            MapCrossingSelector mcs;
            selector = (MapPropertySelector)this.getSelector();
            selector.setSelectorModel(this.getModel());
            selector.setMapComponent(mc);
            SelectorPanel sp = selector.getDataSelectorPanel();
            if (mc instanceof OLAPESRIMapChart && (mcs = (MapCrossingSelector)sp.getComponent("MAPPROPERTY_CROSSING_SELECTOR")) != null) {
                mcs.setSelectorModel(this.getModel());
                if (this.getGeo() != null) {
                    mcs.setGeoString((String)this.getGeo());
                }
                if (this.getCrossing() != null) {
                    mcs.setCrossing(this.getCrossing());
                }
            }
        }
        super.show(o);
    }

    protected void process(Object o) {
        this.eventInfo.clear();
        this.contentsChanged = true;
        this.eventInfo.put("request", this.getAttribute("request"));
        this.eventInfo.put("response", this.getAttribute("response"));
        super.process(o);
    }

    public void cancel(Object o) {
        this.eventInfo.clear();
        super.cancel(o);
    }

    protected void commit(Object o) throws IOException {
        BaseESRIMapChart mc = null;
        if (this.getMapViewer() != null) {
            mc = (BaseESRIMapChart)((Object)this.getMapViewer());
            ESRIMapModel model = mc.getGraphModel();
            int algorithm = this.getColorRegions();
            boolean renderAlgorithm = true;
            String color = this.getSelectedRegionColor();
            if (color == null || color != null && color.length() != 7) {
                color = "#ffff00";
            }
            String r = color.substring(1, 3);
            String g = color.substring(3, 5);
            String b = color.substring(5, 7);
            int _r = this.parseInt(r);
            int _g = this.parseInt(g);
            int _b = this.parseInt(b);
            model.setSelectionColor(new Color(_r, _g, _b));
            CategorizationModel cm = CategorizationModel.newCategorizationModel((int)algorithm, (int)this.getNumberOfColors());
            mc.getSize().getHeight();
            if (mc instanceof OLAPESRIMapChart) {
                ((ESRIMapOLAPDataModel)mc.getDataModel()).setCategorizationModel(cm);
            } else if (mc instanceof ESRIMapChart) {
                Variable oldVar = ((ESRIMapTableDataModel)mc.getDataModel()).getChoroVariable();
                Variable newVar = new Variable(oldVar.getColumnIndex(), oldVar.getFormat(), oldVar.getInformat(), oldVar.getLabel(), cm, null);
                ((ESRIMapTableDataModel)mc.getDataModel()).setChoroVariable(newVar);
            }
            String size = this.getSize();
            if (size != null) {
                if (size.equalsIgnoreCase("CUSTOM")) {
                    mc.setSize(this.getWidth(), this.getHeight());
                } else if (size.equalsIgnoreCase("SMALL")) {
                    mc.setSize(400, 250);
                } else if (size.equalsIgnoreCase("MEDIUM")) {
                    mc.setSize(800, 300);
                } else if (size.equalsIgnoreCase("LARGE")) {
                    mc.setSize(800, 600);
                }
            }
            if (mc instanceof OLAPESRIMapChart) {
                ((OLAPESRIMapChart)mc).setShowCrossing(this.showCrossing);
                String[] members = this.getSelectedCrossing();
                if (members.length == 1 && (members[0].equalsIgnoreCase("null") || members[0].equalsIgnoreCase(""))) {
                    members = new String[]{};
                }
                String[] crossingInformation = new String[members.length + 1];
                for (int i = 0; i < members.length; ++i) {
                    crossingInformation[i] = members[i];
                }
                try {
                    String measure = this.getMeasure();
                    if (measure != null) {
                        crossingInformation[members.length] = measure;
                    }
                    ((OLAPESRIMapChart)mc).setCrossing(crossingInformation);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            mc.setLayerVisibilities(this.getLayersMap(this.getLayersList(), mc.getLayerVisibilities()));
            mc.setRedrawMap(true);
        }
        this.eventInfo.clear();
        super.commit(o);
    }

    protected HashMap getLayersMap(List layersList, Map layers) {
        HashMap<String, String> layersMap = new HashMap<String, String>();
        Set keys = layers.keySet();
        for (String key : keys) {
            if (layersList != null && layersList.contains(key)) {
                layersMap.put(key, "UseMapServiceRules");
                continue;
            }
            layersMap.put(key, "AlwaysOff");
        }
        return layersMap;
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        Object dataModel = actionFilter.getAttribute("model");
        return dataModel instanceof BusinessQueryProviderInterface;
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }

    public Object getGeo() {
        return this.geo;
    }

    public void setGeo(Object geo) {
        this.geo = geo;
    }

    public String[] getCrossing() {
        return this.crossing;
    }

    public void setCrossing(String[] crossing) {
        this.crossing = crossing;
    }

    public int getNumberOfColors() {
        return this.numberOfColors;
    }

    public void setNumberOfColors(int numberOfColors) {
        this.numberOfColors = numberOfColors;
    }

    public int getColorRegions() {
        return this.colorRegions;
    }

    public void setColorRegions(int colorRegions) {
        this.colorRegions = colorRegions;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public String getSelectedRegionColor() {
        return this.selectedRegionColor;
    }

    public void setSelectedRegionColor(String selectedRegionColor) {
        this.selectedRegionColor = selectedRegionColor;
    }

    private int parseInt(String hex) throws NumberFormatException {
        if (hex == null) {
            throw new IllegalArgumentException("Null string in hexadecimal notation.");
        }
        if (hex.equals("")) {
            return 0;
        }
        Integer num = Integer.decode("0x" + hex);
        long n = num.longValue();
        if (n > 0xFFFFFFFFL || n < 0L) {
            throw new NumberFormatException("Out of range for integer.");
        }
        return num;
    }

    public String[] getLayers() {
        return this.layers;
    }

    protected List getLayersList() {
        return this.layersList;
    }

    public void setLayers(String[] layers) {
        if (layers != null && layers.length > 0) {
            if (this.layersList == null) {
                this.layersList = new ArrayList();
            } else {
                this.layersList.clear();
            }
            for (int i = 0; i < layers.length; ++i) {
                this.layersList.add(layers[i]);
            }
        }
        this.layers = layers;
    }

    public String[] getSelectedCrossing() {
        return this.selectedCrossing;
    }

    public void setSelectedCrossing(String[] selectedCrossing) {
        this.selectedCrossing = selectedCrossing;
    }

    public String getMeasure() {
        return this.measure;
    }

    public void setMeasure(String measure) {
        this.measure = measure;
    }

    public boolean isShowCrossing() {
        return this.showCrossing;
    }

    public void setShowCrossing(boolean showCrossing) {
        this.showCrossing = showCrossing;
    }

    private int convertCategorization(int type) {
        switch (type) {
            case 1: {
                return 12000;
            }
            case 2: {
                return 12002;
            }
            case 3: {
                return 12003;
            }
        }
        return 12001;
    }
}

