/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.commands.BaseCommand;
import com.sas.commands.ContentsChangedInterface;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.graphics.components.esrimap.ESRIMapTableDataModel;
import com.sas.graphics.map.ESRIMap;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.iquery.metadata.business.BusinessQuery;
import com.sas.iquery.metadata.business.DataItem;
import com.sas.iquery.metadata.business.step.StepInterface;
import com.sas.iquery.metadata.business.step.olap.DataItemMemberFilter;
import com.sas.servlet.tbeans.graphics.BaseESRIMapChart;
import com.sas.servlet.tbeans.graphics.html.ESRIMapChart;
import com.sas.servlet.tbeans.olapgraphics.html.MapOLAPUtil;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import com.sas.storage.iquery.BusinessQueryToOLAPDataSetAdapter;
import com.sas.storage.iquery.BusinessQueryToTableModelAdapter;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;

public class MapFilterSelectionsCommand
extends BaseCommand
implements ContentsChangedInterface,
CommandStatusInterface {
    private Object mapViewer;
    protected HashMap eventInfo = new HashMap(2);
    protected boolean contentsChanged = false;
    protected Object eventSource = null;
    protected boolean filterEnabled = false;

    public MapFilterSelectionsCommand(String name) {
        super(name);
    }

    public void execute(Object o) {
        BaseESRIMapChart map = (BaseESRIMapChart)((Object)this.getMapViewer());
        if (map == null) {
            return;
        }
        map.setRequest((HttpServletRequest)this.getAttribute("request"));
        ESRIMap esriMap = map.getESRIMap();
        try {
            String[] selectList = esriMap.getSelectList(((ESRIMapOLAPDataModel)map.getDataModel()).getLayerToFieldMap());
            String[] layerList = new String[selectList.length / 2];
            String[] valueList = new String[selectList.length / 2];
            for (int i = 0; i < selectList.length; i += 2) {
                layerList[i / 2] = selectList[i];
                valueList[i / 2] = selectList[i + 1];
            }
            this.filter(map, layerList, valueList);
            map.clearSelections(esriMap);
            map.setMode(0);
            map.setAutoZoom(true);
            esriMap.resetMapDescription();
            map.resetToMap(esriMap);
            map.setRedrawMap(true);
            this.eventSource = map.getDataModel();
            this.contentsChanged = true;
            this.eventInfo.clear();
            this.eventInfo.put("request", this.getAttribute("request"));
            this.eventInfo.put("response", this.getAttribute("response"));
            this.eventInfo.put("ROW_COLUMN", "INITIALIZE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            esriMap.disconnect();
            esriMap = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        if (this.filterEnabled) {
            return 0;
        }
        return 16;
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }

    private void filter(BaseESRIMapChart mapChart, String[] layerNames, String[] values) {
        HashMap map = new HashMap(layerNames.length);
        for (int i = 0; i < layerNames.length; ++i) {
            List<String> value = map.containsKey(layerNames[i]) ? (List)map.get(layerNames[i]) : new ArrayList<String>();
            value.add(values[i]);
            map.put(layerNames[i], value);
        }
        this.filter(mapChart, map);
    }

    private boolean filter(BaseESRIMapChart mapChart, Map layerUniqueNames) {
        block7: {
            ESRIMapTableDataModel dm;
            TableModel tm;
            if (mapChart instanceof OLAPESRIMapChart) {
                try {
                    MapOLAPUtil olapUtil = ((OLAPESRIMapChart)mapChart).getOLAPUtil();
                    OLAPDataSetInterface dsi = olapUtil.getDataModel();
                    if (dsi != null && dsi instanceof BusinessQueryProviderInterface) {
                        BusinessQuery businessQuery = ((BusinessQueryProviderInterface)dsi).getBusinessQuery();
                        for (String layerName : layerUniqueNames.keySet()) {
                            List l = (List)layerUniqueNames.get(layerName);
                            if (l.isEmpty()) continue;
                            String[] memberNames = olapUtil.getMemberNames(layerName, l);
                            String uniqueID = (String)l.get(0);
                            TupleElementInterface te = olapUtil.getTupleElement(layerName, uniqueID);
                            String levelName = te.getUniqueLevelName();
                            DataItem dataItem = BusinessQueryToOLAPDataSetAdapter.findDataItem((BusinessQuery)businessQuery, (OLAPDataSetInterface)dsi, (Object)levelName, (int)3);
                            DataItemMemberFilter step = new DataItemMemberFilter(memberNames, 0);
                            step.setActionType(0);
                            dataItem.addStep((StepInterface)step);
                        }
                        ((BusinessQueryProviderInterface)dsi).refreshBusinessQuery(businessQuery);
                        return true;
                    }
                    break block7;
                }
                catch (Exception oe) {
                    return false;
                }
            }
            if (mapChart instanceof ESRIMapChart && (tm = (dm = (ESRIMapTableDataModel)mapChart.getDataModel()).getModel()) instanceof BusinessQueryToTableModelAdapter) {
                BusinessQueryToTableModelAdapter query = (BusinessQueryToTableModelAdapter)tm;
                BusinessQuery bq = query.getBusinessQuery();
                for (String layerName : layerUniqueNames.keySet()) {
                    List l = (List)layerUniqueNames.get(layerName);
                    if (l.isEmpty()) continue;
                }
            }
        }
        return false;
    }

    public boolean isContentsChanged() {
        return this.contentsChanged;
    }

    public HashMap getEventInfo() {
        if (this.contentsChanged) {
            return this.eventInfo;
        }
        return null;
    }

    public Object getEventSource() {
        return this.eventSource;
    }

    public void setFilterEnabled(boolean b) {
        this.filterEnabled = b;
    }
}

