/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.ExpandCommand;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.graphics.map.ESRIMap;
import com.sas.iquery.intelligentquery.BusinessQueryProviderInterface;
import com.sas.servlet.tbeans.olapgraphics.html.MapOLAPUtil;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.TupleElementInterface;
import jakarta.servlet.http.HttpServletRequest;

public class MapExpandCommand
extends ExpandCommand {
    private int clickX;
    private int clickY;
    private Object mapViewer;

    public MapExpandCommand(String name) {
        super(name);
    }

    public MapExpandCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        OLAPESRIMapChart map = (OLAPESRIMapChart)this.getMapViewer();
        if (map == null) {
            return;
        }
        map.setRequest((HttpServletRequest)this.getAttribute("request"));
        ESRIMap esriMap = map.getESRIMap();
        try {
            this.setupParms(this.clickX, this.clickY, map, esriMap);
            super.execute(o);
            map.clearSelections(esriMap);
            map.setAutoZoom(true);
            map.setRedrawMap(true);
            map.setMode(7);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            esriMap.disconnect();
            esriMap = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        return super.getCommandStatus(filter);
    }

    private boolean setupParms(int x, int y, OLAPESRIMapChart map, ESRIMap myMap) {
        String[] layerAndField = null;
        try {
            layerAndField = myMap.selectLayerAndField(x, y, ((ESRIMapOLAPDataModel)map.getDataModel()).getLayerToFieldMap());
            if (layerAndField == null) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        MapOLAPUtil olapUtil = map.getOLAPUtil();
        String layer = layerAndField[0];
        String uniqueID = layerAndField[1];
        try {
            OLAPDataSetInterface dsi = olapUtil.getDataModel();
            if (dsi != null && dsi instanceof BusinessQueryProviderInterface) {
                TupleElementInterface te = olapUtil.getTupleElement(layer, uniqueID);
                if (te.getChildCount() <= 0) {
                    return false;
                }
                String levelName = te.getUniqueLevelName();
                super.setTupleElement(te);
                super.setUniqueLevelName(levelName);
                super.setModel(dsi);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }

    public int getClickX() {
        return this.clickX;
    }

    public void setClickX(int clickX) {
        this.clickX = clickX;
    }

    public int getClickY() {
        return this.clickY;
    }

    public void setClickY(int clickY) {
        this.clickY = clickY;
    }
}

