/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.commands.olap.DrillUpCommand;
import com.sas.entities.AttributeSetException;
import com.sas.graphics.components.esrimap.ESRIMapDataModel;
import com.sas.graphics.components.esrimap.ESRIMapOLAPDataModel;
import com.sas.graphics.map.ESRIMap;
import com.sas.servlet.tbeans.olapgraphics.html.MapOLAPUtil;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapChart;
import com.sas.servlet.tbeans.olapgraphics.html.OLAPESRIMapMenu;
import jakarta.servlet.http.HttpServletRequest;

public class MapDrillUpCommand
extends DrillUpCommand {
    private Object mapViewer;

    public MapDrillUpCommand(String name) {
        super(name);
    }

    public MapDrillUpCommand(String name, boolean swing) {
        super(name, swing);
    }

    public void execute(Object o) {
        OLAPESRIMapChart map = (OLAPESRIMapChart)this.getMapViewer();
        if (map == null) {
            return;
        }
        map.setRequest((HttpServletRequest)this.getAttribute("request"));
        ESRIMap esriMap = map.getESRIMap();
        this.setupDrillParms(map);
        super.execute(o);
        map.clearSelections(esriMap);
        map.setAutoZoom(true);
        map.setMode(0);
        map.setRedrawMap(true);
        try {
            esriMap.disconnect();
            esriMap = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        OLAPESRIMapChart map;
        OLAPESRIMapMenu mapMenu = (OLAPESRIMapMenu)filter.getViewer();
        if (mapMenu != null && (map = mapMenu.getMap()) != null) {
            this.setupDrillParms(map);
            try {
                ESRIMapDataModel dm;
                if (this.getUniqueLevelName() != null) {
                    filter.setAttribute("uniqueLevelName", (Object)this.getUniqueLevelName());
                }
                if ((dm = map.getDataModel()) != null) {
                    filter.setAttribute("model", (Object)((ESRIMapOLAPDataModel)dm).getModel());
                }
                this.setModel(((ESRIMapOLAPDataModel)dm).getModel());
            }
            catch (AttributeSetException e) {
                e.printStackTrace();
            }
        }
        return super.getCommandStatus(filter);
    }

    private void setupDrillParms(OLAPESRIMapChart map) {
        try {
            MapOLAPUtil olapUtil = map.getOLAPUtil();
            String[] levelNames = olapUtil.getLevelNames();
            String levelName = null;
            if (levelNames != null && levelNames.length > 0 && levelNames[0] != null) {
                levelName = levelNames[0];
            }
            super.setUniqueLevelName(levelName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }
}

