/*
 * Decompiled with CFR 0.152.
 */
package com.sas.actionprovider.commands;

import com.sas.actionprovider.ActionSupportFilter;
import com.sas.actionprovider.CommandStatusInterface;
import com.sas.actionprovider.commands.MapBaseCommand;
import com.sas.graphics.map.ESRIMap;
import com.sas.servlet.tbeans.graphics.BaseESRIMapChart;
import jakarta.servlet.http.HttpServletRequest;

public class MapClearSelectionsCommand
extends MapBaseCommand
implements CommandStatusInterface {
    private Object mapViewer;
    protected boolean filterEnabled = false;

    public MapClearSelectionsCommand(String name) {
        super(name);
    }

    @Override
    public void execute(Object o) {
        BaseESRIMapChart map = (BaseESRIMapChart)((Object)this.getMapViewer());
        if (map == null) {
            return;
        }
        map.setRequest((HttpServletRequest)this.getAttribute("request"));
        ESRIMap esriMap = map.getESRIMap();
        try {
            map.clearSelections(esriMap);
            map.setAutoZoom(false);
            map.setMode(9);
            esriMap.resetMapDescription();
            map.resetToMap(esriMap);
            map.setRedrawMap(true);
            this.contentsChanged = true;
            this.eventInfo.clear();
            this.eventInfo.put("ESRIMAP", "CLEARSELECTIONS");
            this.setEventSource((Object)map);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            esriMap.disconnect();
            esriMap = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSupported(ActionSupportFilter actionFilter) {
        return true;
    }

    public int getCommandStatus(ActionSupportFilter filter) {
        if (this.filterEnabled) {
            return 0;
        }
        return 16;
    }

    public Object getMapViewer() {
        return this.mapViewer;
    }

    public void setMapViewer(Object mapViewer) {
        this.mapViewer = mapViewer;
    }

    public void setFilterEnabled(boolean b) {
        this.filterEnabled = b;
    }
}

