/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import jakarta.activation.DataHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.axiom.om.OMText;
import org.apache.axiom.util.base64.Base64Utils;

public class TextHelper {
    public static String toString(InputStream inStream) throws IOException {
        StringBuffer buffer = new StringBuffer();
        TextHelper.toStringBuffer(inStream, buffer);
        return buffer.toString();
    }

    public static void toStringBuffer(InputStream inStream, StringBuffer buffer) throws IOException {
        int avail = inStream.available();
        if (avail > 0) {
            buffer.ensureCapacity((int)((double)avail * 1.35) + buffer.length());
        }
        byte[] data = new byte[1023];
        boolean eos = false;
        do {
            int read;
            int len = 0;
            do {
                if ((read = inStream.read(data, len, data.length - len)) != -1) continue;
                eos = true;
                break;
            } while ((len += read) < data.length);
            Base64Utils.encode((byte[])data, (int)0, (int)len, (StringBuffer)buffer);
        } while (!eos);
    }

    public static void toStringBuffer(OMText omText, StringBuffer buffer) throws IOException {
        InputStream is;
        DataHandler dh;
        if (omText.isOptimized() && (dh = omText.getDataHandler()) != null && (is = dh.getInputStream()) != null) {
            TextHelper.toStringBuffer(is, buffer);
            return;
        }
        buffer.append(omText.getText());
    }
}

