/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.BufferedWriter;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.axiom.attachments.impl.BufferUtils;
import org.apache.axiom.attachments.utils.BAAInputStream;
import org.apache.axiom.attachments.utils.BAAOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DetachableInputStream
extends FilterInputStream {
    private static final Log log = LogFactory.getLog(DetachableInputStream.class);
    private long count = 0L;
    BAAInputStream localStream = null;
    boolean isClosed = false;

    public DetachableInputStream(InputStream in) {
        super(in);
    }

    public long length() throws IOException {
        if (this.localStream == null) {
            this.detach();
        }
        return this.count;
    }

    public void detach() throws IOException {
        if (this.localStream == null && !this.isClosed) {
            BAAOutputStream baaos;
            block8: {
                baaos = new BAAOutputStream();
                try {
                    try {
                        BufferUtils.inputStream2OutputStream(this.in, baaos);
                        super.close();
                    }
                    catch (Throwable t) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("detach caught exception.  Processing continues:" + t));
                            log.debug((Object)("  " + DetachableInputStream.stackToString(t)));
                        }
                        this.in = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.in = null;
                    throw throwable;
                }
                this.in = null;
            }
            this.localStream = new BAAInputStream(baaos.buffers(), baaos.length());
            if (log.isDebugEnabled()) {
                log.debug((Object)("The local stream built from the detached stream has a length of:" + baaos.length()));
            }
            this.count += (long)baaos.length();
        }
    }

    @Override
    public int available() throws IOException {
        if (this.localStream != null) {
            return this.localStream.available();
        }
        return super.available();
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
        if (this.localStream != null) {
            this.localStream.close();
        } else {
            super.close();
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        if (this.localStream == null) {
            int rc = super.read();
            if (rc != -1) {
                ++this.count;
            }
            return rc;
        }
        return this.localStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.localStream == null) {
            int rc = super.read(b, off, len);
            if (rc > 0) {
                this.count += (long)rc;
            }
            return rc;
        }
        return this.localStream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.localStream == null) {
            int rc = super.read(b);
            if (rc > 0) {
                this.count += (long)rc;
            }
            return rc;
        }
        return this.localStream.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.localStream == null) {
            long rc = super.skip(n);
            if (rc > 0L) {
                this.count += rc;
            }
            return rc;
        }
        return this.localStream.skip(n);
    }

    private static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        return text;
    }
}

