/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime.impl.javamail;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.axiom.mime.Header;
import org.apache.axiom.mime.MultipartWriter;
import org.apache.axiom.util.blob.BlobDataSource;
import org.apache.axiom.util.blob.MemoryBlob;
import org.apache.axiom.util.blob.WritableBlob;

class MultipartWriterImpl
implements MultipartWriter {
    private static final byte[] DASH_DASH = new byte[]{45, 45};
    private static final byte[] CR_LF = new byte[]{13, 10};
    private final OutputStream out;
    private final byte[] boundary;

    public MultipartWriterImpl(OutputStream out, String boundary) {
        this.out = out;
        try {
            this.boundary = boundary.getBytes("ascii");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public OutputStream writePart(String contentType, String contentTransferEncoding, String contentID) throws IOException {
        return new PartOutputStream(contentType, contentTransferEncoding, contentID, null);
    }

    public OutputStream writePart(String contentType, String contentTransferEncoding, String contentID, List extraHeaders) throws IOException {
        return new PartOutputStream(contentType, contentTransferEncoding, contentID, extraHeaders);
    }

    public void writePart(DataHandler dataHandler, String contentTransferEncoding, String contentID, List extraHeaders) throws IOException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        try {
            mimeBodyPart.setDataHandler(dataHandler);
            mimeBodyPart.addHeader("Content-ID", "<" + contentID + ">");
            mimeBodyPart.addHeader("Content-Type", dataHandler.getContentType());
            mimeBodyPart.addHeader("Content-Transfer-Encoding", contentTransferEncoding);
            mimeBodyPart.addHeader("Content-Transfer-Encoding", contentTransferEncoding);
            if (extraHeaders != null) {
                for (Header header : extraHeaders) {
                    mimeBodyPart.addHeader(header.getName(), header.getValue());
                }
            }
        }
        catch (MessagingException ex) {
            IOException ex2 = new IOException("Unable to create MimeBodyPart");
            ex2.initCause(ex);
            throw ex2;
        }
        this.out.write(DASH_DASH);
        this.out.write(this.boundary);
        this.out.write(CR_LF);
        try {
            mimeBodyPart.writeTo(this.out);
        }
        catch (MessagingException ex) {
            IOException ex2 = new IOException("Unable to write the MimeBodyPart object");
            ex2.initCause(ex);
            throw ex2;
        }
        this.out.write(CR_LF);
    }

    @Override
    public void writePart(DataHandler dataHandler, String contentTransferEncoding, String contentID) throws IOException {
        this.writePart(dataHandler, contentTransferEncoding, contentID, (List)null);
    }

    @Override
    public void complete() throws IOException {
        this.out.write(DASH_DASH);
        this.out.write(this.boundary);
        this.out.write(DASH_DASH);
        this.out.write(CR_LF);
    }

    class PartOutputStream
    extends OutputStream {
        private final String contentType;
        private final String contentTransferEncoding;
        private final String contentID;
        private final WritableBlob blob;
        private final OutputStream parent;
        private final List extraHeaders;

        public PartOutputStream(String contentType, String contentTransferEncoding, String contentID, List extraHeaders) {
            this.contentType = contentType;
            this.contentTransferEncoding = contentTransferEncoding;
            this.contentID = contentID;
            this.extraHeaders = extraHeaders;
            this.blob = new MemoryBlob();
            this.parent = this.blob.getOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.parent.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.parent.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.parent.write(b);
        }

        @Override
        public void close() throws IOException {
            this.parent.close();
            MultipartWriterImpl.this.writePart(new DataHandler((DataSource)new BlobDataSource(this.blob, this.contentType)), this.contentTransferEncoding, this.contentID, this.extraHeaders);
        }
    }
}

