/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.utils;

import java.util.Arrays;

public class ByteSearch {
    public static int skipSearch(byte[] pattern, boolean direction, byte[] buffer, int start, int end, short[] skip) {
        int patternLength = pattern.length;
        if (patternLength > end - start) {
            return -1;
        }
        if (direction) {
            int k = 0;
            k = start + patternLength - 1;
            while (k < end) {
                if (ByteSearch.isEqual(pattern, buffer, k - patternLength + 1, end)) {
                    return k - patternLength + 1;
                }
                k += skip[buffer[k] & 0xFF];
            }
        } else {
            int k = end - patternLength;
            while (k <= start) {
                if (ByteSearch.isEqual(pattern, buffer, k, end)) {
                    return k;
                }
                k -= skip[buffer[k] & 0xFF];
            }
        }
        return -1;
    }

    public static short[] getSkipArray(byte[] pattern, boolean direction) {
        short[] skip = new short[256];
        Arrays.fill(skip, (short)pattern.length);
        if (direction) {
            int k = 0;
            while (k < pattern.length - 1) {
                skip[pattern[k] & 0xFF] = (short)(pattern.length - k - 1);
                ++k;
            }
        } else {
            int k = pattern.length - 2;
            while (k >= 0) {
                skip[pattern[k] & 0xFF] = (short)(pattern.length - k - 1);
                --k;
            }
        }
        return skip;
    }

    public static boolean isEqual(byte[] pattern, byte[] buffer, int start, int end) {
        if (pattern.length > end - start) {
            return false;
        }
        int j = 0;
        while (j < pattern.length) {
            if (pattern[j] != buffer[start + j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public static int search(byte[] search, byte[] bytes, int start, int end, boolean direction) {
        int idx = -1;
        if (search == null || search.length == 0 || bytes == null || bytes.length == 0 || start < 0 || end <= 0) {
            return idx;
        }
        if (direction) {
            int i = start;
            while (idx < 0 && i < end) {
                if (bytes[i] == search[0]) {
                    boolean found = true;
                    int i2 = 1;
                    while (found && i2 < search.length) {
                        found = i + i2 >= end ? false : bytes[i + i2] == search[i2];
                        ++i2;
                    }
                    if (found) {
                        idx = i;
                    }
                }
                ++i;
            }
        } else {
            int i = end - 1;
            while (idx < 0 && i >= start) {
                if (bytes[i] == search[0]) {
                    boolean found = true;
                    int i2 = 1;
                    while (found && i2 < search.length) {
                        found = i + i2 >= end ? false : bytes[i + i2] == search[i2];
                        ++i2;
                    }
                    if (found) {
                        idx = i;
                    }
                }
                --i;
            }
        }
        return idx;
    }
}

