/*
 * Decompiled with CFR 0.152.
 */
package MITI.BiBridgeLib;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.bridges.bridgelib.MIRTypeLib;
import MITI.messages.MIRBiBridgeLib.BILIB;
import MITI.sdk.MIRAllClasses;
import MITI.sdk.MIRClass;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRConcreteType;
import MITI.sdk.MIRConnection;
import MITI.sdk.MIRConnectionNamespace;
import MITI.sdk.MIRConnectionPackage;
import MITI.sdk.MIRContent;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRDataSet;
import MITI.sdk.MIRDatabaseSchema;
import MITI.sdk.MIRDate;
import MITI.sdk.MIRDerivedType;
import MITI.sdk.MIRDirectoryStructureModel;
import MITI.sdk.MIRElementType;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRFileDirectory;
import MITI.sdk.MIRFlatFileDescriptor;
import MITI.sdk.MIRFlatTextFile;
import MITI.sdk.MIRModel;
import MITI.sdk.MIRNamespace;
import MITI.sdk.MIRNamespaceElement;
import MITI.sdk.MIRObjectCollections;
import MITI.sdk.MIROlapSchema;
import MITI.sdk.MIRPackage;
import MITI.sdk.MIRStoreConnection;
import MITI.sdk.MIRStoreContent;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIRStoredProcedure;
import MITI.sdk.MIRType;
import MITI.sdk.mix.MIRMixManager;
import MITI.sdk.util.ObjectCollector;
import MITI.sdk.validation.MIRValidation;
import MITI.util.StringUtil;
import java.io.File;
import java.util.Iterator;
import java.util.TreeSet;

public class MIRBiSummarizer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(MIRDirectoryStructureModel mIRDirectoryStructureModel, MIRMixManager mIRMixManager) throws MIRException {
        boolean bl = MIRObjectCollections.__getSdkCaseSensitive();
        try {
            MIRObjectCollections.__setSdkCaseSensitive(true);
            BILIB.STS_BI_SUMMARIZER.log(new Object[0]);
            for (MIRStoreContent object : mIRDirectoryStructureModel.getConnectionStoreContents()) {
                BILIB.DBG_PROCESSING_CONNECTION_MODEL.log(object.getName(), object.getNativeId());
                this.processConnectionModel(object, mIRMixManager);
            }
            ObjectCollector objectCollector = new ObjectCollector(new short[]{159});
            mIRDirectoryStructureModel.depthTraversal(objectCollector);
            for (MIRContent mIRContent : objectCollector.getObjects()) {
                mIRContent.removeModel();
            }
            mIRMixManager.saveDirectoryStructure(mIRDirectoryStructureModel);
        }
        finally {
            MIRObjectCollections.__setSdkCaseSensitive(bl);
        }
    }

    private void processConnectionModel(MIRStoreContent mIRStoreContent, MIRMixManager mIRMixManager) throws MIRException {
        MIRModel mIRModel;
        MIRDate mIRDate = new MIRDate();
        TreeSet<String> treeSet = new TreeSet<String>();
        boolean bl = false;
        File file = mIRMixManager.getFile(mIRStoreContent);
        if (file == null || !file.exists()) {
            BILIB.ERR_CONNECTION_MODEL_MISSING_FILE.log(mIRStoreContent.getName(), mIRStoreContent.getNativeId());
        }
        if ((mIRModel = mIRMixManager.loadModel(mIRStoreContent)) != null && mIRModel.getElementType() == 2) {
            for (MIRConnection mIRConnection : mIRStoreContent.getSupplierOfConnections()) {
                MIRModel mIRModel2 = mIRMixManager.loadModel(mIRConnection.getClientContent());
                if (mIRModel2 == null) continue;
                String string = mIRConnection.getName();
                MIRStoreConnection mIRStoreConnection = mIRModel2.getStoreConnection(string);
                if (mIRStoreConnection != null) {
                    if (mIRConnection.getClientContent().getLastModificationTime().compareTo(mIRDate) > 0) {
                        mIRDate = mIRConnection.getClientContent().getLastModificationTime();
                    }
                    treeSet.add(mIRConnection.getClientContent().getModelKey());
                    this.mergeModels((MIRStoreModel)mIRModel, mIRStoreConnection);
                    bl = true;
                }
                mIRModel2.delete();
            }
            if (bl) {
                mIRModel.setDesignLevel((byte)2);
                if (mIRModel.getNativeType().isEmpty()) {
                    mIRModel.setNativeType(mIRStoreContent.getNativeType());
                }
                if (mIRModel.getSystemType().isEmpty()) {
                    BILIB.WRN_SYSTEM_TYPE.log(MIRValidation.buildValidationName(mIRModel), "ODBC");
                    mIRModel.setSystemType("ODBC");
                }
                MIRTypeLib.factorizeTypes(mIRModel, false, true);
                mIRStoreContent.setLastModificationTime(mIRDate);
                mIRStoreContent.setModelKey(StringUtil.join(treeSet, ""));
                mIRMixManager.saveModel(mIRStoreContent);
            }
            mIRModel.delete();
        }
    }

    private void mergeModels(MIRStoreModel mIRStoreModel, MIRStoreConnection mIRStoreConnection) {
        MIRDataPackage mIRDataPackage;
        String string;
        if (mIRStoreModel.getStoreType() != mIRStoreConnection.getStoreType()) {
            if (mIRStoreModel.getDataPackageCount() == 0) {
                mIRStoreModel.setStoreType(mIRStoreConnection.getStoreType());
                BILIB.WRN_STORE_TYPE.log(MIRValidation.buildValidationName(mIRStoreModel), MIRValidation.buildValidationName(mIRStoreConnection));
            } else {
                BILIB.ERR_STORE_TYPE.log(MIRValidation.buildValidationName(mIRStoreModel), MIRValidation.buildValidationName(mIRStoreConnection));
                return;
            }
        }
        if (mIRStoreModel.getSystemType().isEmpty()) {
            mIRStoreModel.setSystemType(mIRStoreConnection.getSystemType());
            mIRStoreModel.setSystemMajorVersion(mIRStoreConnection.getSystemMajorVersion());
            mIRStoreModel.setSystemMinorVersion(mIRStoreConnection.getSystemMinorVersion());
            mIRStoreModel.setSystemReleaseVersion(mIRStoreConnection.getSystemReleaseVersion());
        }
        for (MIRConnectionPackage mIRConnectionDataPackage : mIRStoreConnection.getConnectionPackages()) {
            string = mIRConnectionDataPackage.getNamespaceName(mIRConnectionDataPackage);
            mIRDataPackage = this.getDataPackage(mIRStoreModel, string);
            this.mergePackages(mIRDataPackage, mIRConnectionDataPackage);
        }
        for (MIRConnectionNamespace mIRConnectionNamespace : mIRStoreConnection.getConnectionNamespaces()) {
            string = MIRBridgeLib.getPhysicalName(mIRConnectionNamespace);
            mIRDataPackage = this.getDirectory(mIRStoreModel, string);
            this.mergeConnectionNamespace((MIRFileDirectory)mIRDataPackage, mIRConnectionNamespace);
        }
    }

    private MIRFileDirectory getDirectory(MIRStoreModel mIRStoreModel, String string) {
        MIRFileDirectory mIRFileDirectory = null;
        Iterator<MIRDataPackage> iterator = mIRStoreModel.getDataPackageIterator();
        while (iterator.hasNext()) {
            MIRDataPackage mIRDataPackage = iterator.next();
            if (!mIRDataPackage.isInstanceOf((short)207) || !string.equals(MIRBridgeLib.getPhysicalName(mIRDataPackage))) continue;
            mIRFileDirectory = (MIRFileDirectory)mIRDataPackage;
            break;
        }
        if (mIRFileDirectory == null) {
            mIRFileDirectory = new MIRFileDirectory();
            mIRFileDirectory.setName(string);
            if ("Fake Root".equals(string)) {
                mIRFileDirectory.setNativeType(string);
            }
            mIRStoreModel.addDataPackage(mIRFileDirectory);
        }
        return mIRFileDirectory;
    }

    private MIRNamespaceElement getNamespaceElement(MIRFileDirectory mIRFileDirectory, String string) {
        MIRNamespaceElement mIRNamespaceElement = null;
        Iterator<MIRNamespaceElement> iterator = mIRFileDirectory.getAllNamespaceElementIterator();
        while (iterator.hasNext()) {
            MIRNamespaceElement mIRNamespaceElement2 = iterator.next();
            if (!string.equals(MIRBridgeLib.getPhysicalName(mIRNamespaceElement2))) continue;
            mIRNamespaceElement = mIRNamespaceElement2;
            break;
        }
        return mIRNamespaceElement;
    }

    private MIRFileDirectory getDirectory(MIRFileDirectory mIRFileDirectory, String string, String string2) {
        MIRFileDirectory mIRFileDirectory2 = null;
        MIRNamespaceElement mIRNamespaceElement = this.getNamespaceElement(mIRFileDirectory, string);
        if (mIRNamespaceElement != null) {
            if (mIRNamespaceElement.isInstanceOf((short)207)) {
                mIRFileDirectory2 = (MIRFileDirectory)mIRNamespaceElement;
            } else {
                String string3 = MIRElementType.getName(mIRFileDirectory.getElementType());
                String string4 = MIRBridgeLib.getPhysicalName(mIRFileDirectory);
                String string5 = MIRElementType.getName(mIRNamespaceElement.getElementType());
                String string6 = MIRElementType.getName((short)207);
                BILIB.ERR_NAMESPACE_ELEMENT_CONFLICT.log(string3, string4, string5, string, string6, string);
                return null;
            }
        }
        if (mIRFileDirectory2 == null) {
            mIRFileDirectory2 = new MIRFileDirectory();
            mIRFileDirectory2.setName(string);
            mIRFileDirectory2.setNativeType(string2);
            mIRFileDirectory.addNamespaceElement(mIRFileDirectory2);
        }
        return mIRFileDirectory2;
    }

    private void mergeConnectionNamespace(MIRFileDirectory mIRFileDirectory, MIRConnectionNamespace mIRConnectionNamespace) {
        Iterator<MIRNamespaceElement> iterator = mIRConnectionNamespace.getAllNamespaceElementIterator();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            MIRNamespaceElement mIRNamespaceElement = iterator.next();
            if (mIRNamespaceElement.isInstanceOf((short)321)) {
                object2 = MIRBridgeLib.getPhysicalName(mIRNamespaceElement);
                MIRFileDirectory mIRFileDirectory2 = this.getDirectory(mIRFileDirectory, (String)object2, (String)(object = mIRNamespaceElement.getNativeType()));
                if (mIRFileDirectory2 == null) continue;
                this.mergeConnectionNamespace(mIRFileDirectory2, (MIRConnectionNamespace)mIRNamespaceElement);
                continue;
            }
            if (!mIRNamespaceElement.isInstanceOf((short)75) || (object = this.getClassifier(mIRFileDirectory, (MIRClassifier)(object2 = (MIRClassifier)mIRNamespaceElement))) == null) continue;
            this.mergeClassifiers((MIRClassifier)object, (MIRClassifier)object2);
            if (this.hasLineage((MIRClassifier)object2)) continue;
            ((MIRClassifier)object).setLineageOption(1);
        }
    }

    private void mergePackages(MIRPackage mIRPackage, MIRConnectionPackage mIRConnectionPackage) {
        MIRNamespaceElement mIRNamespaceElement;
        MIRNamespaceElement mIRNamespaceElement2;
        for (MIRNamespaceElement mIRNamespaceElement3 : mIRConnectionPackage.getNamespaceElements()) {
            if (mIRNamespaceElement3.isInstanceOf((short)75)) {
                mIRNamespaceElement2 = (MIRClassifier)mIRNamespaceElement3;
                mIRNamespaceElement = this.getClassifier(mIRPackage, (MIRClassifier)mIRNamespaceElement2);
                if (mIRNamespaceElement == null) continue;
                this.mergeClassifiers((MIRClassifier)mIRNamespaceElement, (MIRClassifier)mIRNamespaceElement2);
                if (this.hasLineage((MIRClassifier)mIRNamespaceElement2)) continue;
                ((MIRClassifier)mIRNamespaceElement).setLineageOption(1);
                continue;
            }
            if (mIRNamespaceElement3.isInstanceOf((short)215)) {
                mIRNamespaceElement2 = (MIRConnectionPackage)mIRNamespaceElement3;
                mIRNamespaceElement = this.getPackage(mIRPackage, (MIRConnectionPackage)mIRNamespaceElement2);
                this.mergePackages((MIRPackage)mIRNamespaceElement, (MIRConnectionPackage)mIRNamespaceElement2);
                continue;
            }
            if (!mIRNamespaceElement3.isInstanceOf((short)67)) continue;
            this.mergeStoredProcedure(mIRPackage, (MIRStoredProcedure)mIRNamespaceElement3);
        }
        for (MIRNamespaceElement mIRNamespaceElement3 : mIRConnectionPackage.getImportedNamespaceElements()) {
            if (!mIRNamespaceElement3.isInstanceOf((short)75) || (mIRNamespaceElement = this.getClassifier(mIRPackage, (MIRClassifier)(mIRNamespaceElement2 = (MIRClassifier)mIRNamespaceElement3))) == null) continue;
            this.mergeClassifiers((MIRClassifier)mIRNamespaceElement, (MIRClassifier)mIRNamespaceElement2);
            if (this.hasLineage((MIRClassifier)mIRNamespaceElement2)) continue;
            ((MIRClassifier)mIRNamespaceElement).setLineageOption(1);
        }
        if (mIRPackage.getNamespaceElementCount() == 0) {
            mIRPackage.delete();
        }
    }

    private void mergeStoredProcedure(MIRPackage mIRPackage, MIRStoredProcedure mIRStoredProcedure) {
        MIRStoredProcedure mIRStoredProcedure2 = null;
        MIRNamespaceElement mIRNamespaceElement = mIRPackage.getNamespaceElement(MIRBridgeLib.getPhysicalName(mIRStoredProcedure));
        if (mIRNamespaceElement == null) {
            mIRStoredProcedure2 = new MIRStoredProcedure(mIRStoredProcedure);
            mIRPackage.addNamespaceElement(mIRStoredProcedure2);
        } else if (mIRNamespaceElement.isInstanceOf((short)67)) {
            mIRStoredProcedure2 = (MIRStoredProcedure)mIRNamespaceElement;
        }
        if (mIRStoredProcedure2 != null) {
            MIRDataSet mIRDataSet;
            MIRDataSet mIRDataSet2 = mIRStoredProcedure.getResultDataSet();
            if (mIRDataSet2 != null) {
                mIRDataSet = mIRStoredProcedure2.getResultDataSet();
                if (mIRDataSet == null) {
                    mIRDataSet = new MIRDataSet(mIRDataSet2);
                    mIRStoredProcedure2.addResultDataSet(mIRDataSet);
                }
                this.mergeClassifiers(mIRDataSet, mIRDataSet2);
            }
            if ((mIRDataSet = mIRStoredProcedure.getParametersDataSet()) != null) {
                MIRDataSet mIRDataSet3 = mIRStoredProcedure2.getParametersDataSet();
                if (mIRDataSet3 == null) {
                    mIRDataSet3 = new MIRDataSet(mIRDataSet);
                    mIRStoredProcedure2.addParametersDataSet(mIRDataSet3);
                }
                this.mergeClassifiers(mIRDataSet3, mIRDataSet);
            }
        }
    }

    private void mergeClassifiers(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2) {
        boolean bl = false;
        if (mIRClassifier.isInstanceOf((short)209)) {
            bl = true;
        }
        for (MIRFeature mIRFeature : mIRClassifier2.getFeatures()) {
            MIRFeature mIRFeature2 = this.getFeature(mIRClassifier, mIRFeature, bl);
            this.mergeFeatures(mIRFeature2, mIRFeature);
            if (this.hasLineage(mIRFeature)) continue;
            mIRFeature2.setLineageOption(1);
        }
        if (mIRClassifier.getFeatureCount() == 0) {
            mIRClassifier.setLineageOption(1);
        }
    }

    private void mergeFeatures(MIRFeature mIRFeature, MIRFeature mIRFeature2) {
        MIRType mIRType = mIRFeature2.getType();
        if (mIRType == null) {
            if (mIRFeature.getType() == null) {
                mIRFeature.addType(MIRTypeLib.getUndefinedBaseType(mIRFeature.getRootModel()));
            }
            return;
        }
        MIRType mIRType2 = this.getType(mIRFeature, mIRType);
        if (mIRType.getElementType() == 5 && mIRType2.getElementType() == 5) {
            this.mergeDerivedTypes((MIRDerivedType)mIRType2, (MIRDerivedType)mIRType);
        }
    }

    private void mergeDerivedTypes(MIRDerivedType mIRDerivedType, MIRDerivedType mIRDerivedType2) {
        MIRConcreteType mIRConcreteType = mIRDerivedType2.getDerivedFromConcreteType();
        MIRType mIRType = this.getType(mIRDerivedType, mIRConcreteType);
        if (mIRConcreteType.getElementType() == 5 && mIRType.getElementType() == 5) {
            this.mergeDerivedTypes((MIRDerivedType)mIRType, (MIRDerivedType)mIRConcreteType);
        }
    }

    private MIRDataPackage getDataPackage(MIRStoreModel mIRStoreModel, String string) {
        MIRDataPackage mIRDataPackage = mIRStoreModel.getDataPackage(string);
        if (mIRDataPackage == null) {
            switch (mIRStoreModel.getStoreType()) {
                case 2: {
                    mIRDataPackage = new MIRFileDirectory();
                    break;
                }
                case 1: {
                    mIRDataPackage = new MIROlapSchema();
                    break;
                }
                default: {
                    mIRDataPackage = new MIRDatabaseSchema();
                }
            }
            mIRDataPackage.setName(string);
            mIRStoreModel.addDataPackage(mIRDataPackage);
        }
        return mIRDataPackage;
    }

    private MIRPackage getPackage(MIRPackage mIRPackage, MIRConnectionPackage mIRConnectionPackage) {
        String string = mIRConnectionPackage.getNamespaceName(mIRConnectionPackage);
        MIRPackage mIRPackage2 = (MIRPackage)mIRPackage.getNamespaceElement(string);
        if (mIRPackage2 == null) {
            mIRPackage2 = (MIRPackage)MIRAllClasses.createMIRObject(mIRPackage.getElementType());
            mIRPackage2.setName(string);
            mIRPackage.addNamespaceElement(mIRPackage2);
        }
        return mIRPackage2;
    }

    private MIRClassifier getClassifier(MIRNamespace mIRNamespace, MIRClassifier mIRClassifier) {
        Object object;
        Object object2;
        String string = mIRClassifier.getNamespaceName(mIRNamespace);
        MIRNamespaceElement mIRNamespaceElement = mIRNamespace.getNamespaceElement(string);
        MIRClassifier mIRClassifier2 = null;
        if (mIRNamespaceElement != null) {
            if (mIRNamespaceElement.isInstanceOf((short)75)) {
                mIRClassifier2 = (MIRClassifier)mIRNamespaceElement;
            } else if (mIRNamespaceElement.isInstanceOf((short)207)) {
                String string2 = MIRElementType.getName(mIRNamespace.getElementType());
                object2 = MIRBridgeLib.getPhysicalName(mIRNamespace);
                object = MIRElementType.getName(mIRNamespaceElement.getElementType());
                BILIB.ERR_NAMESPACE_ELEMENT_CONFLICT_DELETE.log(string2, object2, object, string);
                mIRNamespaceElement.delete();
            } else {
                String string3 = MIRElementType.getName(mIRNamespace.getElementType());
                String string4 = MIRBridgeLib.getPhysicalName(mIRNamespace);
                String string5 = MIRElementType.getName(mIRNamespaceElement.getElementType());
                String string6 = MIRElementType.getName(mIRClassifier.getElementType());
                BILIB.ERR_NAMESPACE_ELEMENT_CONFLICT.log(string3, string4, string5, string, string6, string);
                return null;
            }
        }
        if (mIRClassifier2 == null) {
            short s = mIRClassifier.getElementType() == 254 ? (short)13 : (short)mIRClassifier.getElementType();
            mIRClassifier2 = (MIRClassifier)MIRAllClasses.createMIRObject(s);
            mIRClassifier2.setName(string);
            mIRClassifier2.setNativeType(mIRClassifier.getNativeType());
            if (mIRClassifier2.isInstanceOf((short)209)) {
                object2 = (MIRFlatTextFile)mIRClassifier;
                if (((MIRFlatTextFile)object2).getFlatFileDescriptor() != null) {
                    object = (MIRFlatFileDescriptor)MIRAllClasses.createMIRObject(((MIRFlatTextFile)object2).getFlatFileDescriptor().getElementType());
                    ((MIRFlatFileDescriptor)object).setFrom(((MIRFlatTextFile)object2).getFlatFileDescriptor());
                    ((MIRFlatTextFile)mIRClassifier2).addFlatFileDescriptor((MIRFlatFileDescriptor)object);
                }
            } else if (mIRClassifier2.isInstanceOf((short)13) && mIRClassifier.isInstanceOf((short)13)) {
                ((MIRClass)mIRClassifier2).setCppClassType(((MIRClass)mIRClassifier).getCppClassType());
            }
            mIRClassifier2.setLineageOption(mIRClassifier.getLineageOptions());
            mIRNamespace.addNamespaceElement(mIRClassifier2);
        }
        return mIRClassifier2;
    }

    private MIRFeature getFeature(MIRClassifier mIRClassifier, MIRFeature mIRFeature, boolean bl) {
        String string = mIRFeature.getName();
        MIRFeature mIRFeature2 = null;
        mIRFeature2 = bl ? this.getFeatureByPosition(mIRClassifier, mIRFeature.getPosition()) : mIRClassifier.getFeature(string);
        if (mIRFeature2 == null) {
            short s;
            switch (mIRClassifier.getElementType()) {
                case 25: {
                    s = 26;
                    break;
                }
                case 13: 
                case 209: {
                    s = 14;
                    break;
                }
                default: {
                    s = mIRFeature.getElementType();
                }
            }
            mIRFeature2 = (MIRFeature)MIRAllClasses.createMIRObject(s);
            mIRFeature2.setName(string);
            mIRFeature2.setPhysicalName(mIRFeature.getPhysicalName());
            mIRFeature2.setPosition(mIRFeature.getPosition());
            mIRFeature2.setLineageOption(mIRFeature.getLineageOptions());
            mIRClassifier.addFeatureUniqueName(mIRFeature2);
        }
        return mIRFeature2;
    }

    private MIRFeature getFeatureByPosition(MIRClassifier mIRClassifier, short s) {
        for (MIRFeature mIRFeature : mIRClassifier.getFeatures()) {
            if (mIRFeature.getPosition() != s) continue;
            return mIRFeature;
        }
        return null;
    }

    private MIRType getType(MIRFeature mIRFeature, MIRType mIRType) {
        MIRType mIRType2 = mIRFeature.getType();
        if (mIRType2 == null) {
            mIRType2 = (MIRType)MIRAllClasses.createMIRObject(mIRType.getElementType());
            mIRType2.setFrom(mIRType);
            mIRType2.setNativeId("");
            mIRFeature.addType(mIRType2);
            mIRFeature.getRootModel().addType(mIRType2);
        }
        return mIRType2;
    }

    private MIRType getType(MIRDerivedType mIRDerivedType, MIRConcreteType mIRConcreteType) {
        MIRConcreteType mIRConcreteType2 = mIRDerivedType.getDerivedFromConcreteType();
        if (mIRConcreteType2 == null) {
            mIRConcreteType2 = (MIRConcreteType)MIRAllClasses.createMIRObject(mIRConcreteType.getElementType());
            mIRConcreteType2.setFrom(mIRConcreteType);
            mIRConcreteType2.setNativeId("");
            mIRDerivedType.addDerivedFromConcreteType(mIRConcreteType2);
            mIRDerivedType.getRootModel().addType(mIRConcreteType2);
        }
        return mIRConcreteType2;
    }

    private boolean hasLineage(MIRClassifier mIRClassifier) {
        if (mIRClassifier.getControlOfClassifierMapCount() > 0) {
            return true;
        }
        if (mIRClassifier.getSourceOfClassifierMapCount() > 0) {
            for (MIRClassifierMap mIRClassifierMap : mIRClassifier.getSourceOfClassifierMaps()) {
                MIRClassifier mIRClassifier2 = mIRClassifierMap.getDestinationClassifier();
                if (mIRClassifier2 == null) continue;
                if (mIRClassifier2.getElementType() == 101) {
                    if (!this.hasLineage(mIRClassifier2)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean hasLineage(MIRFeature mIRFeature) {
        if (mIRFeature.getControlOfFeatureMapCount() > 0) {
            return true;
        }
        if (mIRFeature.getSourceOfFeatureMapCount() > 0) {
            for (MIRFeatureMap mIRFeatureMap : mIRFeature.getSourceOfFeatureMaps()) {
                MIRFeature mIRFeature2 = mIRFeatureMap.getDestinationFeature();
                if (mIRFeature2 == null) continue;
                if (mIRFeature2.getElementType() == 102) {
                    if (!this.hasLineage(mIRFeature2)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }
}

