/*
 * Decompiled with CFR 0.152.
 */
package MITI.BiBridgeLib;

import MITI.MIRException;
import MITI.bridges.bridgelib.MIRBridgeLib;
import MITI.expression.util.Util;
import MITI.sdk.MIRClassifier;
import MITI.sdk.MIRClassifierMap;
import MITI.sdk.MIRCondition;
import MITI.sdk.MIRDataPackage;
import MITI.sdk.MIRElement;
import MITI.sdk.MIRElementNamePart;
import MITI.sdk.MIRElementNode;
import MITI.sdk.MIRExpression;
import MITI.sdk.MIRExpressionNode;
import MITI.sdk.MIRFeature;
import MITI.sdk.MIRFeatureMap;
import MITI.sdk.MIRJoin;
import MITI.sdk.MIRJoinCondition;
import MITI.sdk.MIRJoinRelationship;
import MITI.sdk.MIRJoinRole;
import MITI.sdk.MIROperatorNode;
import MITI.sdk.MIRStatementNode;
import MITI.sdk.MIRStoreModel;
import MITI.sdk.MIR_Object;
import MITI.sdk.util.ObjectCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;

public class JoinProcessor {
    private MIRStoreModel model;

    public JoinProcessor(MIRStoreModel mIRStoreModel) {
        this.model = mIRStoreModel;
    }

    public void run() throws MIRException {
        ObjectCollector objectCollector = new ObjectCollector(new short[]{92});
        this.model.depthTraversal(objectCollector);
        for (MIRJoin mIRJoin : objectCollector.getObjects()) {
            this.processJoin(mIRJoin);
        }
    }

    private MIRCondition getCondition(MIRJoin mIRJoin) {
        int n = mIRJoin.getFeatureCount();
        if (n != 1) {
            return null;
        }
        Iterator<MIRFeature> iterator = mIRJoin.getFeatureIterator();
        while (iterator.hasNext()) {
            MIRFeature mIRFeature = iterator.next();
            if (!(mIRFeature instanceof MIRCondition)) continue;
            return (MIRCondition)mIRFeature;
        }
        return null;
    }

    private void processJoin(MIRJoin mIRJoin) throws MIRException {
        block16: {
            Object object;
            Object object2;
            MIRJoinRole mIRJoinRole = MIRBridgeLib.getLeftJoinRole(mIRJoin);
            MIRJoinRole mIRJoinRole2 = MIRBridgeLib.getRightJoinRole(mIRJoin);
            if (mIRJoinRole == null || mIRJoinRole2 == null) {
                return;
            }
            MIRClassifier mIRClassifier = mIRJoinRole.getClassifier();
            MIRClassifier mIRClassifier2 = mIRJoinRole2.getClassifier();
            if (mIRClassifier == null || mIRClassifier2 == null) {
                return;
            }
            MIRClassifier mIRClassifier3 = this.getConnectionClassifier(mIRClassifier);
            MIRClassifier mIRClassifier4 = this.getConnectionClassifier(mIRClassifier2);
            if (mIRClassifier3 == null || mIRClassifier4 == null) {
                return;
            }
            MIRCondition mIRCondition = this.getCondition(mIRJoin);
            if (mIRCondition == null) {
                return;
            }
            MIRFeatureMap mIRFeatureMap = MIRBridgeLib.getDestinationOfFeatureMap(mIRCondition, false);
            if (mIRFeatureMap == null) {
                return;
            }
            String string = mIRFeatureMap.getOperation();
            MIRExpression mIRExpression = mIRFeatureMap.getExpression();
            if (mIRExpression == null) {
                return;
            }
            ArrayList<MIROperatorNode> arrayList = new ArrayList<MIROperatorNode>();
            for (MIRStatementNode object32 : mIRExpression.getStatementNodes()) {
                int iterator = object32.getStatementType();
                if (iterator != 0) continue;
                for (MIRExpressionNode mIRExpressionNode : object32.getExpressionNodes()) {
                    if (!(mIRExpressionNode instanceof MIROperatorNode)) continue;
                    object2 = (MIROperatorNode)mIRExpressionNode;
                    this.collectBooleanOperatorNodes((MIRExpressionNode)object2, arrayList);
                }
            }
            ArrayList arrayList2 = new ArrayList();
            for (MIROperatorNode mIROperatorNode : arrayList) {
                object = this.collectFeatures(mIROperatorNode.getLeftExpressionNode());
                List<MIRFeature> list = this.collectFeatures(mIROperatorNode.getRightExpressionNode());
                object = this.getConnectionFeatures((Collection<MIRFeature>)object);
                List<MIRFeature> list2 = this.getConnectionFeatures(list);
                object2 = object.iterator();
                while (object2.hasNext()) {
                    MIRFeature mIRFeature = (MIRFeature)object2.next();
                    for (MIRFeature mIRFeature2 : list2) {
                        if (mIRClassifier3.containsFeature(mIRFeature) && mIRClassifier4.containsFeature(mIRFeature2)) {
                            this.createJoinCondition(mIRFeature, mIRFeature2, arrayList2);
                            continue;
                        }
                        if (!mIRClassifier3.containsFeature(mIRFeature2) || !mIRClassifier4.containsFeature(mIRFeature)) continue;
                        this.createJoinCondition(mIRFeature2, mIRFeature, arrayList2);
                    }
                }
            }
            if (arrayList2.isEmpty()) break block16;
            MIRJoinRelationship mIRJoinRelationship = this.lookupExistingJoinRelationship(mIRClassifier3, mIRClassifier4, string);
            if (mIRJoinRelationship == null) {
                MIRJoinRelationship mIRJoinRelationship2 = new MIRJoinRelationship();
                mIRJoinRelationship2.setType(this.getJoinType(mIRJoin));
                mIRJoinRelationship2.setCondition(string);
                mIRJoinRelationship2.addLeftClassifier(mIRClassifier3);
                mIRJoinRelationship2.addRightClassifier(mIRClassifier4);
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    object = (MIRJoinCondition)iterator.next();
                    mIRJoinRelationship2.addJoinCondition((MIRJoinCondition)object);
                }
            } else {
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    object = (MIRJoinCondition)iterator.next();
                    ((MIR_Object)object).delete();
                }
            }
        }
    }

    private MIRJoinRelationship lookupExistingJoinRelationship(MIRClassifier mIRClassifier, MIRClassifier mIRClassifier2, String string) {
        for (MIRJoinRelationship mIRJoinRelationship : mIRClassifier.getLeftOfJoinRelationships()) {
            if (mIRJoinRelationship.getRightClassifier() != mIRClassifier2 || !mIRJoinRelationship.getCondition().equals(string)) continue;
            return mIRJoinRelationship;
        }
        return null;
    }

    private void createJoinCondition(MIRFeature mIRFeature, MIRFeature mIRFeature2, List<MIRJoinCondition> list) {
        MIRJoinCondition mIRJoinCondition = null;
        for (MIRJoinCondition mIRJoinCondition2 : list) {
            if (mIRJoinCondition2.getLeftFeature() != mIRFeature || mIRJoinCondition2.getRightFeature() != mIRFeature2) continue;
            mIRJoinCondition = mIRJoinCondition2;
            break;
        }
        if (mIRJoinCondition == null) {
            mIRJoinCondition = new MIRJoinCondition();
            mIRJoinCondition.addLeftFeature(mIRFeature);
            mIRJoinCondition.addRightFeature(mIRFeature2);
            list.add(mIRJoinCondition);
        }
    }

    private byte getJoinType(MIRJoin mIRJoin) {
        switch (mIRJoin.getType()) {
            case 0: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 1;
            }
            case 4: {
                return 4;
            }
        }
        return 0;
    }

    private List<MIRFeature> collectFeatures(MIRExpressionNode mIRExpressionNode) throws MIRException {
        ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
        if (mIRExpressionNode != null) {
            ObjectCollector objectCollector = new ObjectCollector(new short[]{111});
            mIRExpressionNode.depthTraversal(objectCollector);
            for (MIRElementNode mIRElementNode : objectCollector.getObjects()) {
                for (MIRElementNamePart mIRElementNamePart : mIRElementNode.getElementNameParts()) {
                    for (MIRElement mIRElement : mIRElementNamePart.getReferencedElements()) {
                        if (!(mIRElement instanceof MIRFeature)) continue;
                        arrayList.add((MIRFeature)mIRElement);
                    }
                }
            }
        }
        return arrayList;
    }

    private List<MIRFeature> getConnectionFeatures(Collection<MIRFeature> collection) {
        ArrayList<MIRFeature> arrayList = new ArrayList<MIRFeature>();
        for (MIRFeature mIRFeature : collection) {
            MIRClassifier mIRClassifier = mIRFeature.getClassifier();
            if (this.isConnectionClassifier(mIRClassifier)) {
                arrayList.add(mIRFeature);
                continue;
            }
            MIRFeatureMap mIRFeatureMap = MIRBridgeLib.getDestinationOfFeatureMap(mIRFeature, false);
            if (mIRFeatureMap == null || !Util.isSimpleExpression(mIRFeatureMap)) continue;
            arrayList.addAll(this.getConnectionFeatures(mIRFeatureMap.getSourceFeatures()));
        }
        return arrayList;
    }

    private boolean isConnectionClassifier(MIRClassifier mIRClassifier) {
        MIRDataPackage mIRDataPackage = mIRClassifier.getDataPackage();
        return mIRDataPackage != null;
    }

    private MIRClassifier getConnectionClassifier(MIRClassifier mIRClassifier) {
        SortedSet<MIRClassifier> sortedSet;
        if (this.isConnectionClassifier(mIRClassifier)) {
            return mIRClassifier;
        }
        MIRClassifierMap mIRClassifierMap = MIRBridgeLib.getDestinationOfClassifierMap(mIRClassifier, false);
        if (mIRClassifierMap != null && Util.isSimpleExpression(mIRClassifierMap) && (sortedSet = mIRClassifierMap.getSourceClassifiers()).size() == 1) {
            MIRClassifier mIRClassifier2 = (MIRClassifier)sortedSet.iterator().next();
            return this.getConnectionClassifier(mIRClassifier2);
        }
        return null;
    }

    private void collectBooleanOperatorNodes(MIRExpressionNode mIRExpressionNode, List<MIROperatorNode> list) {
        if (mIRExpressionNode instanceof MIROperatorNode) {
            MIROperatorNode mIROperatorNode = (MIROperatorNode)mIRExpressionNode;
            String string = mIROperatorNode.getName();
            MIRExpressionNode mIRExpressionNode2 = mIROperatorNode.getLeftExpressionNode();
            MIRExpressionNode mIRExpressionNode3 = mIROperatorNode.getRightExpressionNode();
            if (string.equals("AND")) {
                this.collectBooleanOperatorNodes(mIRExpressionNode2, list);
                this.collectBooleanOperatorNodes(mIRExpressionNode3, list);
            } else {
                list.add(mIROperatorNode);
            }
        }
    }
}

