/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.servlet.tbeans.tableview;

import com.sas.servlet.tbeans.tableview.html.DefaultTableRowRenderer;
import com.sas.taglib.BaseTag;
import jakarta.servlet.jsp.JspException;

public class BaseRowTag
extends BaseTag {
    private String bgColor;
    private String customAttributes;
    private String horizontalAlignment;
    private String styleClassPrefix;
    private String verticalAlignment;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.bgColor = null;
            this.customAttributes = null;
            this.horizontalAlignment = null;
            this.styleClassPrefix = null;
            this.verticalAlignment = null;
        }
    }

    public void setBgColor(String color) {
        this.bgColor = color;
    }

    public String getBgColor() {
        return this.bgColor;
    }

    public void setHorizontalAlignment(String horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public String getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setStyleClassPrefix(String styleClassPrefix) {
        this.styleClassPrefix = styleClassPrefix;
    }

    public String getStyleClassPrefix() {
        return this.styleClassPrefix;
    }

    public void setVerticalAlignment(String verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public String getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setCustomAttributes(String customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String getCustomAttributes() {
        return this.customAttributes;
    }

    @Override
    protected void applyAttributes() throws JspException {
        try {
            super.applyAttributes();
            DefaultTableRowRenderer row = (DefaultTableRowRenderer)this.getWrappedObject();
            if (this.bgColor != null) {
                row.setBgColor(this.getBgColor());
            }
            if (this.customAttributes != null) {
                row.setCustomAttributes(this.getCustomAttributes());
            }
            if (this.horizontalAlignment != null) {
                if (this.horizontalAlignment.equals("LEFT")) {
                    row.setHorizontalAlignment(2);
                } else if (this.horizontalAlignment.equals("CENTER")) {
                    row.setHorizontalAlignment(0);
                } else if (this.horizontalAlignment.equals("RIGHT")) {
                    row.setHorizontalAlignment(4);
                } else if (this.horizontalAlignment.equals("JUSTIFY")) {
                    row.setHorizontalAlignment(20);
                } else if (this.horizontalAlignment.equals("CHAR")) {
                    row.setHorizontalAlignment(21);
                } else {
                    row.setHorizontalAlignment(99);
                }
            }
            if (this.styleClassPrefix != null) {
                row.setStyleClassPrefix(this.getStyleClassPrefix());
            }
            if (this.verticalAlignment != null) {
                if (this.verticalAlignment.equals("TOP")) {
                    row.setVerticalAlignment(1);
                } else if (this.verticalAlignment.equals("CENTER")) {
                    row.setVerticalAlignment(0);
                } else if (this.verticalAlignment.equals("BOTTOM")) {
                    row.setVerticalAlignment(3);
                } else if (this.verticalAlignment.equals("BASELINE")) {
                    row.setVerticalAlignment(22);
                } else {
                    row.setVerticalAlignment(99);
                }
            }
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
    }
}

