/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.servlet.tbeans.graphics;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphStyle;
import com.sas.servlet.tbeans.graphics.BaseGraph;
import com.sas.taglib.servlet.tbeans.graphics.AbstractBaseGraphicsTag;
import jakarta.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public abstract class AbstractBaseGraphTag
extends AbstractBaseGraphicsTag {
    private Graph underlyingObject;
    private String color;
    private String model;
    private String graphStyle;
    private String colorScheme;
    private int defaultWidth;
    private int defaultHeight;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.color = null;
            this.model = null;
            this.graphStyle = null;
            this.colorScheme = null;
        }
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getModel() {
        return this.model;
    }

    public void setAppliedGraphStyleName(String s) {
        this.graphStyle = s;
    }

    public String getAppliedGraphStyleName() {
        return this.graphStyle;
    }

    public void setAppliedColorSchemeName(String s) {
        this.colorScheme = s;
    }

    public String getAppliedColorSchemeName() {
        return this.colorScheme;
    }

    @Override
    protected void applyAttributes() throws JspException {
        BaseGraph underlyingObject = (BaseGraph)this.getWrappedObject();
        Graph g = null;
        if (underlyingObject != null) {
            g = underlyingObject.getGraph();
        }
        if (this.graphStyle != null && g != null) {
            try {
                int gsn = GraphStyle.STYLE.valueOfJSPAttribute(this.graphStyle);
                g.applyGraphStyle(new GraphStyle(gsn));
            }
            catch (IllegalArgumentException x) {
                System.out.println(x.getMessage() + " - " + this.graphStyle);
            }
        }
        if (this.colorScheme != null && g != null) {
            try {
                int csn = ColorScheme.SCHEME.valueOfJSPAttribute(this.colorScheme);
                g.applyColorScheme(new ColorScheme(csn));
            }
            catch (IllegalArgumentException x) {
                System.out.println(x.getMessage() + " - " + this.colorScheme);
            }
        }
        super.applyAttributes();
    }
}

