/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import java.awt.Color;
import java.util.HashMap;

@SASScope
public class StringToColor {
    private static HashMap COLORS = new HashMap();

    public static Color getColorForName(String colorName) {
        if (colorName == null) {
            return null;
        }
        Color c = (Color)COLORS.get(colorName.toLowerCase());
        if (c != null) {
            return c;
        }
        String cn = colorName.toLowerCase();
        if (cn.startsWith("#")) {
            colorName = colorName.substring(1);
        } else if (cn.startsWith("cx") || cn.startsWith("0x")) {
            colorName = colorName.substring(2);
        }
        try {
            int rgb = Integer.parseInt(colorName, 16);
            return new Color(rgb);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    static {
        COLORS.put("black", Color.black);
        COLORS.put("blue", Color.blue);
        COLORS.put("brown", new Color(160, 50, 0));
        COLORS.put("charcoal", new Color(79, 79, 79));
        COLORS.put("cream", new Color(232, 216, 152));
        COLORS.put("cyan", Color.cyan);
        COLORS.put("fuschia", new Color(255, 0, 255));
        COLORS.put("gold", new Color(255, 170, 0));
        COLORS.put("gray", Color.gray);
        COLORS.put("green", Color.green);
        COLORS.put("lilac", new Color(224, 96, 144));
        COLORS.put("lime", new Color(192, 255, 129));
        COLORS.put("magenta", Color.magenta);
        COLORS.put("maroon", new Color(112, 0, 0));
        COLORS.put("navy", new Color(0, 0, 128));
        COLORS.put("olive", new Color(42, 131, 7));
        COLORS.put("orange", new Color(255, 128, 0));
        COLORS.put("pink", new Color(255, 0, 128));
        COLORS.put("purple", new Color(112, 48, 112));
        COLORS.put("red", Color.red);
        COLORS.put("rose", new Color(255, 96, 96));
        COLORS.put("salmon", new Color(255, 0, 85));
        COLORS.put("silver", new Color(192, 192, 192));
        COLORS.put("steel", new Color(56, 131, 168));
        COLORS.put("tan", new Color(224, 168, 96));
        COLORS.put("teal", new Color(0, 128, 128));
        COLORS.put("violet", new Color(176, 144, 208));
        COLORS.put("white", Color.white);
        COLORS.put("yellow", Color.yellow);
    }
}

