/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.areabarchart.AreaBarChart;
import com.sas.graphics.components.areabarchart.AreaBarChartModel;
import com.sas.graphics.components.barchart.BarChart;
import com.sas.graphics.components.barchart.BarChartModel;
import com.sas.graphics.components.barlinechart.BarLineChart;
import com.sas.graphics.components.barlinechart.BarLineChartModel;
import com.sas.graphics.components.linechart.LineChart;
import com.sas.graphics.components.linechart.LineChartModel;
import com.sas.graphics.components.lineplot.LinePlot;
import com.sas.graphics.components.lineplot.LinePlotModel;
import com.sas.graphics.components.piechart.PieChart;
import com.sas.graphics.components.piechart.PieChartModel;
import com.sas.graphics.components.radarchart.RadarChart;
import com.sas.graphics.components.radarchart.RadarChartModel;
import com.sas.graphics.components.scatterplot.ScatterPlot;
import com.sas.graphics.components.scatterplot.ScatterPlotModel;
import com.sas.graphics.components.tilechart.TileChart;
import com.sas.graphics.components.tilechart.TileChartModel;
import com.sas.graphics.components.waterfallchart.WaterfallChart;
import com.sas.graphics.components.waterfallchart.WaterfallChartModel;
import com.sas.servlet.tbeans.graphics.BaseGraph;
import com.sas.taglib.graphics.components.BaseGraphStyleTag;
import com.sas.taglib.servlet.tbeans.graphics.AbstractBaseGraphTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;

@SASScope(value="DEFAULT")
public class GraphStyleTag
extends BaseGraphStyleTag {
    @Override
    public int doStartTag() throws JspException {
        try {
            BaseGraph graph;
            Tag parent = this.getParent();
            if (parent != null && parent instanceof AbstractBaseGraphTag && (graph = (BaseGraph)((AbstractBaseGraphTag)parent).getWrappedObject()) != null) {
                this.setWrappedObject(this.asGraphStyle(graph.getGraph()));
            }
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        Tag parent = this.getParent();
        try {
            BaseGraph graph;
            if (parent != null && parent instanceof AbstractBaseGraphTag && (graph = (BaseGraph)((AbstractBaseGraphTag)parent).getWrappedObject()) != null) {
                graph.applyGraphStyle((GraphStyle)this.getWrappedObject());
            }
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return 6;
    }

    private GraphStyle asGraphStyle(Graph graph) {
        if (graph != null) {
            if (graph instanceof BarChart) {
                return this.asGraphStyle((BarChart)graph);
            }
            if (graph instanceof BarLineChart) {
                return this.asGraphStyle((BarLineChart)graph);
            }
            if (graph instanceof LineChart) {
                return this.asGraphStyle((LineChart)graph);
            }
            if (graph instanceof LinePlot) {
                return this.asGraphStyle((LinePlot)graph);
            }
            if (graph instanceof PieChart) {
                return this.asGraphStyle((PieChart)graph);
            }
            if (graph instanceof RadarChart) {
                return this.asGraphStyle((RadarChart)graph);
            }
            if (graph instanceof ScatterPlot) {
                return this.asGraphStyle((ScatterPlot)graph);
            }
            if (graph instanceof TileChart) {
                return this.asGraphStyle((TileChart)graph);
            }
            if (graph instanceof AreaBarChart) {
                return this.asGraphStyle((AreaBarChart)graph);
            }
            if (graph instanceof WaterfallChart) {
                return this.asGraphStyle((WaterfallChart)graph);
            }
            return this.asGraphStyle(graph);
        }
        return null;
    }

    private GraphStyle asGraphStyle(Graph graph, GraphModel graphModel) {
        GraphStyle graphStyle = new GraphStyle(graph.getAppliedGraphStyleName());
        if (graph.getAppliedColorSchemeName() != graphStyle.getAppliedColorSchemeName()) {
            graphStyle.applyColorScheme(new ColorScheme(graph.getAppliedColorSchemeName()));
        }
        if (graph.isAppliedGraphStyleModified()) {
            graphStyle.getTitle1TextStyle().apply(graph.getTitle1().getTextStyle());
            graphStyle.getTitle2TextStyle().apply(graph.getTitle2().getTextStyle());
            graphStyle.getTitle3TextStyle().apply(graph.getTitle3().getTextStyle());
            graphStyle.getTitle4TextStyle().apply(graph.getTitle4().getTextStyle());
            graphStyle.getFootnote1TextStyle().apply(graph.getFootnote1().getTextStyle());
            graphStyle.getFootnote2TextStyle().apply(graph.getFootnote2().getTextStyle());
            graphStyle.getDataElementStyles().apply(graphModel.getDataElementStyles());
            graphStyle.getBackgroundFillStyle().apply(graphModel.getBackgroundFillStyle());
            graphStyle.getFrameLineStyle().apply(graphModel.getFrameLineStyle());
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(BarChart chart) {
        BarChartModel barChartModel = chart.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)chart, (GraphModel)barChartModel);
        if (chart.isAppliedGraphStyleModified()) {
            AxisModel categoryAxisModel = barChartModel.getCategoryAxisModel();
            AxisModel responseAxisModel = barChartModel.getResponseAxisModel();
            AxisModel response2AxisModel = barChartModel.getResponse2AxisModel();
            GraphMatrixAxisModel columnAxisModel = barChartModel.getColumnAxisModel();
            GraphMatrixAxisModel rowAxisModel = barChartModel.getRowAxisModel();
            LegendModel legendModel = barChartModel.getLegendModel();
            if (responseAxisModel.getAxisLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && response2AxisModel.getAxisLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && barChartModel.getResponseAxisBaselineModel().getLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && barChartModel.getResponse2AxisBaselineModel().getLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle())) {
                graphStyle.getAxisLineStyle().apply(categoryAxisModel.getAxisLineStyle());
            } else {
                graphStyle.setAxisLineStyle(null);
            }
            if (responseAxisModel.getGridLineStyle().equals((Object)response2AxisModel.getGridLineStyle())) {
                graphStyle.getGridLineStyle().apply(responseAxisModel.getGridLineStyle());
            } else {
                graphStyle.setGridLineStyle(null);
            }
            if (responseAxisModel.getMajorTickStyle().equals((Object)categoryAxisModel.getMajorTickStyle()) && response2AxisModel.getMajorTickStyle().equals((Object)categoryAxisModel.getMajorTickStyle())) {
                graphStyle.getMajorTickStyle().apply(categoryAxisModel.getMajorTickStyle());
            } else {
                graphStyle.setMajorTickStyle(null);
            }
            if (responseAxisModel.getMinorTickStyle().equals((Object)response2AxisModel.getMinorTickStyle())) {
                graphStyle.getMinorTickStyle().apply(responseAxisModel.getMinorTickStyle());
            } else {
                graphStyle.setMinorTickStyle(null);
            }
            if (columnAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && categoryAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && responseAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && response2AxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && legendModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle())) {
                graphStyle.getValueTextStyle().apply(rowAxisModel.getValueTextStyle());
            } else {
                graphStyle.setValueTextStyle(null);
            }
            if (columnAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && categoryAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && responseAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && response2AxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && legendModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle())) {
                graphStyle.getLabelTextStyle().apply(rowAxisModel.getLabelTextStyle());
            } else {
                graphStyle.setLabelTextStyle(null);
            }
            if (columnAxisModel.getValueCellStyle().getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && legendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle())) {
                graphStyle.getFrameLineStyle().apply(rowAxisModel.getValueCellStyle().getFrameLineStyle());
            } else {
                graphStyle.setFrameLineStyle(null);
            }
            graphStyle.getWallFillStyle().apply(barChartModel.getAxisWallModel().getWallFillStyle());
            graphStyle.getFloorFillStyle().apply(barChartModel.getAxisWallModel().getFloorFillStyle());
            graphStyle.getLegendBackgroundFillStyle().apply(legendModel.getBackgroundFillStyle());
            graphStyle.getLegendShadowStyle().apply(legendModel.getShadowStyle());
            if (barChartModel.getInsideBarLabelTextStyle().equals((Object)barChartModel.getOutsideBarLabelTextStyle())) {
                graphStyle.getDataLabelTextStyle().apply((TextStyle)barChartModel.getOutsideBarLabelTextStyle());
            } else {
                graphStyle.setDataLabelTextStyle(null);
            }
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(BarLineChart chart) {
        BarLineChartModel barLineChartModel = chart.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)chart, (GraphModel)barLineChartModel);
        if (chart.isAppliedGraphStyleModified()) {
            AxisModel categoryAxisModel = barLineChartModel.getCategoryAxisModel();
            AxisModel responseAxisModel = barLineChartModel.getResponseAxisModel();
            AxisModel response2AxisModel = barLineChartModel.getResponse2AxisModel();
            LegendModel legendModel = barLineChartModel.getLegendModel();
            GraphMatrixAxisModel columnAxisModel = barLineChartModel.getColumnAxisModel();
            GraphMatrixAxisModel rowAxisModel = barLineChartModel.getRowAxisModel();
            if (responseAxisModel.getAxisLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && response2AxisModel.getAxisLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && barLineChartModel.getResponseAxisBaselineModel().getLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && barLineChartModel.getResponse2AxisBaselineModel().getLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle())) {
                graphStyle.getAxisLineStyle().apply(categoryAxisModel.getAxisLineStyle());
            } else {
                graphStyle.setAxisLineStyle(null);
            }
            if (responseAxisModel.getGridLineStyle().equals((Object)response2AxisModel.getGridLineStyle())) {
                graphStyle.getGridLineStyle().apply(responseAxisModel.getGridLineStyle());
            } else {
                graphStyle.setGridLineStyle(null);
            }
            if (responseAxisModel.getMajorTickStyle().equals((Object)categoryAxisModel.getMajorTickStyle()) && response2AxisModel.getMajorTickStyle().equals((Object)categoryAxisModel.getMajorTickStyle())) {
                graphStyle.getMajorTickStyle().apply(categoryAxisModel.getMajorTickStyle());
            } else {
                graphStyle.setMajorTickStyle(null);
            }
            if (responseAxisModel.getMinorTickStyle().equals((Object)response2AxisModel.getMinorTickStyle())) {
                graphStyle.getMinorTickStyle().apply(responseAxisModel.getMinorTickStyle());
            } else {
                graphStyle.setMinorTickStyle(null);
            }
            if (columnAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && categoryAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && responseAxisModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && response2AxisModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && legendModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle())) {
                graphStyle.getValueTextStyle().apply(rowAxisModel.getValueTextStyle());
            } else {
                graphStyle.setValueTextStyle(null);
            }
            if (columnAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && categoryAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && responseAxisModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && response2AxisModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && legendModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle())) {
                graphStyle.getLabelTextStyle().apply(rowAxisModel.getLabelTextStyle());
            } else {
                graphStyle.setLabelTextStyle(null);
            }
            if (columnAxisModel.getValueCellStyle().getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && legendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle())) {
                graphStyle.getFrameLineStyle().apply(rowAxisModel.getValueCellStyle().getFrameLineStyle());
            } else {
                graphStyle.setFrameLineStyle(null);
            }
            graphStyle.getWallFillStyle().apply(barLineChartModel.getAxisWallModel().getWallFillStyle());
            graphStyle.getFloorFillStyle().apply(barLineChartModel.getAxisWallModel().getFloorFillStyle());
            graphStyle.getLegendBackgroundFillStyle().apply(legendModel.getBackgroundFillStyle());
            graphStyle.getLegendShadowStyle().apply(legendModel.getShadowStyle());
            if (barLineChartModel.getInsideBarLabelTextStyle().equals((Object)barLineChartModel.getOutsideMarkerLabelTextStyle()) && barLineChartModel.getOutsideBarLabelTextStyle().equals((Object)barLineChartModel.getOutsideMarkerLabelTextStyle())) {
                graphStyle.getDataLabelTextStyle().apply((TextStyle)barLineChartModel.getOutsideMarkerLabelTextStyle());
            } else {
                graphStyle.setDataLabelTextStyle(null);
            }
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(LineChart chart) {
        LineChartModel lineChartModel = chart.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)chart, (GraphModel)lineChartModel);
        if (chart.isAppliedGraphStyleModified()) {
            AxisModel categoryAxisModel = lineChartModel.getCategoryAxisModel();
            AxisModel responseAxisModel = lineChartModel.getResponseAxisModel();
            AxisModel response2AxisModel = lineChartModel.getResponse2AxisModel();
            LegendModel legendModel = lineChartModel.getLegendModel();
            GraphMatrixAxisModel columnAxisModel = lineChartModel.getColumnAxisModel();
            GraphMatrixAxisModel rowAxisModel = lineChartModel.getRowAxisModel();
            if (responseAxisModel.getAxisLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && response2AxisModel.getAxisLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && lineChartModel.getResponseAxisBaselineModel().getLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && lineChartModel.getResponse2AxisBaselineModel().getLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle())) {
                graphStyle.getAxisLineStyle().apply(categoryAxisModel.getAxisLineStyle());
            } else {
                graphStyle.setAxisLineStyle(null);
            }
            if (responseAxisModel.getGridLineStyle().equals((Object)response2AxisModel.getGridLineStyle())) {
                graphStyle.getGridLineStyle().apply(responseAxisModel.getGridLineStyle());
            } else {
                graphStyle.setGridLineStyle(null);
            }
            if (responseAxisModel.getMajorTickStyle().equals((Object)categoryAxisModel.getMajorTickStyle()) && response2AxisModel.getMajorTickStyle().equals((Object)categoryAxisModel.getMajorTickStyle())) {
                graphStyle.getMajorTickStyle().apply(categoryAxisModel.getMajorTickStyle());
            } else {
                graphStyle.setMajorTickStyle(null);
            }
            if (responseAxisModel.getMinorTickStyle().equals((Object)response2AxisModel.getMinorTickStyle())) {
                graphStyle.getMinorTickStyle().apply(responseAxisModel.getMinorTickStyle());
            } else {
                graphStyle.setMinorTickStyle(null);
            }
            if (columnAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && categoryAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && responseAxisModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && response2AxisModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && legendModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle())) {
                graphStyle.getValueTextStyle().apply(rowAxisModel.getValueTextStyle());
            } else {
                graphStyle.setValueTextStyle(null);
            }
            if (columnAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && categoryAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && responseAxisModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && response2AxisModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && legendModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle())) {
                graphStyle.getLabelTextStyle().apply(rowAxisModel.getLabelTextStyle());
            } else {
                graphStyle.setLabelTextStyle(null);
            }
            if (columnAxisModel.getValueCellStyle().getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && legendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle())) {
                graphStyle.getFrameLineStyle().apply(rowAxisModel.getValueCellStyle().getFrameLineStyle());
            } else {
                graphStyle.setFrameLineStyle(null);
            }
            graphStyle.getWallFillStyle().apply(lineChartModel.getAxisWallModel().getWallFillStyle());
            graphStyle.getFloorFillStyle().apply(lineChartModel.getAxisWallModel().getFloorFillStyle());
            graphStyle.getLegendBackgroundFillStyle().apply(legendModel.getBackgroundFillStyle());
            graphStyle.getLegendShadowStyle().apply(legendModel.getShadowStyle());
            graphStyle.getDataLabelTextStyle().apply((TextStyle)lineChartModel.getOutsideMarkerLabelTextStyle());
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(LinePlot plot) {
        LinePlotModel linePlotModel = plot.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)plot, (GraphModel)linePlotModel);
        if (plot.isAppliedGraphStyleModified()) {
            AxisModel xAxisModel = linePlotModel.getXAxisModel();
            AxisModel yAxisModel = linePlotModel.getYAxisModel();
            AxisModel y2AxisModel = linePlotModel.getY2AxisModel();
            LegendModel colorLegendModel = linePlotModel.getColorLegendModel();
            LegendModel lineLegendModel = linePlotModel.getLineLegendModel();
            GraphMatrixAxisModel columnAxisModel = linePlotModel.getColumnAxisModel();
            GraphMatrixAxisModel rowAxisModel = linePlotModel.getRowAxisModel();
            if (yAxisModel.getAxisLineStyle().equals((Object)xAxisModel.getAxisLineStyle()) && y2AxisModel.getAxisLineStyle().equals((Object)xAxisModel.getAxisLineStyle())) {
                graphStyle.getAxisLineStyle().apply(xAxisModel.getAxisLineStyle());
            } else {
                graphStyle.setAxisLineStyle(null);
            }
            if (yAxisModel.getGridLineStyle().equals((Object)xAxisModel.getGridLineStyle()) && y2AxisModel.getGridLineStyle().equals((Object)xAxisModel.getGridLineStyle())) {
                graphStyle.getGridLineStyle().apply(xAxisModel.getGridLineStyle());
            } else {
                graphStyle.setGridLineStyle(null);
            }
            if (yAxisModel.getMajorTickStyle().equals((Object)xAxisModel.getMajorTickStyle()) && y2AxisModel.getMajorTickStyle().equals((Object)xAxisModel.getMajorTickStyle())) {
                graphStyle.getMajorTickStyle().apply(xAxisModel.getMajorTickStyle());
            } else {
                graphStyle.setMajorTickStyle(null);
            }
            if (yAxisModel.getMinorTickStyle().equals((Object)xAxisModel.getMinorTickStyle()) && y2AxisModel.getMinorTickStyle().equals((Object)xAxisModel.getMinorTickStyle())) {
                graphStyle.getMinorTickStyle().apply(xAxisModel.getMinorTickStyle());
            } else {
                graphStyle.setMinorTickStyle(null);
            }
            if (columnAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && xAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && yAxisModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && y2AxisModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && colorLegendModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && lineLegendModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle())) {
                graphStyle.getValueTextStyle().apply(rowAxisModel.getValueTextStyle());
            } else {
                graphStyle.setValueTextStyle(null);
            }
            if (columnAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && xAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && yAxisModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && y2AxisModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && colorLegendModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && lineLegendModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle())) {
                graphStyle.getLabelTextStyle().apply(rowAxisModel.getLabelTextStyle());
            } else {
                graphStyle.setLabelTextStyle(null);
            }
            if (linePlotModel.getTopMarkerLabelTextStyle().equals((Object)linePlotModel.getBottomMarkerLabelTextStyle())) {
                graphStyle.getDataLabelTextStyle().apply((TextStyle)linePlotModel.getTopMarkerLabelTextStyle());
            } else {
                graphStyle.setDataLabelTextStyle(null);
            }
            if (columnAxisModel.getValueCellStyle().getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && colorLegendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && lineLegendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle())) {
                graphStyle.getFrameLineStyle().apply(rowAxisModel.getValueCellStyle().getFrameLineStyle());
            } else {
                graphStyle.setFrameLineStyle(null);
            }
            graphStyle.getWallFillStyle().apply(linePlotModel.getAxisWallModel().getWallFillStyle());
            if (!lineLegendModel.getBackgroundFillStyle().equals((Object)colorLegendModel.getBackgroundFillStyle())) {
                graphStyle.setLegendBackgroundFillStyle(null);
            }
            if (!colorLegendModel.getShadowStyle().equals((Object)lineLegendModel.getShadowStyle())) {
                graphStyle.setLegendShadowStyle(null);
            }
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(PieChart chart) {
        PieChartModel pieChartModel = chart.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)chart, (GraphModel)pieChartModel);
        if (chart.isAppliedGraphStyleModified()) {
            LegendModel legendModel = pieChartModel.getLegendModel();
            GraphMatrixAxisModel columnAxisModel = pieChartModel.getColumnAxisModel();
            GraphMatrixAxisModel rowAxisModel = pieChartModel.getRowAxisModel();
            if (pieChartModel.getInsideSliceLabelTextStyle().equals((Object)legendModel.getValueTextStyle()) && pieChartModel.getOutsideSliceLabelTextStyle().equals((Object)legendModel.getValueTextStyle()) && pieChartModel.getSubgroupLabelModel().getValueTextStyle().equals((Object)legendModel.getValueTextStyle()) && rowAxisModel.getValueTextStyle().equals((Object)legendModel.getValueTextStyle()) && columnAxisModel.getValueTextStyle().equals((Object)legendModel.getValueTextStyle())) {
                graphStyle.getValueTextStyle().apply(rowAxisModel.getValueTextStyle());
            } else {
                graphStyle.setValueTextStyle(null);
            }
            if (legendModel.getLabelTextStyle().equals((Object)pieChartModel.getDonutHoleLabelTextStyle()) && pieChartModel.getSubgroupLabelModel().getLabelTextStyle().equals((Object)pieChartModel.getDonutHoleLabelTextStyle()) && pieChartModel.getResponseLabelTextStyle().equals((Object)pieChartModel.getDonutHoleLabelTextStyle()) && rowAxisModel.getLabelTextStyle().equals((Object)legendModel.getLabelTextStyle()) && columnAxisModel.getLabelTextStyle().equals((Object)legendModel.getLabelTextStyle())) {
                graphStyle.getLabelTextStyle().apply(legendModel.getLabelTextStyle());
            } else {
                graphStyle.setLabelTextStyle(null);
            }
            if (columnAxisModel.getValueCellStyle().getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && legendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle())) {
                graphStyle.getFrameLineStyle().apply(rowAxisModel.getValueCellStyle().getFrameLineStyle());
            } else {
                graphStyle.setFrameLineStyle(null);
            }
            graphStyle.getLegendBackgroundFillStyle().apply(legendModel.getBackgroundFillStyle());
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(RadarChart chart) {
        RadarChartModel radarChartModel = chart.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)chart, (GraphModel)radarChartModel);
        if (chart.isAppliedGraphStyleModified()) {
            AxisModel axisModel = radarChartModel.getAxisModel();
            LegendModel legendModel = radarChartModel.getColorLegendModel();
            GraphMatrixAxisModel columnAxisModel = radarChartModel.getColumnAxisModel();
            GraphMatrixAxisModel rowAxisModel = radarChartModel.getRowAxisModel();
            graphStyle.getAxisLineStyle().apply(axisModel.getAxisLineStyle());
            graphStyle.getGridLineStyle().apply(axisModel.getGridLineStyle());
            graphStyle.getMajorTickStyle().apply(axisModel.getMajorTickStyle());
            graphStyle.getMinorTickStyle().apply(axisModel.getMinorTickStyle());
            if (columnAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && axisModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && legendModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle())) {
                graphStyle.getValueTextStyle().apply(rowAxisModel.getValueTextStyle());
            } else {
                graphStyle.setValueTextStyle(null);
            }
            if (columnAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && axisModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && legendModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle())) {
                graphStyle.getLabelTextStyle().apply(rowAxisModel.getLabelTextStyle());
            } else {
                graphStyle.setLabelTextStyle(null);
            }
            if (columnAxisModel.getValueCellStyle().getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && legendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle())) {
                graphStyle.getFrameLineStyle().apply(rowAxisModel.getValueCellStyle().getFrameLineStyle());
            } else {
                graphStyle.setFrameLineStyle(null);
            }
            graphStyle.getLegendBackgroundFillStyle().apply(legendModel.getBackgroundFillStyle());
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(ScatterPlot plot) {
        ScatterPlotModel scatterPlotModel = plot.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)plot, (GraphModel)scatterPlotModel);
        if (plot.isAppliedGraphStyleModified()) {
            AxisModel xAxisModel = scatterPlotModel.getXAxisModel();
            AxisModel yAxisModel = scatterPlotModel.getYAxisModel();
            AxisModel y2AxisModel = scatterPlotModel.getY2AxisModel();
            LegendModel colorLegendModel = scatterPlotModel.getColorLegendModel();
            LegendModel shapeLegendModel = scatterPlotModel.getShapeLegendModel();
            GraphMatrixAxisModel columnAxisModel = scatterPlotModel.getColumnAxisModel();
            GraphMatrixAxisModel rowAxisModel = scatterPlotModel.getRowAxisModel();
            if (yAxisModel.getAxisLineStyle().equals((Object)xAxisModel.getAxisLineStyle()) && y2AxisModel.getAxisLineStyle().equals((Object)xAxisModel.getAxisLineStyle())) {
                graphStyle.getAxisLineStyle().apply(xAxisModel.getAxisLineStyle());
            } else {
                graphStyle.setAxisLineStyle(null);
            }
            if (yAxisModel.getGridLineStyle().equals((Object)xAxisModel.getGridLineStyle()) && y2AxisModel.getGridLineStyle().equals((Object)xAxisModel.getGridLineStyle())) {
                graphStyle.getGridLineStyle().apply(xAxisModel.getGridLineStyle());
            } else {
                graphStyle.setGridLineStyle(null);
            }
            if (yAxisModel.getMajorTickStyle().equals((Object)xAxisModel.getMajorTickStyle()) && y2AxisModel.getMajorTickStyle().equals((Object)xAxisModel.getMajorTickStyle())) {
                graphStyle.getMajorTickStyle().apply(xAxisModel.getMajorTickStyle());
            } else {
                graphStyle.setMajorTickStyle(null);
            }
            if (yAxisModel.getMinorTickStyle().equals((Object)xAxisModel.getMinorTickStyle()) && y2AxisModel.getMinorTickStyle().equals((Object)xAxisModel.getMinorTickStyle())) {
                graphStyle.getMinorTickStyle().apply(xAxisModel.getMinorTickStyle());
            } else {
                graphStyle.setMinorTickStyle(null);
            }
            if (columnAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && xAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && yAxisModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && y2AxisModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && colorLegendModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle()) && shapeLegendModel.getValueTextStyle().equals((Object)graphStyle.getValueTextStyle())) {
                graphStyle.getValueTextStyle().apply(rowAxisModel.getValueTextStyle());
            } else {
                graphStyle.setValueTextStyle(null);
            }
            if (columnAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && xAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && yAxisModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && y2AxisModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && colorLegendModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle()) && shapeLegendModel.getLabelTextStyle().equals((Object)graphStyle.getLabelTextStyle())) {
                graphStyle.getLabelTextStyle().apply(rowAxisModel.getLabelTextStyle());
            } else {
                graphStyle.setLabelTextStyle(null);
            }
            if (scatterPlotModel.getTopMarkerLabelTextStyle().equals((Object)scatterPlotModel.getBottomMarkerLabelTextStyle())) {
                graphStyle.getDataLabelTextStyle().apply((TextStyle)scatterPlotModel.getTopMarkerLabelTextStyle());
            } else {
                graphStyle.setDataLabelTextStyle(null);
            }
            if (columnAxisModel.getValueCellStyle().getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && colorLegendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && shapeLegendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle())) {
                graphStyle.getFrameLineStyle().apply(rowAxisModel.getValueCellStyle().getFrameLineStyle());
            } else {
                graphStyle.setFrameLineStyle(null);
            }
            graphStyle.getWallFillStyle().apply(scatterPlotModel.getAxisWallModel().getWallFillStyle());
            if (!colorLegendModel.getBackgroundFillStyle().equals((Object)graphStyle.getLegendBackgroundFillStyle()) || !shapeLegendModel.getBackgroundFillStyle().equals((Object)graphStyle.getLegendBackgroundFillStyle())) {
                graphStyle.setLegendBackgroundFillStyle(null);
            }
            if (!colorLegendModel.getShadowStyle().equals((Object)graphStyle.getLegendShadowStyle()) || !shapeLegendModel.getShadowStyle().equals((Object)graphStyle.getLegendShadowStyle())) {
                graphStyle.setLegendShadowStyle(null);
            }
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(AreaBarChart chart) {
        AreaBarChartModel areaBarChartModel = chart.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)chart, (GraphModel)areaBarChartModel);
        if (chart.isAppliedGraphStyleModified()) {
            AxisModel widthAxisModel = areaBarChartModel.getWidthAxisModel();
            AxisModel heightAxisModel = areaBarChartModel.getHeightAxisModel();
            LegendModel legendModel = areaBarChartModel.getLegendModel();
            if (widthAxisModel.getAxisLineStyle().equals((Object)heightAxisModel.getAxisLineStyle())) {
                graphStyle.getAxisLineStyle().apply(widthAxisModel.getAxisLineStyle());
            } else {
                graphStyle.setAxisLineStyle(null);
            }
            if (widthAxisModel.getGridLineStyle().equals((Object)heightAxisModel.getGridLineStyle())) {
                graphStyle.getGridLineStyle().apply(heightAxisModel.getGridLineStyle());
            } else {
                graphStyle.setGridLineStyle(null);
            }
            if (widthAxisModel.getMajorTickStyle().equals((Object)heightAxisModel.getMajorTickStyle())) {
                graphStyle.getMajorTickStyle().apply(widthAxisModel.getMajorTickStyle());
            } else {
                graphStyle.setMajorTickStyle(null);
            }
            if (widthAxisModel.getMinorTickStyle().equals((Object)heightAxisModel.getMinorTickStyle())) {
                graphStyle.getMinorTickStyle().apply(heightAxisModel.getMinorTickStyle());
            } else {
                graphStyle.setMinorTickStyle(null);
            }
            if (widthAxisModel.getValueTextStyle().equals((Object)heightAxisModel.getValueTextStyle()) && legendModel.getValueTextStyle().equals((Object)widthAxisModel.getValueTextStyle())) {
                graphStyle.getValueTextStyle().apply(widthAxisModel.getValueTextStyle());
            } else {
                graphStyle.setValueTextStyle(null);
            }
            if (widthAxisModel.getLabelTextStyle().equals((Object)heightAxisModel.getLabelTextStyle()) && legendModel.getLabelTextStyle().equals((Object)heightAxisModel.getLabelTextStyle())) {
                graphStyle.getLabelTextStyle().apply(heightAxisModel.getLabelTextStyle());
            } else {
                graphStyle.setLabelTextStyle(null);
            }
            graphStyle.getFrameLineStyle().apply(legendModel.getFrameLineStyle());
            graphStyle.getWallFillStyle().apply(areaBarChartModel.getAxisWallModel().getWallFillStyle());
            graphStyle.getFloorFillStyle().apply(areaBarChartModel.getAxisWallModel().getFloorFillStyle());
            graphStyle.getLegendBackgroundFillStyle().apply(legendModel.getBackgroundFillStyle());
            graphStyle.getLegendShadowStyle().apply(legendModel.getShadowStyle());
            if (areaBarChartModel.getInsideBarLabelTextStyle().equals((Object)areaBarChartModel.getOutsideBarLabelTextStyle())) {
                graphStyle.getDataLabelTextStyle().apply((TextStyle)areaBarChartModel.getOutsideBarLabelTextStyle());
            } else {
                graphStyle.setDataLabelTextStyle(null);
            }
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(TileChart chart) {
        TileChartModel tileChartModel = chart.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)chart, (GraphModel)tileChartModel);
        if (chart.isAppliedGraphStyleModified()) {
            LegendModel legendModel = tileChartModel.getLegendModel();
            graphStyle.getValueTextStyle().apply(legendModel.getValueTextStyle());
            graphStyle.getLabelTextStyle().apply(legendModel.getLabelTextStyle());
            graphStyle.getFrameLineStyle().apply(legendModel.getFrameLineStyle());
            graphStyle.getLegendBackgroundFillStyle().apply(legendModel.getBackgroundFillStyle());
            graphStyle.getLegendShadowStyle().apply(legendModel.getShadowStyle());
            graphStyle.getDataLabelTextStyle().apply((TextStyle)tileChartModel.getDataLabelTextStyle());
        }
        return graphStyle;
    }

    private GraphStyle asGraphStyle(WaterfallChart chart) {
        WaterfallChartModel waterfallChartModel = chart.getGraphModel();
        GraphStyle graphStyle = this.asGraphStyle((Graph)chart, (GraphModel)waterfallChartModel);
        if (chart.isAppliedGraphStyleModified()) {
            AxisModel categoryAxisModel = waterfallChartModel.getCategoryAxisModel();
            AxisModel responseAxisModel = waterfallChartModel.getResponseAxisModel();
            GraphMatrixAxisModel columnAxisModel = waterfallChartModel.getColumnAxisModel();
            GraphMatrixAxisModel rowAxisModel = waterfallChartModel.getRowAxisModel();
            LegendModel legendModel = waterfallChartModel.getLegendModel();
            if (responseAxisModel.getAxisLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle()) && waterfallChartModel.getResponseAxisBaselineModel().getLineStyle().equals((Object)categoryAxisModel.getAxisLineStyle())) {
                graphStyle.getAxisLineStyle().apply(categoryAxisModel.getAxisLineStyle());
            } else {
                graphStyle.setAxisLineStyle(null);
            }
            graphStyle.getGridLineStyle().apply(responseAxisModel.getGridLineStyle());
            if (responseAxisModel.getMajorTickStyle().equals((Object)categoryAxisModel.getMajorTickStyle())) {
                graphStyle.getMajorTickStyle().apply(categoryAxisModel.getMajorTickStyle());
            } else {
                graphStyle.setMajorTickStyle(null);
            }
            graphStyle.getMinorTickStyle().apply(responseAxisModel.getMinorTickStyle());
            if (columnAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && categoryAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && responseAxisModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle()) && legendModel.getValueTextStyle().equals((Object)rowAxisModel.getValueTextStyle())) {
                graphStyle.getValueTextStyle().apply(rowAxisModel.getValueTextStyle());
            } else {
                graphStyle.setValueTextStyle(null);
            }
            if (columnAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && categoryAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && responseAxisModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle()) && legendModel.getLabelTextStyle().equals((Object)rowAxisModel.getLabelTextStyle())) {
                graphStyle.getLabelTextStyle().apply(rowAxisModel.getLabelTextStyle());
            } else {
                graphStyle.setLabelTextStyle(null);
            }
            if (columnAxisModel.getValueCellStyle().getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle()) && legendModel.getFrameLineStyle().equals((Object)rowAxisModel.getValueCellStyle().getFrameLineStyle())) {
                graphStyle.getFrameLineStyle().apply(rowAxisModel.getValueCellStyle().getFrameLineStyle());
            } else {
                graphStyle.setFrameLineStyle(null);
            }
            graphStyle.getWallFillStyle().apply(waterfallChartModel.getAxisWallModel().getWallFillStyle());
            graphStyle.getFloorFillStyle().apply(waterfallChartModel.getAxisWallModel().getFloorFillStyle());
            graphStyle.getLegendBackgroundFillStyle().apply(legendModel.getBackgroundFillStyle());
            graphStyle.getLegendShadowStyle().apply(legendModel.getShadowStyle());
            graphStyle.getDataLabelTextStyle().apply((TextStyle)waterfallChartModel.getOutsideBarLabelTextStyle());
        }
        return graphStyle;
    }
}

