/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.DataElementStyles;
import com.sas.graphics.components.FillStyle;
import com.sas.taglib.graphics.components.BaseDataElementStylesTag;
import com.sas.taglib.graphics.components.BaseFillStyleTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;

@SASScope(value="DEFAULT")
public class FillStyleTag
extends BaseFillStyleTag {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int doStartTag() throws JspException {
        try {
            Tag parent = this.getParent();
            if (parent != null && !(parent instanceof BaseDataElementStylesTag)) return super.doStartTag();
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        try {
            Tag parent = this.getParent();
            if (parent != null && parent instanceof BaseDataElementStylesTag) {
                DataElementStyles dataElementStyles = (DataElementStyles)((BaseDataElementStylesTag)parent).getWrappedObject();
                boolean fillStylesChanged = ((BaseDataElementStylesTag)parent).isFillStylesChanged();
                FillStyle[] fillStyles = dataElementStyles.getFillStyles();
                if (!fillStylesChanged) {
                    ((BaseDataElementStylesTag)parent).setFillStylesChanged(true);
                    fillStyles = new FillStyle[1];
                } else {
                    FillStyle[] tempFillStyles = fillStyles;
                    fillStyles = new FillStyle[fillStyles.length + 1];
                    System.arraycopy(tempFillStyles, 0, fillStyles, 0, tempFillStyles.length);
                }
                fillStyles[fillStyles.length - 1] = (FillStyle)this.getWrappedObject();
                dataElementStyles.setFillStyles(fillStyles);
            }
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return 6;
    }
}

