/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.DataElementStyles;
import com.sas.taglib.graphics.components.BaseColorTag;
import com.sas.taglib.graphics.components.BaseDataElementStylesTag;
import jakarta.servlet.jsp.JspException;
import jakarta.servlet.jsp.tagext.Tag;
import java.awt.Color;

@SASScope(value="DEFAULT")
public class DiscreteFillColorTag
extends BaseColorTag {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int doStartTag() throws JspException {
        try {
            Tag parent = this.getParent();
            if (parent != null && !(parent instanceof DataElementStyles)) return super.doStartTag();
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        try {
            Tag parent = this.getParent();
            if (parent != null && parent instanceof DataElementStyles) {
                DataElementStyles dataElementStyles = (DataElementStyles)((BaseDataElementStylesTag)parent).getWrappedObject();
                boolean discreteFillColorsChanged = ((BaseDataElementStylesTag)parent).isDiscreteFillColorsChanged();
                Color[] discreteFillColors = dataElementStyles.getDiscreteFillColors();
                if (!discreteFillColorsChanged) {
                    ((BaseDataElementStylesTag)parent).setDiscreteFillColorsChanged(true);
                    discreteFillColors = new Color[1];
                } else {
                    Color[] tempDiscreteFillColors = discreteFillColors;
                    discreteFillColors = new Color[discreteFillColors.length + 1];
                    System.arraycopy(tempDiscreteFillColors, 0, discreteFillColors, 0, tempDiscreteFillColors.length);
                }
                discreteFillColors[discreteFillColors.length - 1] = (Color)this.getWrappedObject();
                dataElementStyles.setDiscreteFillColors(discreteFillColors);
            }
        }
        catch (Exception e) {
            throw new JspException(e.toString());
        }
        return 6;
    }
}

