/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.TextStyle;
import com.sas.taglib.BaseBodyTag;
import com.sas.taglib.graphics.components.StringToColor;
import jakarta.servlet.jsp.JspException;
import java.awt.Color;

@SASScope(value="DEFAULT")
public class BaseTextStyleTag
extends BaseBodyTag {
    private String color;
    private String justification;
    private Boolean visible;
    private TextStyle underlyingObject;

    public String getColor() {
        return this.color;
    }

    public String getJustification() {
        return this.justification;
    }

    public Boolean isVisible() {
        return this.visible;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setJustification(String justification) {
        this.justification = justification;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    protected void applyAttributes() throws JspException {
        Color c;
        super.applyAttributes();
        this.underlyingObject = (TextStyle)this.getWrappedObject();
        if (this.color != null && (c = StringToColor.getColorForName(this.color)) != null) {
            this.underlyingObject.setColor(c);
        }
        if (this.justification != null) {
            if (this.justification.equalsIgnoreCase("Right")) {
                this.underlyingObject.setJustification(4);
            } else if (this.justification.equalsIgnoreCase("Center")) {
                this.underlyingObject.setJustification(0);
            } else if (this.justification.equalsIgnoreCase("Left")) {
                this.underlyingObject.setJustification(2);
            }
        }
        if (this.visible != null) {
            this.underlyingObject.setVisible(this.visible.booleanValue());
        }
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.TextStyle");
        }
        super.doStartTag();
        return 2;
    }
}

