/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.radarchart.RadarChartModel;
import com.sas.taglib.graphics.components.BaseGraphModelTag;
import jakarta.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public class BaseRadarChartModelTag
extends BaseGraphModelTag {
    private String radarType;
    private Double startAngle;
    private Boolean fillEnabled;
    private Boolean uniformAxes;
    private String missingPolicy;
    private RadarChartModel underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.radarType = null;
            this.startAngle = null;
            this.fillEnabled = null;
            this.uniformAxes = null;
            this.missingPolicy = null;
        }
        this.underlyingObject = null;
    }

    @Override
    protected void applyAttributes() throws JspException {
        super.applyAttributes();
        this.underlyingObject = (RadarChartModel)this.getWrappedObject();
        if (this.radarType != null) {
            this.underlyingObject.setRadarType(RadarChartModel.RADAR_TYPE.valueOfJSPAttribute(this.radarType));
        }
        if (this.startAngle != null) {
            this.underlyingObject.setStartAngle(this.startAngle.doubleValue());
        }
        if (this.fillEnabled != null) {
            this.underlyingObject.setFillEnabled(this.fillEnabled.booleanValue());
        }
        if (this.uniformAxes != null) {
            this.underlyingObject.setUniformAxes(this.uniformAxes.booleanValue());
        }
        if (this.missingPolicy != null) {
            this.underlyingObject.setMissingPolicy(GraphConstants.TRI.valueOfJSPAttribute(this.missingPolicy));
        }
    }

    public String getRadarType() {
        return this.radarType;
    }

    public Double getStartAngle() {
        return this.startAngle;
    }

    public void setRadarType(String radarType) {
        this.radarType = radarType;
    }

    public void setStartAngle(Double startAngle) {
        this.startAngle = startAngle;
    }

    public Boolean isFilled() {
        return this.isFillEnabled();
    }

    public Boolean isFillEnabled() {
        return this.fillEnabled;
    }

    public Boolean isUniformAxes() {
        return this.uniformAxes;
    }

    public void setFilledRadar(Boolean filledRadar) {
        this.setFillEnabled(filledRadar);
    }

    public void setFillEnabled(Boolean fillEnabled) {
        this.fillEnabled = fillEnabled;
    }

    public void setUniformAxes(Boolean uniformAxes) {
        this.uniformAxes = uniformAxes;
    }

    public String getMissingPolicy() {
        return this.missingPolicy;
    }

    public void setMissingPolicy(String string) {
        this.missingPolicy = string;
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.radarchart.RadarChartModel");
        }
        super.doStartTag();
        return 2;
    }
}

