/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.MarkerStyle;
import com.sas.measures.BaseLength;
import com.sas.taglib.BaseBodyTag;
import com.sas.taglib.graphics.components.StringToColor;
import jakarta.servlet.jsp.JspException;
import java.awt.Color;

@SASScope(value="DEFAULT")
public class BaseMarkerStyleTag
extends BaseBodyTag {
    private Boolean visible;
    private String symbol;
    private String size;
    private String color;
    private String interpolation;
    private String connectionOrder;
    private MarkerStyle underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.visible = null;
            this.symbol = null;
            this.size = null;
            this.color = null;
            this.interpolation = null;
            this.connectionOrder = null;
        }
        this.underlyingObject = null;
    }

    @Override
    protected void applyAttributes() throws JspException {
        Color c;
        super.applyAttributes();
        this.underlyingObject = (MarkerStyle)this.getWrappedObject();
        if (this.visible != null) {
            this.underlyingObject.setVisible(this.visible.booleanValue());
        }
        if (this.symbol != null) {
            this.underlyingObject.setSymbol(MarkerStyle.SYMBOL.valueOfJSPAttribute(this.symbol));
        }
        if (this.size != null) {
            this.underlyingObject.setSize(new BaseLength(this.size));
        }
        if (this.color != null && (c = StringToColor.getColorForName(this.color)) != null) {
            this.underlyingObject.setColor(c);
        }
        if (this.interpolation != null) {
            this.underlyingObject.setInterpolation(MarkerStyle.INTERPOLATION.valueOfJSPAttribute(this.interpolation));
        }
        if (this.connectionOrder != null) {
            this.underlyingObject.setConnectionOrder(MarkerStyle.CONNECTION_ORDER.valueOfJSPAttribute(this.connectionOrder));
        }
    }

    public String getColor() {
        return this.color;
    }

    public String getInterpolation() {
        return this.interpolation;
    }

    public String getConnectionOrder() {
        return this.connectionOrder;
    }

    public String getSize() {
        return this.size;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Boolean isVisible() {
        return this.visible;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public void setInterpolation(String interpolation) {
        this.interpolation = interpolation;
    }

    public void setConnectionOrder(String connectionOrder) {
        this.connectionOrder = connectionOrder;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.MarkerStyle");
        }
        super.doStartTag();
        return 2;
    }
}

