/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.barchart.BarChartModel;
import com.sas.measures.BaseLength;
import com.sas.taglib.graphics.components.BaseGraphModelTag;
import jakarta.servlet.jsp.JspException;

@SASScope(value="DEFAULT")
public class BaseBarChartModelTag
extends BaseGraphModelTag {
    private Double responseAxisUpperThreshold;
    private Double responseAxisLowerThreshold;
    private Double response2AxisUpperThreshold;
    private Double response2AxisLowerThreshold;
    private String orientation;
    private String barShape;
    private String barWidth;
    private String barWidthSpace;
    private Boolean growBarWidthEnabled;
    private String stackBarPolicy;
    private String insideBarLabelContent;
    private String outsideBarLabelContent;
    private String dimension;
    private String missingPolicy;
    private BarChartModel underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.responseAxisUpperThreshold = null;
            this.responseAxisLowerThreshold = null;
            this.response2AxisUpperThreshold = null;
            this.response2AxisLowerThreshold = null;
            this.orientation = null;
            this.barShape = null;
            this.barWidth = null;
            this.barWidthSpace = null;
            this.growBarWidthEnabled = null;
            this.stackBarPolicy = null;
            this.insideBarLabelContent = null;
            this.outsideBarLabelContent = null;
            this.dimension = null;
            this.missingPolicy = null;
        }
        this.underlyingObject = null;
    }

    public String getInsideBarLabelContent() {
        return this.insideBarLabelContent;
    }

    public String getOutsideBarLabelContent() {
        return this.outsideBarLabelContent;
    }

    public String getBarShape() {
        return this.barShape;
    }

    public String getBarWidth() {
        return this.barWidth;
    }

    public String getBarWidthSpace() {
        return this.barWidthSpace;
    }

    public Boolean isGrowBarWidthEnabled() {
        return this.growBarWidthEnabled;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public Double getResponse2AxisLowerThreshold() {
        return this.response2AxisLowerThreshold;
    }

    public Double getResponse2AxisUpperThreshold() {
        return this.response2AxisUpperThreshold;
    }

    public Double getResponseAxisLowerThreshold() {
        return this.responseAxisLowerThreshold;
    }

    public Double getResponseAxisUpperThreshold() {
        return this.responseAxisUpperThreshold;
    }

    public String getStackBarPolicy() {
        return this.stackBarPolicy;
    }

    public void setInsideBarLabelContent(String insideBarLabelContent) {
        this.insideBarLabelContent = insideBarLabelContent;
    }

    public void setOutsideBarLabelContent(String outsideBarLabelContent) {
        this.outsideBarLabelContent = outsideBarLabelContent;
    }

    public void setBarShape(String barShape) {
        this.barShape = barShape;
    }

    public void setBarWidth(String barWidth) {
        this.barWidth = barWidth;
    }

    public void setBarWidthSpace(String barWidthSpace) {
        this.barWidthSpace = barWidthSpace;
    }

    public void setGrowBarWidthEnabled(Boolean growBarWidthEnabled) {
        this.growBarWidthEnabled = growBarWidthEnabled;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public void setResponse2AxisLowerThreshold(Double response2AxisLowerThreshold) {
        this.response2AxisLowerThreshold = response2AxisLowerThreshold;
    }

    public void setResponse2AxisUpperThreshold(Double response2AxisUpperThreshold) {
        this.response2AxisUpperThreshold = response2AxisUpperThreshold;
    }

    public void setResponseAxisLowerThreshold(Double responseAxisLowerThreshold) {
        this.responseAxisLowerThreshold = responseAxisLowerThreshold;
    }

    public void setResponseAxisUpperThreshold(Double responseAxisUpperThreshold) {
        this.responseAxisUpperThreshold = responseAxisUpperThreshold;
    }

    public void setStackBarPolicy(String stackBarPolicy) {
        this.stackBarPolicy = stackBarPolicy;
    }

    public String getDimension() {
        return this.dimension;
    }

    public void setDimension(String dimension) {
        this.dimension = dimension;
    }

    public String getMissingPolicy() {
        return this.missingPolicy;
    }

    public void setMissingPolicy(String string) {
        this.missingPolicy = string;
    }

    @Override
    protected void applyAttributes() throws JspException {
        super.applyAttributes();
        this.underlyingObject = (BarChartModel)this.getWrappedObject();
        if (this.responseAxisUpperThreshold != null) {
            this.underlyingObject.setResponseAxisUpperThreshold(this.responseAxisUpperThreshold.doubleValue());
        }
        if (this.responseAxisLowerThreshold != null) {
            this.underlyingObject.setResponseAxisLowerThreshold(this.responseAxisLowerThreshold.doubleValue());
        }
        if (this.response2AxisUpperThreshold != null) {
            this.underlyingObject.setResponse2AxisUpperThreshold(this.response2AxisUpperThreshold.doubleValue());
        }
        if (this.response2AxisLowerThreshold != null) {
            this.underlyingObject.setResponse2AxisLowerThreshold(this.response2AxisLowerThreshold.doubleValue());
        }
        if (this.orientation != null) {
            if (this.orientation.equalsIgnoreCase("Vertical")) {
                this.underlyingObject.setOrientation(1);
            } else if (this.orientation.equalsIgnoreCase("Horizontal")) {
                this.underlyingObject.setOrientation(0);
            }
        }
        if (this.barShape != null) {
            this.underlyingObject.setBarShape(GraphConstants.BAR_SHAPE.valueOfJSPAttribute(this.barShape));
        }
        if (this.growBarWidthEnabled != null) {
            this.underlyingObject.setGrowBarWidthEnabled(this.growBarWidthEnabled.booleanValue());
        }
        if (this.stackBarPolicy != null) {
            this.underlyingObject.setStackBarPolicy(GraphConstants.TRI.valueOfJSPAttribute(this.stackBarPolicy));
        }
        if (this.insideBarLabelContent != null) {
            this.underlyingObject.setInsideBarLabelContent(GraphConstants.DATA_LABEL.valueOfJSPAttribute(this.insideBarLabelContent));
        }
        if (this.outsideBarLabelContent != null) {
            this.underlyingObject.setOutsideBarLabelContent(GraphConstants.DATA_LABEL.valueOfJSPAttribute(this.outsideBarLabelContent));
        }
        if (this.barWidth != null) {
            this.underlyingObject.setBarWidth(new BaseLength(this.barWidth));
        }
        if (this.barWidthSpace != null) {
            this.underlyingObject.setBarWidthSpace(new BaseLength(this.barWidthSpace));
        }
        if (this.dimension != null) {
            this.underlyingObject.setDimension(GraphConstants.DIMENSION.valueOfJSPAttribute(this.dimension));
        }
        if (this.missingPolicy != null) {
            this.underlyingObject.setMissingPolicy(GraphConstants.TRI.valueOfJSPAttribute(this.missingPolicy));
        }
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.barchart.BarChartModel");
        }
        super.doStartTag();
        return 2;
    }
}

