/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.GraphConstants;
import com.sas.measures.BaseLength;
import com.sas.taglib.BaseBodyTag;
import jakarta.servlet.jsp.JspException;
import java.util.StringTokenizer;

@SASScope(value="DEFAULT")
public class BaseAxisModelTag
extends BaseBodyTag {
    private Boolean gridInFront;
    private String label;
    private Boolean visible;
    private String endOffset;
    private String startOffset;
    private String categories;
    private Boolean reverseDirection;
    private String continuousMajorTickPositionPolicy;
    private Integer continuousMajorTickCount;
    private Integer continuousMinorTickCount;
    private Double continuousMajorTickInterval;
    private Double continuousMajorTickAnchor;
    private Integer majorTickTimeInterval;
    private String continuousMajorTickValues;
    private Double maximum;
    private Double minimum;
    private String labelPlacementPolicy;
    private AxisModel underlyingObject;

    @Override
    protected void initialize(boolean includeAttributes) {
        super.initialize(includeAttributes);
        if (includeAttributes) {
            this.gridInFront = null;
            this.label = null;
            this.visible = null;
            this.endOffset = null;
            this.startOffset = null;
            this.reverseDirection = null;
            this.continuousMajorTickPositionPolicy = null;
            this.continuousMajorTickCount = null;
            this.continuousMinorTickCount = null;
            this.continuousMajorTickInterval = null;
            this.continuousMajorTickAnchor = null;
            this.majorTickTimeInterval = null;
            this.continuousMajorTickValues = null;
            this.categories = null;
            this.maximum = null;
            this.minimum = null;
        }
        this.underlyingObject = null;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public Double getMinimum() {
        return this.minimum;
    }

    public String getEndOffset() {
        return this.endOffset;
    }

    public Boolean isGridInFront() {
        return this.gridInFront;
    }

    public String getLabel() {
        return this.label;
    }

    public Double getContinuousMajorTickAnchor() {
        return this.continuousMajorTickAnchor;
    }

    public Integer getContinuousMajorTickCount() {
        return this.continuousMajorTickCount;
    }

    public Double getContinuousMajorTickInterval() {
        return this.continuousMajorTickInterval;
    }

    public String getContinuousMajorTickPositionPolicy() {
        return this.continuousMajorTickPositionPolicy;
    }

    public Integer getMajorTickTimeInterval() {
        return this.majorTickTimeInterval;
    }

    public Integer getContinuousMinorTickCount() {
        return this.continuousMinorTickCount;
    }

    public Boolean isReverseDirection() {
        return this.reverseDirection;
    }

    public String getStartOffset() {
        return this.startOffset;
    }

    public Boolean isVisible() {
        return this.visible;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public void setEndOffset(String endOffset) {
        this.endOffset = endOffset;
    }

    public void setGridInFront(Boolean gridInFront) {
        this.gridInFront = gridInFront;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setContinuousMajorTickAnchor(Double majorTickAnchor) {
        this.continuousMajorTickAnchor = majorTickAnchor;
    }

    public void setContinuousMajorTickCount(Integer majorTickCount) {
        this.continuousMajorTickCount = majorTickCount;
    }

    public void setContinuousMajorTickInterval(Double majorTickInterval) {
        this.continuousMajorTickInterval = majorTickInterval;
    }

    public void setContinuousMajorTickPositionPolicy(String majorTickPlacementType) {
        this.continuousMajorTickPositionPolicy = majorTickPlacementType;
    }

    public void setMajorTickTimeInterval(Integer majorTickTimeInterval) {
        this.majorTickTimeInterval = majorTickTimeInterval;
    }

    public void setContinuousMinorTickCount(Integer minorTickCount) {
        this.continuousMinorTickCount = minorTickCount;
    }

    public void setReverseDirection(Boolean reverseDirection) {
        this.reverseDirection = reverseDirection;
    }

    public void setStartOffset(String startOffset) {
        this.startOffset = startOffset;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public String getCategories() {
        return this.categories;
    }

    public void setCategories(String categories) {
        this.categories = categories;
    }

    public String getContinuousMajorTickValues() {
        return this.continuousMajorTickValues;
    }

    public void setContinuousMajorTickValues(String majorTickValues) {
        this.continuousMajorTickValues = majorTickValues;
    }

    public String getLabelPlacementPolicy() {
        return this.labelPlacementPolicy;
    }

    public void setLabelPlacementPolicy(String labelPlacementPolicy) {
        this.labelPlacementPolicy = labelPlacementPolicy;
    }

    @Override
    protected void applyAttributes() throws JspException {
        int i;
        String[] indexes;
        int count;
        StringTokenizer tk;
        super.applyAttributes();
        this.underlyingObject = (AxisModel)this.getWrappedObject();
        if (this.gridInFront != null) {
            this.underlyingObject.setGridInFront(this.gridInFront.booleanValue());
        }
        if (this.label != null) {
            this.underlyingObject.setLabel(this.label);
        }
        if (this.visible != null) {
            this.underlyingObject.setVisible(this.visible.booleanValue());
        }
        if (this.endOffset != null) {
            this.underlyingObject.setEndOffset(new BaseLength(this.endOffset));
        }
        if (this.startOffset != null) {
            this.underlyingObject.setStartOffset(new BaseLength(this.startOffset));
        }
        if (this.reverseDirection != null) {
            this.underlyingObject.setReverseDirection(this.reverseDirection.booleanValue());
        }
        if (this.continuousMajorTickPositionPolicy != null) {
            this.underlyingObject.setContinuousMajorTickPositionPolicy(GraphConstants.TICK_POSITION.valueOfJSPAttribute(this.continuousMajorTickPositionPolicy));
        }
        if (this.continuousMajorTickCount != null) {
            this.underlyingObject.setContinuousMajorTickCount(this.continuousMajorTickCount.intValue());
        }
        if (this.continuousMinorTickCount != null) {
            this.underlyingObject.setContinuousMinorTickCount(this.continuousMinorTickCount.intValue());
        }
        if (this.continuousMajorTickInterval != null) {
            this.underlyingObject.setContinuousMajorTickInterval(this.continuousMajorTickInterval.doubleValue());
        }
        if (this.continuousMajorTickAnchor != null) {
            this.underlyingObject.setContinuousMajorTickAnchor(this.continuousMajorTickAnchor.doubleValue());
        }
        if (this.majorTickTimeInterval != null) {
            this.underlyingObject.setMajorTickTimeInterval(this.majorTickTimeInterval.intValue());
        }
        if (this.categories != null && this.categories.length() > 0) {
            tk = new StringTokenizer(this.categories.trim(), " ", false);
            count = tk.countTokens();
            indexes = new String[count];
            for (i = 0; i < count; ++i) {
                indexes[i] = tk.nextToken();
            }
            this.underlyingObject.setCategories(indexes);
        }
        if (this.continuousMajorTickValues != null && this.continuousMajorTickValues.length() > 0) {
            tk = new StringTokenizer(this.continuousMajorTickValues.trim(), " ", false);
            count = tk.countTokens();
            indexes = (String[])new double[count];
            for (i = 0; i < count; ++i) {
                indexes[i] = (String)Double.parseDouble(tk.nextToken());
            }
            this.underlyingObject.setContinuousMajorTickValues((double[])indexes);
        }
        if (this.maximum != null) {
            this.underlyingObject.setMaximum(this.maximum.doubleValue());
        }
        if (this.minimum != null) {
            this.underlyingObject.setMinimum(this.minimum.doubleValue());
        }
        if (this.labelPlacementPolicy != null) {
            this.underlyingObject.setLabelPlacementPolicy(GraphConstants.PLACEMENT.valueOfJSPAttribute(this.labelPlacementPolicy));
        }
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.getWrappedClassName() == null) {
            this.setWrappedClassName("com.sas.graphics.components.AxisModel");
        }
        super.doStartTag();
        return 2;
    }
}

