/*
 * Decompiled with CFR 0.152.
 */
package com.sas.taglib;

import com.sas.codepolicy.SASScope;
import com.sas.framework.themes.client.Theme;
import com.sas.servlet.util.BaseUtil;
import com.sas.taglib.BaseThemedTag;
import jakarta.servlet.jsp.JspException;
import java.io.IOException;
import java.util.Locale;

@SASScope
public final class ThemedImageTag
extends BaseThemedTag {
    private static final long serialVersionUID = -2334443786881893633L;
    private String image;
    private String onClick;
    private String imgID;
    private String bundle;

    public void setImage(String image) {
        this.image = image;
    }

    String getImage() {
        return this.image;
    }

    public int doEndTag() throws JspException {
        this.getLogger().debug("Writing img tag for image key:", this.getImage());
        Theme theme = this.getTheme();
        if (!theme.isValidName("IMAGE", this.getImage())) {
            this.getLogger().error("This image is not a valid themed image: " + this.getImage());
        } else {
            try {
                this.pageContext.getOut().print(BaseUtil.getImageFromTheme((Theme)theme, (String)this.getImage(), (String)this.getImgID(), (String)this.getOnClick(), (String)this.getBundle(), (Locale)this.getLocale()));
            }
            catch (IOException e) {
                throw new JspException((Throwable)e);
            }
        }
        return super.doEndTag();
    }

    @Override
    public void release() {
        this.onClick = null;
        this.imgID = null;
        this.image = null;
        this.bundle = null;
        super.release();
    }

    String getOnClick() {
        return this.onClick;
    }

    public void setOnClick(String onClick) {
        this.onClick = onClick;
    }

    String getBundle() {
        return this.bundle;
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    String getImgID() {
        return this.imgID;
    }

    public void setImgID(String imgID) {
        this.imgID = imgID;
    }
}

