/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.util.LocalizableString;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.LocalizedText;
import com.sas.util.xmlpersist.impl.RB;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class PersistHelper {
    private PersistHelper() {
    }

    static void writeRelatedObjects(List<PersistenceInterface> objsToWrite, Node parentNode, PromptsWritingContext writingContext, String relationshipName) throws BackingStoreException {
        int size;
        if (objsToWrite != null && (size = objsToWrite.size()) > 0) {
            Element newSubelement = PersistHelper.newSubelement(parentNode, relationshipName);
            for (int i = 0; i < size; ++i) {
                PersistenceInterface obj = objsToWrite.get(i);
                obj.write(newSubelement, writingContext);
            }
        }
    }

    public static void removeUnreferencedPersistenceIDs(Element thisElement, PromptsWritingContext writingContext) {
        String persistenceID = thisElement.getAttribute("obj");
        if (persistenceID != null && !writingContext.wasPersistenceIDReferenced(persistenceID)) {
            thisElement.removeAttribute("obj");
        }
        List subelements = XmlUtil.getSubelements(thisElement);
        int count = subelements.size();
        for (int i = 0; i < count; ++i) {
            Element subelement = (Element)subelements.get(i);
            PersistHelper.removeUnreferencedPersistenceIDs(subelement, writingContext);
        }
    }

    static void writeReferenceUnder(Node parentNode, PromptsWritingContext writingContext, PersistenceInterface model) {
        Element refElement = PersistHelper.newSubelement(parentNode, writingContext.getWriteUseElementName(model.getDefinitionElementName()));
        String idValue = writingContext.getPersistenceID(model);
        writingContext.noteReferenceToPersistenceID(idValue);
        if (idValue != null) {
            refElement.setAttribute("ref", idValue);
        }
    }

    static Element newSubelement(Node parentNode, String newElementName) {
        Document doc = null;
        doc = parentNode instanceof Document ? (Document)parentNode : parentNode.getOwnerDocument();
        Element element = doc.createElement(newElementName);
        parentNode.appendChild(element);
        return element;
    }

    public static List getAllText(LocalizableString localizableString, LoggerFactoryInterface factory) {
        LinkedList<LocalizedText> list = new LinkedList<LocalizedText>();
        List locales = localizableString.getLocales();
        if (locales != null) {
            for (Locale locale : locales) {
                String text = localizableString.getText(locale);
                if (null == text || "".equals(text)) continue;
                LocalizedText t = new LocalizedText();
                t.setLocale(locale);
                t.setText(text);
                list.add(t);
            }
        }
        return list;
    }

    public static String parseSBIPUrl(String url) {
        String retVal = null;
        if (null != url) {
            String upUrl = url;
            upUrl = upUrl.toUpperCase();
            String temp = null;
            if (upUrl.startsWith("SBIP://")) {
                temp = url.substring("SBIP://".length());
                int index = temp.indexOf("/");
                if (index < 0) {
                    String msg = MessageFormat.format(RB.getStringResource("PersistHelper.illegalSBIP.fmt.log"), url);
                    throw new IllegalArgumentException(msg);
                }
                retVal = temp.substring(index);
            } else if (upUrl.startsWith("URL::")) {
                temp = url.substring("URL::".length());
                int index = temp.indexOf("/");
                if (index != 0) {
                    String msg = MessageFormat.format(RB.getStringResource("PersistHelper.illegalURL.fmt.log"), url);
                    throw new IllegalArgumentException(msg);
                }
                retVal = temp;
            } else {
                retVal = url;
            }
        }
        return retVal;
    }
}

