/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.xmlpersist.impl;

import com.sas.util.ListFactory;
import com.sas.util.log.CommonLoggerInterface;
import com.sas.util.log.LoggerFactoryInterface;
import com.sas.util.log.LoggerRepository2;
import com.sas.util.log.log4j.Log4JFactory2;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.RelatedObjectList;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXException;

final class DefaultRelatedObjectListsHolder
implements RelatedObjectListsHolder {
    private PromptsReadingContext readingContext;
    private PersistenceInterface _object;
    private static final int INITIAL_RELATIONSHIP_COUNT = 1;
    private static final int ROL_COUNT_INCREMENT = 2;
    private String[] _relationshipNames = new String[1];
    private RelatedObjectList[] _relatedObjectLists = new RelatedObjectList[1];
    private int _relationshipsCount;
    private int _relationshipsCountRemainingToBeConsumed;
    private boolean _parserIsInterningStrings;
    private LoggerFactoryInterface factory = null;
    private CommonLoggerInterface logger = null;

    public DefaultRelatedObjectListsHolder(PersistenceInterface object, PromptsReadingContext readingContext, boolean parserIsInterningStrings, RelatedObjectList[] rolsToStartWith) throws SAXException {
        this.readingContext = readingContext;
        this._parserIsInterningStrings = parserIsInterningStrings;
        this.reinitializeForAdditionOfRelatedItemLists(object, rolsToStartWith);
    }

    @Override
    public void reinitializeForAdditionOfRelatedItemLists(PersistenceInterface object, RelatedObjectList[] rolsToStartWith) throws SAXException {
        this._object = object;
        this._relationshipsCount = 0;
        this._relationshipsCountRemainingToBeConsumed = 0;
        if (rolsToStartWith != null) {
            for (int i = 0; i < rolsToStartWith.length; ++i) {
                this.add(rolsToStartWith[i]);
            }
        }
    }

    @Override
    public PromptsReadingContext getReadingContext() {
        return this.readingContext;
    }

    @Override
    public void add(RelatedObjectList rol) throws SAXException {
        char char0;
        String relationshipName;
        if (this._relatedObjectLists.length == this._relationshipsCount) {
            int oldSize = this._relatedObjectLists.length;
            int newSize = oldSize + 2;
            RelatedObjectList[] newRol = new RelatedObjectList[newSize];
            System.arraycopy(this._relatedObjectLists, 0, newRol, 0, oldSize);
            this._relatedObjectLists = newRol;
            String[] newRelationshipNames = new String[newSize];
            System.arraycopy(this._relationshipNames, 0, newRelationshipNames, 0, oldSize);
            this._relationshipNames = newRelationshipNames;
        }
        this._relatedObjectLists[this._relationshipsCount] = rol;
        this._relationshipNames[this._relationshipsCount] = relationshipName = rol.getRelationshipName();
        if (relationshipName.length() > 0 && ((char0 = relationshipName.charAt(0)) < 'A' || char0 > 'Z')) {
            throw new SAXException("Invalid relationship name in XML: \"" + relationshipName + "\".  It must start with an upper case character.");
        }
        ++this._relationshipsCount;
        ++this._relationshipsCountRemainingToBeConsumed;
    }

    @Override
    public boolean hasRelatedObjectsToBeConsumed() {
        return this._relationshipsCountRemainingToBeConsumed > 0;
    }

    @Override
    public PersistenceInterface getObject() {
        return this._object;
    }

    @Override
    public int getRelationshipsCount() {
        return this._relationshipsCount;
    }

    @Override
    public RelatedObjectList[] trustedGetROLsStorage() {
        return this._relatedObjectLists;
    }

    @Override
    public ArrayList consumeObjects(String relationshipName) {
        return this.consumeObjects(relationshipName, (Class)null);
    }

    public ArrayList consumeObjects(String relationshipName, Class allowedType) {
        ArrayList out = null;
        int index = this.getIndexOfRelatedObjectList(relationshipName);
        if (index == -1) {
            out = new ArrayList(0);
        } else {
            out = this._relatedObjectLists[index].getObjects();
            this._relationshipNames[index] = null;
            --this._relationshipsCountRemainingToBeConsumed;
            if (allowedType != null) {
                DefaultRelatedObjectListsHolder.typeCheckNoNulls(out, allowedType);
            }
        }
        return out;
    }

    private static void typeCheckNoNulls(List list, Class type) {
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object obj = list.get(i);
                if (obj == null) {
                    throw new ClassCastException("Null value not allowed in list of " + type.getName() + " objects");
                }
                if (type.isInstance(obj)) continue;
                throw new ClassCastException("An object of type " + obj.getClass().getName() + " is not of the required type " + type.getName());
            }
        }
    }

    @Override
    public List consumeObjectsReturningDefensibleList(String relationshipName) {
        List out = null;
        int index = this.getIndexOfRelatedObjectList(relationshipName);
        if (index == -1) {
            out = ListFactory.newList((int)0);
        } else {
            out = this._relatedObjectLists[index].getObjectsReturningDefensibleList();
            this._relationshipNames[index] = null;
            --this._relationshipsCountRemainingToBeConsumed;
        }
        return out;
    }

    @Override
    public PersistenceInterface consumeObject(String relationshipName) throws SAXException {
        PersistenceInterface out = null;
        int index = this.getIndexOfRelatedObjectList(relationshipName);
        if (index != -1) {
            out = this._relatedObjectLists[index].getObject();
            this._relationshipNames[index] = null;
            --this._relationshipsCountRemainingToBeConsumed;
        }
        if (null != out) {
            this.getLogger().debug("consumeObject for", out.toString());
        }
        return out;
    }

    private int getIndexOfRelatedObjectList(String relationshipName) {
        int index = -1;
        if (this._relationshipsCountRemainingToBeConsumed > 0) {
            for (int i = 0; i < this._relationshipsCount; ++i) {
                String slotName = this._relationshipNames[i];
                if (slotName != relationshipName && (slotName == null || this._parserIsInterningStrings || !slotName.equals(relationshipName))) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    @Override
    public String getFirstUnconsumedRelationshipName() {
        String out = null;
        if (this._relationshipsCountRemainingToBeConsumed > 0) {
            for (int i = 0; i < this._relationshipsCount; ++i) {
                if (this._relationshipNames[i] == null) continue;
                out = this._relationshipNames[i];
                break;
            }
        }
        if (null != out) {
            this.getLogger().debug("FirstUnconsumedRelationshipName is", out);
        }
        return out;
    }

    private CommonLoggerInterface getLogger() {
        if (null == this.logger) {
            this.logger = LoggerRepository2.getLogger(this.getClass().getName(), new Log4JFactory2());
        }
        return this.logger;
    }
}

