/*
 * Decompiled with CFR 0.152.
 */
package com.sas.swing.models;

import com.sas.util.UncheckedException;
import javax.swing.table.TableModel;

public class TableModelInsertRowSupport {
    private int uncommittedRowNumber = -1;
    private boolean uncommittedRowPresent = false;
    private Object[] data = null;

    public void insertUncommittedRow(TableModel model, int row) throws UncheckedException {
        this.uncommittedRowNumber = row == -1 ? model.getRowCount() : row;
        this.uncommittedRowPresent = true;
        this.data = TableModelInsertRowSupport.getDefaultRowValues(model);
    }

    public Object[] commitUncommittedRow(TableModel model) throws UncheckedException {
        this.uncommittedRowNumber = -1;
        this.uncommittedRowPresent = false;
        return this.data;
    }

    public void cancelUncommittedRow(TableModel model) throws UncheckedException {
        this.uncommittedRowNumber = -1;
        this.uncommittedRowPresent = false;
        this.data = null;
    }

    public boolean isUncommittedRowPresent() {
        return this.uncommittedRowPresent;
    }

    public int getUncommittedRowNumber() {
        return this.uncommittedRowNumber;
    }

    public Object getValueAt(int columnIndex) {
        return this.data[columnIndex];
    }

    public void setValueAt(Object value, int columnIndex) {
        this.data[columnIndex] = value;
    }

    public int getAdjustedRowNumber(int row) {
        if (this.isUncommittedRowPresent() && row >= this.uncommittedRowNumber) {
            --row;
        }
        return row;
    }

    public static Object[] getDefaultRowValues(TableModel model) {
        int count = model.getColumnCount();
        Object[] values = new Object[count];
        for (int i = 0; i < count; ++i) {
            try {
                Class<?> c = model.getColumnClass(i);
                if (c == Object.class) {
                    values[i] = null;
                    continue;
                }
                values[i] = c.newInstance();
                continue;
            }
            catch (InstantiationException instantiationException) {
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return values;
    }
}

