/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.form.dto;

import com.sas.util.LocalizableString;
import com.sas.util.xmlpersist.XmlUtil;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LocalizableStringDTO
implements Serializable {
    private String defaultLocale;
    private LinkedHashMap<String, String> localeToTextMap = new LinkedHashMap();

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(String defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public LinkedHashMap<String, String> getLocaleToTextMap() {
        return this.localeToTextMap;
    }

    public void setLocaleToTextMap(LinkedHashMap<String, String> localeToTextMap) {
        this.localeToTextMap = localeToTextMap;
    }

    public static LocalizableStringDTO newLocalizedStringDTO(LocalizableString string) {
        if (string != null) {
            LocalizableStringDTO dto = new LocalizableStringDTO();
            if (string.getDefaultLocale() != null) {
                dto.setDefaultLocale(XmlUtil.localeToXml(string.getDefaultLocale()));
            }
            List locales = string.getLocales();
            for (Locale locale : locales) {
                dto.getLocaleToTextMap().put(XmlUtil.localeToXml(locale), string.getText(locale));
            }
            return dto;
        }
        return null;
    }

    public static LocalizableString newLocalizedString(LocalizableStringDTO dto) {
        if (dto != null) {
            LocalizableString string = new LocalizableString();
            if (dto.getDefaultLocale() != null) {
                string.setDefaultLocale(XmlUtil.xmlToLocale(dto.getDefaultLocale()));
            }
            LinkedHashMap<String, String> map = dto.getLocaleToTextMap();
            Set entries = map.entrySet();
            for (Map.Entry entry : entries) {
                string.setText((String)entry.getValue(), XmlUtil.xmlToLocale((String)entry.getKey()));
            }
            return string;
        }
        return null;
    }
}

