/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueretriever;

import com.sas.PublicClonable;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.editableproperties.UnexpectedLocalizationException;
import com.sas.storage.valueretriever.LanguageSet;
import com.sas.storage.valueretriever.LocaleToListMap;
import com.sas.storage.vr.dto.ColumnValueItem;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.uiconfig.ApplicationContext;
import com.sas.uiconfig.ResourceBundleDelegate;
import com.sas.util.AttributeConfigurationInterface;
import com.sas.util.UsageVersion;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public final class LocalizableColumn
extends AbstractPersistence
implements PublicClonable,
MultiLocaleProperties,
AttributeConfigurationInterface {
    private static final long serialVersionUID = 1L;
    private static final String VR_CONFIG_ID = "vrConfigID";
    private static final String LanguageSets = "LanguageSets";
    private LocalizablePersistableString columnHeader = new LocalizablePersistableString();
    private LocaleToListMap rowData = new LocaleToListMap();
    private ColumnValueItem item = new ColumnValueItem();
    private transient ResourceBundleDelegate resourceBundleDelegate;

    public void addColumnValueItem(@NotNull ColumnValueItem item) {
        LocalizableColumn.validate(item);
        ValidateArg.notBlank((String)item.getLocale(), (String)"item.getLocale");
        Locale locale = XmlUtil.xmlToLocale(item.getLocale());
        if (item.getLabel() != null && null != locale) {
            this.columnHeader.setText(item.getLabel(), locale);
        }
        if (locale == null) {
            throw new IllegalArgumentException("This item must contain a valid locale.");
        }
        this.rowData.put(locale, item.getRowData());
    }

    public void setColumnValueItem(@NotNull ColumnValueItem item) {
        Locale locale;
        LocalizableColumn.validate(item);
        ValidateArg.notBlank((String)item.getLocale(), (String)"item.getLocale");
        this.item = LocalizableColumn.copyInColumnValueItem(item);
        this.columnHeader.clearAll();
        if (this.item.getLabel() != null && null != (locale = XmlUtil.xmlToLocale(this.item.getLocale()))) {
            this.columnHeader.setText(item.getLabel(), locale);
        }
        this.rowData.clear();
        locale = XmlUtil.xmlToLocale(item.getLocale());
        if (locale == null) {
            throw new IllegalArgumentException("This item must contain a valid locale.");
        }
        this.rowData.put(locale, this.item.getRowData());
        this.item.getRowData().clear();
    }

    public ColumnValueItem getColumnValueItem(@NotNull Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        ColumnValueItem retVal = this.copyOutColumnValueItem(locale);
        Object list = this.rowData.get(locale);
        if (null != list) {
            if (null != this.getResourceBundleDelegate() && LocalizableColumn.isString(retVal)) {
                if (!list.isEmpty()) {
                    ArrayList<String> modifiedText = new ArrayList<String>();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Object text = iterator.next();
                        String delText = this.getResourceBundleDelegate().getText((String)text, locale);
                        if (null != delText) {
                            modifiedText.add(delText);
                            continue;
                        }
                        modifiedText.add((String)text);
                    }
                    retVal.getRowData().addAll(modifiedText);
                    this.getLogger2().debug("returning all localized rows using resource bundle delegate");
                }
            } else {
                Object rowList = this.rowData.get(locale);
                if (null != rowList) {
                    retVal.getRowData().addAll(rowList);
                }
                this.getLogger2().debug("returning all localized rows, if any.");
            }
        }
        return retVal;
    }

    private final ColumnValueItem copyOutColumnValueItem(Locale locale) {
        String delText;
        ValidateArg.notNull((Object)locale, (String)"locale");
        ColumnValueItem retVal = new ColumnValueItem();
        String text = this.columnHeader.getText(locale);
        if (null != this.getResourceBundleDelegate() && null != (delText = this.getResourceBundleDelegate().getText(text, locale))) {
            text = delText;
        }
        retVal.setLabel(text);
        retVal.setName(this.item.getName());
        retVal.setLocale(locale.toString());
        retVal.setDataType(this.item.getDataType());
        return retVal;
    }

    public String toString() {
        return this.item.getName() + " " + this.item.getDataType();
    }

    public static boolean matches(ColumnValueItem item0, ColumnValueItem item1) {
        LocalizableColumn.validate(item0);
        LocalizableColumn.validate(item1);
        String item0DataType = null;
        String item0Name = null;
        String item0String = null;
        item0Name = item0.getName();
        item0DataType = item0.getDataType().value();
        item0String = item0Name + item0DataType;
        String item1DataType = null;
        String item1Name = null;
        String item1String = null;
        item1Name = item1.getName();
        item1DataType = item1.getDataType().value();
        item1String = item1Name + item1DataType;
        return item0String.equals(item1String);
    }

    private static void validate(ColumnValueItem item) {
        ValidateArg.notNull((Object)item, (String)"ColumnValueItem");
        ValidateArg.notNull((Object)item.getDataType(), (String)"ColumnValueItem.getDataType()");
        ValidateArg.notBlank((String)item.getName(), (String)"ColumnValueItem.getName()");
    }

    public String getColumnName() {
        return this.item.getName();
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        ApplicationContext context;
        Map<String, Object> map;
        String locString;
        String dtString;
        super.consumeAttributes(provider);
        String nameString = provider.consumeAttr("columnName");
        if (null != nameString) {
            this.getLogger2().debug("consumeAttributes(), ", nameString);
            this.item.setName(nameString);
        }
        if (null != (dtString = provider.consumeAttr("dataType"))) {
            this.getLogger2().debug("consumeAttributes(), make dataType:", dtString);
            this.item.setDataType(ValueDataTypeEnum.valueOf((String)dtString));
        }
        if (null != (locString = provider.consumeAttr("xml:lang"))) {
            this.getLogger2().debug("locale is: ", locString);
            this.item.setLocale(locString.replace("-", "_"));
        }
        this.item.setVRConfigId(provider.consumeAttr(VR_CONFIG_ID));
        PromptsReadingContext prContext = provider.getReadingContext();
        if (null != prContext && null != prContext.getOptionsMap() && (map = prContext.getOptionsMap()).containsKey("com.sas.uiconfig.ApplicationContext") && null != (context = (ApplicationContext)map.get("com.sas.uiconfig.ApplicationContext"))) {
            this.resourceBundleDelegate = context.getResourceBundleDelegate();
        }
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList valuesList;
        super.consumeRelatedObjects(roHolder);
        ArrayList msgList = roHolder.consumeObjects("HeaderText");
        if (!msgList.isEmpty()) {
            this.columnHeader = (LocalizablePersistableString)msgList.get(0);
            this.getLogger2().debug("consumeRelatedObjects() for columnLabel");
        }
        if (!(valuesList = roHolder.consumeObjects(LanguageSets)).isEmpty()) {
            this.getLogger2().debug("consumeRelatedObjects() for LanguageSets");
            LinkedList<Object> rows = new LinkedList<Object>();
            for (LanguageSet element : valuesList) {
                Locale locale = element.getLocale();
                List<BasePersistedValue> valueList = element.getRows();
                for (BasePersistedValue value : valueList) {
                    rows.add(value.getValue());
                }
                this.rowData.put(locale, (List<Object>)rows);
                rows.clear();
            }
        }
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("writeDefinition for item named", this.item.getName());
        XmlUtil.setAttr(element, "columnName", this.item.getName());
        if (null != this.item.getDataType()) {
            XmlUtil.setAttr(element, "dataType", this.item.getDataType().toString());
        }
        if (null != this.item.getVRConfigId()) {
            XmlUtil.setAttr(element, VR_CONFIG_ID, this.item.getVRConfigId());
        }
        if (!this.columnHeader.getLocales().isEmpty()) {
            ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
            list.add(this.columnHeader);
            this.getLogger2().debug("Writing header text.");
            LocalizableColumn.writeRelatedObjects(list, element, writingContext, "HeaderText");
        }
        ArrayList<PersistenceInterface> listValues = new ArrayList<PersistenceInterface>();
        Set<Map.Entry<Locale, List<Object>>> set = this.rowData.entrySet();
        for (Map.Entry<Locale, List<Object>> entry : set) {
            LanguageSet lSet = new LanguageSet();
            lSet.setLocale(entry.getKey());
            for (Object o : entry.getValue()) {
                PersistenceInterface p = ValueUtil.getPersistableValue(o);
                if (!(p instanceof BasePersistedValue)) continue;
                BasePersistedValue t = (BasePersistedValue)p;
                t.setValue(o);
                lSet.getRows().add(t);
            }
            listValues.add(lSet);
        }
        LocalizableColumn.writeRelatedObjects(listValues, element, writingContext, LanguageSets);
    }

    public Object clone() throws CloneNotSupportedException {
        LocalizableColumn retVal = (LocalizableColumn)super.clone();
        retVal.columnHeader = (LocalizablePersistableString)this.columnHeader.clone();
        LocaleToListMap temp = new LocaleToListMap();
        temp.putAll(this.rowData);
        retVal.rowData = temp;
        return retVal;
    }

    @Override
    public void beginLocalization() throws UnexpectedLocalizationException {
    }

    @Override
    public void endLocalization() throws UnexpectedLocalizationException {
    }

    @Override
    public void setLocalizableProperties(Locale locale, PropertyMap map) throws UnexpectedLocalizationException {
        ValidateArg.notNull((Object)locale, (String)"locale");
        ValidateArg.notNull((Object)map, (String)"property map");
        this.getLogger2().debug("setLocalizableProperties on :", this.item.getName());
        this.columnHeader.setLocalizableProperties(locale, map);
        int[] indexes = map.getPropertyIndexes("rowLabel");
        if (null != indexes && indexes.length > 0) {
            ArrayList<Object> input = new ArrayList<Object>();
            for (int i = 0; i < indexes.length; ++i) {
                input.add(map.getProperty("rowLabel", i));
            }
            this.rowData.put(locale, (List<Object>)input);
            this.getLogger2().debug("setting row labels for locale", locale.toString());
        }
    }

    public Collection getLocales() throws UnexpectedLocalizationException {
        return this.columnHeader.getLocales();
    }

    @Override
    public PropertyList getLocalizableProperties(Locale locale) throws UnexpectedLocalizationException {
        PropertyList list = this.columnHeader.getLocalizableProperties(locale);
        if (ValueDataTypeEnum.STRING.equals((Object)this.item.getDataType())) {
            Object rowLabels;
            if (!this.rowData.containsKey(locale)) {
                this.getLogger2().warn("getLocalizableProperties(), row data does not contain an exact locale match for ", locale.toString());
            }
            if (null != (rowLabels = this.rowData.get(locale)) && !rowLabels.isEmpty()) {
                int i = 0;
                Iterator iterator = rowLabels.iterator();
                while (iterator.hasNext()) {
                    Object label = iterator.next();
                    list.addProperty("rowLabel", i, (String)label);
                    ++i;
                }
                this.getLogger2().debug("getLocalizableProperties(), added row labels for ", this.item.getName());
            }
        }
        return list;
    }

    @Override
    public PropertyList getLocalizableProperties() throws UnexpectedLocalizationException {
        return this.getLocalizableProperties(Locale.getDefault());
    }

    @Override
    public void setLocalizableProperties(PropertyMap map) throws UnexpectedLocalizationException {
        this.setLocalizableProperties(Locale.getDefault(), map);
    }

    public final ResourceBundleDelegate getResourceBundleDelegate() {
        return this.resourceBundleDelegate;
    }

    public final void setResourceBundleDelegate(ResourceBundleDelegate resourceBundleDelegate) {
        this.resourceBundleDelegate = resourceBundleDelegate;
    }

    private static ColumnValueItem copyInColumnValueItem(ColumnValueItem item) {
        ColumnValueItem retVal = null;
        if (null != item) {
            retVal = new ColumnValueItem();
            retVal.setDataType(item.getDataType());
            retVal.setLabel(item.getLabel());
            retVal.setLocale(item.getLocale());
            retVal.setName(item.getName());
            retVal.setVRConfigId(item.getVRConfigId());
            if (!item.getRowData().isEmpty()) {
                retVal.getRowData().addAll(item.getRowData());
            }
        }
        return retVal;
    }

    private static boolean isString(ColumnValueItem cvi) {
        boolean retVal = false;
        LocalizableColumn.validate(cvi);
        if (ValueDataTypeEnum.STRING.equals((Object)cvi.getDataType())) {
            retVal = true;
        }
        return retVal;
    }

    @Override
    public String getVersion() {
        return new UsageVersion(2, 0).toString();
    }

    public static LocalizableColumn newColumn(@NotNull ColumnValueItem item) {
        LocalizableColumn.validate(item);
        LocalizableColumn retVal = new LocalizableColumn();
        retVal.setColumnValueItem(item);
        return retVal;
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        ValidateArg.notNull(options, (String)"options");
        this.getLogger2().debug("configureAttributes starting");
        if (null != context) {
            ColumnValueItem input = (ColumnValueItem)options.get("Column");
            if (null != input) {
                if (LocalizableColumn.matches(this.item, input)) {
                    Locale locale1 = XmlUtil.xmlToLocale((String)context.get("__SAS_Locale"));
                    if (null != locale1) {
                        this.configure(locale1, input);
                    } else {
                        this.getLogger2().warn("No locale was in the context passed to configureAttributes() yet the supplied column matches. The method will do nothing.");
                    }
                } else {
                    this.getLogger2().debug("The supplied column does not match this instance so it will replace this instance.");
                    this.getLogger2().debug("This column is", this.toString());
                    this.getLogger2().debug("The supplied column is", input.getName() + input.getDataType());
                    this.setColumnValueItem(input);
                }
            }
        } else {
            this.getLogger2().warn("No column item was in the options passed to configureAttributes(). The method will do nothing.");
        }
    }

    private void configure(Locale locale, ColumnValueItem input) {
        this.columnHeader.setText(input.getLabel(), locale);
        if (null != input.getRowData()) {
            if (this.rowData.containsKey(locale)) {
                this.rowData.remove(locale);
            }
            this.rowData.put(locale, input.getRowData());
            this.getLogger2().debug("configured row labels for", this.item.getName() + " locale: " + locale.toString());
        }
    }

    public boolean matchesMe(ColumnValueItem input) {
        return LocalizableColumn.matches(this.item, input);
    }

    @Override
    public String getDefinitionElementName() {
        return "LocalizableColumn";
    }
}

