/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueprovider.jdbc;

import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.StringType;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.swing.tree.TreeModel;

public class JDBCValueProvider
extends AbstractPersistence {
    public static final String CONFIGURE_QUERY = "QUERY";
    protected String query = null;
    protected Collection labelsandValuesList;
    protected String lastExpandedQuery = null;
    protected Connection connection;

    public int count() throws ValueProviderException {
        return 0;
    }

    public DataTypeInterface getDataType() {
        return StringType.DEFAULT_INSTANCE;
    }

    public Object getValues(Locale locale, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        return this.getValues(ValueType.LIST, searchCriteria, index, count);
    }

    public Object getValues(Locale locale, ValueType returnType, int index, int count) throws ValueProviderException {
        return this.getValues(returnType, null, index, count);
    }

    private Object getValues(ValueType returnType, SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        Object returnObject = null;
        if (returnType == ValueType.TREE) {
            returnObject = this.getValuesAsTree();
        } else if (returnType == ValueType.LIST) {
            returnObject = this.getValuesAsList(searchCriteria, index, count);
        } else {
            try {
                returnObject = this.getValuesAsTree();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            returnObject = this.getValuesAsList(searchCriteria, index, count);
        }
        return returnObject;
    }

    public TreeModel getValuesAsTree() throws ValueProviderException {
        throw new UnsupportedOperationException("This method is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getValuesAsList(SearchCriteria searchCriteria, int index, int count) throws ValueProviderException {
        block19: {
            Object statement;
            if (this.query == null || this.query.length() == 0) {
                return Collections.EMPTY_LIST;
            }
            try {
                if (this.query.equals(this.lastExpandedQuery) && this.labelsandValuesList != null) {
                    Collection collection = this.labelsandValuesList;
                    return collection;
                }
                this.labelsandValuesList = new Vector();
                this.lastExpandedQuery = this.query;
                if (this.connection != null) {
                    statement = this.connection.createStatement();
                    ResultSet resultSet = statement.executeQuery(this.query);
                    while (resultSet.next()) {
                        ValueItem vi = new ValueItem((Object)resultSet.getString(1), resultSet.getObject(1));
                        this.labelsandValuesList.add(vi);
                    }
                    statement.close();
                }
                statement = this.labelsandValuesList;
            }
            catch (Exception e) {
                e.printStackTrace();
                break block19;
            }
            finally {
                if (this.connection != null) {
                    try {
                        this.connection.close();
                    }
                    catch (SQLException sQLException) {}
                }
            }
            return statement;
        }
        return Collections.EMPTY_LIST;
    }

    public void configureProvider(Map configurationData) {
        String newQuery = (String)configurationData.get(CONFIGURE_QUERY);
        if (newQuery != null && !newQuery.equals(this.query)) {
            this.query = newQuery;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        JDBCValueProvider clone = (JDBCValueProvider)super.clone();
        clone.labelsandValuesList = (Collection)((Vector)this.labelsandValuesList).clone();
        clone.query = this.query;
        clone.lastExpandedQuery = this.lastExpandedQuery;
        clone.connection = this.connection;
        return clone;
    }
}

