/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.valueprovider;

import com.sas.datatypes.DataTypeInterface;
import com.sas.models.MutableThresholdInterface;
import com.sas.storage.valueprovider.SearchCriteria;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.valueprovider.ValueType;
import com.sas.util.SasPasswordEncodingException;
import com.sas.util.SasPasswordString;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.Locale;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public abstract class BaseDynamicValueProvider
extends AbstractPersistence
implements ValueProviderInterface,
MutableThresholdInterface {
    public static int DEFAULT_THRESHOLD = 100;
    private String host;
    private String port;
    private String userName;
    private String password;
    protected transient int threshold = DEFAULT_THRESHOLD;
    protected DataTypeInterface dataType;
    protected boolean displayValue;

    protected BaseDynamicValueProvider() {
    }

    public void setValueDisplayed(boolean displayValue) {
        this.displayValue = displayValue;
    }

    @Override
    public boolean isValueDisplayed() {
        return this.displayValue;
    }

    @Override
    public Object getValues(Locale locale) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, 0, this.threshold);
    }

    @Override
    public Object getValues(Locale locale, int index, int count) throws ValueProviderException {
        return this.getValues(locale, ValueType.LIST, index, count);
    }

    @Override
    public Object getValues(Locale locale, ValueType returnType) throws ValueProviderException {
        return this.getValues(locale, returnType, 0, this.threshold);
    }

    @Override
    public abstract Object getValues(Locale var1, ValueType var2, int var3, int var4) throws ValueProviderException;

    public Object getValues(Locale locale, SearchCriteria searchCriteria) throws ValueProviderException {
        return this.getValues(locale, searchCriteria, 0, this.threshold);
    }

    public abstract Object getValues(Locale var1, SearchCriteria var2, int var3, int var4) throws ValueProviderException;

    public abstract int count() throws ValueProviderException;

    public int getThreshold() {
        return this.threshold;
    }

    public void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getPort() {
        return this.port;
    }

    protected void setUsernamePassword(String userName, String password) {
        this.userName = userName;
        try {
            this.password = SasPasswordString.encode((String)"sas001", (String)password);
        }
        catch (SasPasswordEncodingException spe) {
            this.password = password;
        }
    }

    public String getUsername() {
        return this.userName;
    }

    protected String getPassword() {
        return this.password;
    }

    public Object clone() throws CloneNotSupportedException {
        BaseDynamicValueProvider clone = (BaseDynamicValueProvider)super.clone();
        clone.host = this.host;
        clone.port = this.port;
        return clone;
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setHost(provider.consumeAttr("host"));
        this.setPort(provider.consumeAttr("port"));
        this.setThreshold(provider.consumeIntAttr("threshold", DEFAULT_THRESHOLD));
        this.setValueDisplayed(provider.consumeBooleanAttr("valueDisplayed", false));
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr(element, "host", this.getHost());
        XmlUtil.setAttr(element, "port", this.getPort());
        XmlUtil.setIntAttr(element, "threshold", this.getThreshold(), DEFAULT_THRESHOLD);
        XmlUtil.setBooleanAttr(element, "valueDisplayed", this.isValueDisplayed(), false);
    }
}

