/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.storage.simplesqlmodel.BaseValueOperand;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.ValueOperandInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.XmlUtil;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;

public class StringOperand
extends BaseValueOperand
implements OperandInterface {
    private boolean quoted;

    public StringOperand() {
    }

    public StringOperand(String value) {
        this(value, true);
    }

    public StringOperand(String value, boolean quoted) {
        this.setValue(value);
        this.setQuoted(quoted);
    }

    public String getValueAsString() {
        return (String)this.getValue();
    }

    public void setValue(String value) {
        this.setValue((Object)value);
    }

    public final boolean isQuoted() {
        return this.quoted;
    }

    public final void setQuoted(boolean quoted) {
        this.quoted = quoted;
    }

    @Override
    public String getOperandAsString(Map context) {
        String operandString = this.getValueAsString();
        if (context != null && context.containsKey("_SAS_CONTEXT_TRIM_STRINGS")) {
            operandString = operandString.trim();
        }
        if (this.quoted) {
            return "\"" + operandString + "\"";
        }
        return this.getValueAsString();
    }

    public String toString() {
        return this.getOperandAsString(null);
    }

    @Override
    public boolean evaluateOperandAsBoolean(Locale locale, Map context) {
        if (this.getValue() == null) {
            return false;
        }
        return this.getValueAsString().length() != 0;
    }

    @Override
    public String getDefinitionElementName() {
        return "StringOperand";
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setQuoted(provider.consumeBooleanAttr("quoted", false));
        this.getLogger2().debug("Ran consumeAttributes().");
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing definition.");
        XmlUtil.setBooleanAttr(element, "quoted", this.isQuoted(), false);
    }

    @Override
    public int compareTo(ValueOperandInterface o, Locale locale) {
        if (this.getValue() == null && o.getValue() == null) {
            return 0;
        }
        if (this.getValue() == null) {
            return -1;
        }
        if (o.getValue() == null) {
            return 1;
        }
        SASStringComparator ssc = SASCollatorFactory.createCollator((Locale)locale);
        return ssc.compare(((StringOperand)o).getValueAsString(), this.getValueAsString());
    }
}

