/*
 * Decompiled with CFR 0.152.
 */
package com.sas.storage.simplesqlmodel;

import com.sas.storage.simplesqlmodel.ColumnInfo;
import com.sas.storage.simplesqlmodel.OperandInterface;
import com.sas.storage.simplesqlmodel.WhereClause;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SelectStatement
extends AbstractPersistence
implements OperandInterface {
    private String table;
    private boolean distinct;
    private List columns;
    private WhereClause whereClause;

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public List getColumns() {
        return this.columns;
    }

    public void setColumns(List columns) {
        this.columns = columns;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public WhereClause getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(WhereClause whereClause) {
        this.whereClause = whereClause;
        this.getLogger2().debug("where clause set to:", this.whereClause.toString());
    }

    public String getSelectStatement(Map context) {
        StringBuffer selectStatement = new StringBuffer(128);
        selectStatement.append("select ");
        if (this.isDistinct()) {
            selectStatement.append("distinct ");
        }
        if (this.columns != null) {
            Iterator columnIterator = this.columns.iterator();
            while (columnIterator.hasNext()) {
                OperandInterface operand = (OperandInterface)columnIterator.next();
                selectStatement.append(operand.getOperandAsString(context));
                if (columnIterator.hasNext()) {
                    selectStatement.append(", ");
                    continue;
                }
                selectStatement.append(" ");
            }
        } else {
            throw new IllegalStateException("No columns specified");
        }
        if (this.table == null) {
            throw new IllegalStateException("No table specified");
        }
        selectStatement.append("from ");
        selectStatement.append(this.table);
        if (this.whereClause != null) {
            selectStatement.append(this.whereClause.getWhereClause(context));
        }
        if (this.columns != null) {
            boolean orderByUsed = false;
            StringBuffer orderBy = new StringBuffer();
            orderBy.append(" order by ");
            Iterator columnIterator = this.columns.iterator();
            boolean addComma = false;
            while (columnIterator.hasNext()) {
                ColumnInfo columnInfo = (ColumnInfo)columnIterator.next();
                if (columnInfo.getSortOrder() == null || "".equals(columnInfo.getSortOrder())) continue;
                if (addComma) {
                    orderBy.append(", ");
                }
                orderByUsed = true;
                orderBy.append(columnInfo.getNameWithFormat());
                orderBy.append(" ");
                orderBy.append(columnInfo.getSortOrder());
                addComma = true;
            }
            if (orderByUsed) {
                selectStatement.append(orderBy);
            }
        }
        return selectStatement.toString();
    }

    @Override
    public String getOperandAsString(Map context) {
        return this.getSelectStatement(context);
    }

    @Override
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
    }

    @Override
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
    }

    @Override
    public void consumeElementText(String text) {
        super.consumeElementText(text);
    }

    @Override
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
    }
}

